%define pkgname font-utils
%define mkfontscale 1.1.0

Summary: X.Org X11 font utilities
Name: xorg-x11-%{pkgname}
# IMPORTANT: If package ever gets renamed to something else, remove the Epoch line!
Epoch: 1
Version: 7.5
%define base_release .3
Release: 15%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
License: MIT
Group: User Interface/X
URL: http://www.x.org

Source0: ftp://ftp.x.org/pub/individual/app/bdftopcf-1.0.4.tar.bz2
Source1: ftp://ftp.x.org/pub/individual/app/fonttosfnt-1.0.3.tar.bz2
Source2: ftp://ftp.x.org/pub/individual/app/mkfontdir-1.0.7.tar.bz2
Source3: ftp://ftp.x.org/pub/individual/app/mkfontscale-%{mkfontscale}.tar.bz2
Source4: ftp://ftp.x.org/pub/individual/font/font-util-1.3.0.tar.bz2
# helper script used in %post for xorg-x11-fonts
Source5: xorg-x11-fonts-update-dirs
Source999: fivextra.tar.bz2

Patch2: mkfontscale-examine-all-encodings.patch
Patch3: mkfontscale-man-page-additions.patch
Patch70201: bug-70201-backport-vasprintf.patch
Patch78947: bug-78947-add-pkgconfig-fontdir.patch

BuildRequires: pkgconfig(xfont) pkgconfig(x11)
BuildRequires: libfontenc-devel >= 0.99.2-2
BuildRequires: freetype-devel
BuildRequires: zlib-devel
BuildRequires: autoconf automake libtool
BuildRequires: xorg-x11-util-macros

Provides: %{pkgname}
Provides: bdftopcf, fonttosfnt, mkfontdir, mkfontscale, ucs2any

# bdftruncate isn't a perl script anymore (repackaged in f18)
Provides: bdftruncate = %{epoch}:%{version}-%{release}
Obsoletes: bdftruncate < %{epoch}:%{version}-%{release}

%description
X.Org X11 font utilities required for font installation, conversion,
and generation.

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -c %{name}-%{version} -a1 -a2 -a3 -a4 -a 999
oldpwd=$(pwd)
cd mkfontscale-%{mkfontscale}
%patch2 -p1 -b .all-encodings
%patch3 -p1
cd ${oldpwd}

pushd fonttosfnt-1.0.3
%patch70201 -p1
popd
%patch78947 -p1

%build
# Build all apps
{
   for app in bdftopcf fonttosfnt mkfontdir mkfontscale font-util ; do
      oldpwd=$(pwd)
      cd $app-*
      # this --with-mapdir should be redundant?
      autoreconf -vif
      %configure --with-fontrootdir=%{_datadir}/X11/fonts --with-mapdir=%{_datadir}/X11/fonts/util
      make
      cd ${oldpwd}
   done
}

pushd fivextra
make all
popd

%install
rm -rf $RPM_BUILD_ROOT
# Install all apps
{
    for app in bdftopcf fonttosfnt mkfontdir mkfontscale font-util; do
		oldpwd=$(pwd)
		cd $app-*
		make install DESTDIR=$RPM_BUILD_ROOT
		cd ${oldpwd}
	done
	for i in */README ; do
		[ -s $i ] && cp $i README-$(echo $i | sed 's/-[0-9].*//')
	done
	for i in */COPYING ; do
		grep -q stub $i || cp $i COPYING-$(echo $i | sed 's/-[0-9].*//')
	done
}

install -m 744 %{SOURCE5} ${RPM_BUILD_ROOT}%{_bindir}/xorg-x11-fonts-update-dirs
sed -i "s:@DATADIR@:%{_datadir}:" ${RPM_BUILD_ROOT}%{_bindir}/xorg-x11-fonts-update-dirs

# Steps to package the xorg-x11-font-utils tests for FIV
for dir in `cd fivextra; find . -type d`
do
       install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
       install -m 755 `find fivextra/$dir/* -type d -prune -o -print`  $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done 
find $RPM_BUILD_ROOT/%{fivdir}/%{name} -depth -name CVS -type d -exec rm -rf {} \;

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%doc README-* COPYING-bdftopcf COPYING-[c-z]*
%{_bindir}/bdftopcf
%{_bindir}/bdftruncate
%{_bindir}/fonttosfnt
%{_bindir}/mkfontdir
%{_bindir}/mkfontscale
%{_bindir}/ucs2any
%{_bindir}/xorg-x11-fonts-update-dirs
%dir %{_datadir}/X11/fonts
%dir %{_datadir}/X11/fonts/util
%{_datadir}/X11/fonts/util/map-*
%{_datadir}/aclocal/fontutil.m4
%{_libdir}/pkgconfig/fontutil.pc
%{_mandir}/man1/bdftopcf.1*
%{_mandir}/man1/bdftruncate.1*
%{_mandir}/man1/fonttosfnt.1*
%{_mandir}/man1/mkfontdir.1*
%{_mandir}/man1/mkfontscale.1*
%{_mandir}/man1/ucs2any.1*

%files fivextra
%{prefix}

%changelog
* Mon Jul 08 2013 baseuser@ibm.com
- Base-8.x spec file
