%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}

Name:           python-pycurl
Version:        7.19.0
%define base_release .6
Release:        15.1%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Summary:        A Python interface to libcurl

Group:          Development/Languages
License:        LGPLv2+ or MIT
URL:            http://pycurl.sourceforge.net/
Source0:        http://pycurl.sourceforge.net/download/pycurl-%{version}.tar.gz
Source999:      fivextra.tar.bz2

# upstream patches
Patch1:         0001-No-longer-keep-copies-of-string-options-since-this-i.patch
Patch2:         0002-Fixes-https-sourceforge.net-tracker-func-detail-aid-.patch
Patch3:         0003-Fixes-refcount-bug-and-provides-better-organization-.patch
Patch4:         0004-Test-for-reset-fixes-refcount-bug.patch
Patch5:         0005-Updating-ChangeLog-with-relevant-changes.patch

# downstream patches
Patch101:       0101-test_internals.py-add-a-test-for-ref-counting-of-res.patch
Patch102:       0102-pycurl.c-eliminate-duplicated-code-in-util_write_cal.patch
Patch103:       0103-pycurl.c-allow-to-return-1-from-write-callback.patch
Patch104:       0104-test_write_abort.py-test-returning-1-from-write-call.patch
Patch105:       0105-add-the-GLOBAL_ACK_EINTR-constant-to-the-list-of-exp.patch
Patch101278:	test_multi_socket_fix.patch

Requires:       keyutils-libs
BuildRequires:  python-devel
BuildRequires:  curl-devel >= 7.19.0
BuildRequires:  openssl-devel

# During its initialization, PycURL checks that the actual libcurl version
# is not lower than the one used when PycURL was built.
# Yes, that should be handled by library versioning (which would then get
# automatically reflected by rpm).
# For now, we have to reflect that dependency.
%global libcurl_sed '/^#define LIBCURL_VERSION "/!d;s/"[^"]*$//;s/.*"//;q'
%global curlver_h /usr/include/curl/curlver.h
%global libcurl_ver %(sed %{libcurl_sed} %{curlver_h} 2>/dev/null || echo 0)
Requires:       libcurl >= %{libcurl_ver}

Provides:       pycurl = %{version}-%{release}

%description
PycURL is a Python interface to libcurl. PycURL can be used to fetch
objects identified by a URL from a Python program, similar to the
urllib Python module. PycURL is mature, very fast, and supports a lot
of features.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup0 -q -n pycurl-%{version} -a 999
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch101 -p1
%patch102 -p1
%patch103 -p1
%patch104 -p1
%patch105 -p1
%patch101278 -p1

chmod a-x examples/*

%build
CFLAGS="$RPM_OPT_FLAGS -DHAVE_CURL_OPENSSL" %{__python} setup.py build

%check
export PYTHONPATH=$RPM_BUILD_ROOT%{python_sitearch}
make test PYTHON=%{__python}

%install
%{__python} setup.py install -O1 --skip-build --root %{buildroot}
rm -rf %{buildroot}%{_datadir}/doc/pycurl

for dir in `cd fivextra; find . -type d -not -name CVS`
do
        install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
        install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir || true
done

for dir in $(find tests -type d)
do
    install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
    install -m 755 `find $dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir || true
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

find $RPM_BUILD_ROOT/%{fivdir}/%{name} -name '*.o' | xargs rm -rf

%files
%doc COPYING COPYING2 ChangeLog README TODO examples doc tests
%{python_sitearch}/*

%files fivextra
%{prefix}

%changelog
* Mon Jun 03 2013 baseuser@ibm.com
- Base-8.x spec file
