Summary: A utility for getting files from remote servers (FTP, HTTP, and others)
Name: curl
Version: 7.29.0
%define base_release .2
Release: 17%{?dist}%{?base_release}
License: MIT
Group: Applications/Internet
Source: http://curl.haxx.se/download/%{name}-%{version}.tar.lzma
Source2: curlbuild.h
Source999: fivextra.tar.bz2

# fix a SIGSEGV when closing an unused multi handle (#914411)
Patch1: 0001-curl-7.29.0-da3fc1ee.patch

# switch SSL socket into non-blocking mode after handshake
Patch2: 0002-curl-7.29.0-9d0af301.patch

# do not ignore poll() failures other than EINTR
Patch3: 0003-curl-7.29.0-491e026c.patch

# curl_global_init() now accepts the CURL_GLOBAL_ACK_EINTR flag
Patch4: 0004-curl-7.29.0-57ccdfa8.patch

# fix cookie tailmatching to prevent cross-domain leakage (CVE-2013-1944)
Patch5: 0005-curl-7.29.0-2eb8dcf2.patch

# show proper host name on failed resolve (#957173)
Patch6: 0006-curl-7.29.0-25e577b3.patch

# prevent an artificial timeout event due to stale speed-check data (#906031)
Patch7: 0007-curl-7.29.0-b37b5233.patch

# fix heap-based buffer overflow in curl_easy_unescape() (CVE-2013-2174)
Patch8: 0008-curl-7.29.0-192c4f78.patch

# mention all option listed in 'curl --help' in curl.1 man page
Patch9: 0009-curl-7.29.0-3a0e931f.patch

# FTP: when EPSV gets a 229 but fails to connect, retry with PASV (#1002815)
Patch10: 0010-curl-7.29.0-7cc00d9a.patch

# avoid a busy-loop in curl_easy_perform() 
Patch11: 0011-curl-7.29.0-0feeab78.patch

# avoid delay if FTP is aborted in CURLOPT_HEADERFUNCTION callback (#1005686)
Patch12: 0012-curl-7.29.0-c639d725.patch

# re-use of wrong HTTP NTLM connection in libcurl (CVE-2014-0015)
Patch14: 0014-curl-7.29.0-8ae35102.patch

# ssh: improve the logic for detecting blocking direction
Patch15: 0015-curl-7.29.0-d015f4cc.patch

# use proxy name in error messages when proxy is used (#1066484)
Patch16: 0016-curl-7.29.0-1cf71bd7.patch

# refresh expired cookie in test172 from upstream test-suite (#1068967)
Patch17: 0017-curl-7.29.0-ffb8a21d.patch

# fix connection re-use when using different log-in credentials (CVE-2014-0138)
Patch18: 0018-curl-7.29.0-517b06d6.patch

# patch making libcurl multilib ready
Patch101: 0101-curl-7.29.0-multilib.patch

# prevent configure script from discarding -g in CFLAGS (#496778)
Patch102: 0102-curl-7.29.0-debug.patch

# use localhost6 instead of ip6-localhost in the curl test-suite
Patch104: 0104-curl-7.19.7-localhost6.patch

# disable valgrind for certain test-cases (libssh2 problem)
Patch106: 0106-curl-7.21.0-libssh2-valgrind.patch

# work around valgrind bug (#678518)
Patch107: 0107-curl-7.21.4-libidn-valgrind.patch

# Fix character encoding of docs, which are of mixed encoding originally so
# a simple iconv can't fix them
Patch108: 0108-curl-7.29.0-utf8.patch

# Base patches
Patch961941: bug96194-DISABLED.patch
Patch961942: bug96194-tests-Makefile.patch
Patch104606: bug-104606-support-ECDSA.patch

Provides: webclient
URL: http://curl.haxx.se/
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(id -nu)
BuildRequires: groff
BuildRequires: krb5-devel
BuildRequires: libidn-devel
BuildRequires: libssh2-devel
BuildRequires: nss-devel
BuildRequires: openldap-devel
BuildRequires: openssh-clients
BuildRequires: openssh-server
BuildRequires: pkgconfig
%{!?cross_build:BuildRequires: stunnel}
BuildRequires: zlib-devel

# perl modules used in the test suite
BuildRequires: perl(Cwd)
BuildRequires: perl(Digest::MD5)
BuildRequires: perl(Exporter)
BuildRequires: perl(File::Basename)
BuildRequires: perl(File::Copy)
BuildRequires: perl(File::Spec)
BuildRequires: perl(IPC::Open2)
BuildRequires: perl(MIME::Base64)
BuildRequires: perl(strict)
BuildRequires: perl(Time::Local)
BuildRequires: perl(Time::HiRes)
BuildRequires: perl(warnings)
BuildRequires: perl(vars)

# require valgrind to boost test coverage on i386 and x86_64
%ifarch %{ix86} x86_64
BuildRequires: valgrind
%endif

Requires: libcurl = %{version}-%{release}

# require at least the version of libssh2 that we were built against,
# to ensure that we have the necessary symbols available (#525002, #642796)
%global libssh2_version %(pkg-config --modversion libssh2 2>/dev/null || echo 0)

%description
curl is a command line tool for transferring data with URL syntax, supporting
FTP, FTPS, HTTP, HTTPS, SCP, SFTP, TFTP, TELNET, DICT, LDAP, LDAPS, FILE, IMAP,
SMTP, POP3 and RTSP.  curl supports SSL certificates, HTTP POST, HTTP PUT, FTP
uploading, HTTP form based upload, proxies, cookies, user+password
authentication (Basic, Digest, NTLM, Negotiate, kerberos...), file transfer
resume, proxy tunneling and a busload of other useful tricks. 

%package -n libcurl
Summary: A library for getting files from web servers
Group: Development/Libraries
Requires: libssh2%{?_isa} >= %{libssh2_version}

%description -n libcurl
libcurl is a free and easy-to-use client-side URL transfer library, supporting
FTP, FTPS, HTTP, HTTPS, SCP, SFTP, TFTP, TELNET, DICT, LDAP, LDAPS, FILE, IMAP,
SMTP, POP3 and RTSP. libcurl supports SSL certificates, HTTP POST, HTTP PUT,
FTP uploading, HTTP form based upload, proxies, cookies, user+password
authentication (Basic, Digest, NTLM, Negotiate, Kerberos4), file transfer
resume, http proxy tunneling and more.

%package -n libcurl-devel
Summary: Files needed for building applications with libcurl
Group: Development/Libraries
Requires: libcurl = %{version}-%{release}

# From Fedora 14, %%{_datadir}/aclocal is included in the filesystem package
%if 0%{?fedora} < 14
Requires: %{_datadir}/aclocal
%endif

# From Fedora 11, RHEL-6, pkgconfig dependency is auto-detected
%if 0%{?fedora} < 11 && 0%{?rhel} < 6
Requires: pkgconfig
%endif

Provides: curl-devel = %{version}-%{release}
Obsoletes: curl-devel < %{version}-%{release}

%description -n libcurl-devel
The libcurl-devel package includes header files and libraries necessary for
developing programs which use the libcurl library. It contains the API
documentation of the library, too.

%package fivextra
Summary:FIV Tests for %{name}
Group: Test
Prefix: /opt/fiv/ltp
Requires: %{name} >= %{version}-%{release}
# Do not automatically generate 'provides' since we do not want any
# functionality beyond the testcases provided by this package. This
# means we will need to manually define 'provides' based on what we
# deliver in this fivextra package.
AutoProv: no
Provides: perl(sshhelp), perl(getpart), perl(ftp), perl(valgrind)

%description fivextra
This package contains the testcases built from the package for %{name}.

%prep
%setup -q -a 999

# upstream patches
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p1

# Fedora patches
%patch101 -p1
%patch102 -p1
%patch104 -p1
%patch106 -p1
%patch107 -p1
%patch108 -p1

#base patches
%patch961941 -p1
%patch961942 -p1
%patch104606 -p1

# replace hard wired port numbers in the test suite
cd tests/data/
sed -i s/899\\\([0-9]\\\)/%{?__isa_bits}9\\1/ test*
cd -

# avoid spurious failure of test1086 on s390(x) koji builders (#1072273)
sed -i 's/-m 7/-m 15/' tests/data/test1086

# disable test 1112 (#565305)
printf "1112\n" >> tests/data/DISABLED

# disable test 1319 on ppc64 (server times out)
%ifarch ppc64
echo "1319" >> tests/data/DISABLED
%endif

%build
[ -x /usr/kerberos/bin/krb5-config ] && KRB5_PREFIX="=/usr/kerberos"
%configure --disable-static \
    --enable-hidden-symbols \
    --enable-ipv6 \
    --enable-ldaps \
    --enable-manual \
    --with-ca-bundle=%{_sysconfdir}/pki/tls/certs/ca-bundle.crt \
    --with-gssapi${KRB5_PREFIX} \
    --with-libidn \
    --with-libssh2 \
    --without-ssl --with-nss
#    --enable-debug
# use ^^^ to turn off optimizations, etc.

# Remove bogus rpath
sed -i \
    -e 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' \
    -e 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool

make %{?_smp_mflags}

cd tests
sed -i -e "s/test: perhcheck/test: perlcheck/" Makefile
make test||true
cd ..

pushd fivextra
make all
popd

%check
LD_LIBRARY_PATH=$RPM_BUILD_ROOT%{_libdir}
export LD_LIBRARY_PATH

# uncomment to use the non-stripped library in tests
# LD_PRELOAD=`find -name \*.so`
# LD_PRELOAD=`readlink -f $LD_PRELOAD`

cd tests
make %{?_smp_mflags}

# use different port range for 32bit and 64bit build, thus make it possible
# to run both in parallel on the same machine
# LTC: only disable during boostrap
#./runtests.pl -a -b%{?__isa_bits}90 -p -v

%install
rm -rf $RPM_BUILD_ROOT

make DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p" install

rm -f ${RPM_BUILD_ROOT}%{_libdir}/libcurl.la

install -d $RPM_BUILD_ROOT%{_datadir}/aclocal
install -m 644 docs/libcurl/libcurl.m4 $RPM_BUILD_ROOT%{_datadir}/aclocal

# drop man page for a script we do not distribute
rm -f ${RPM_BUILD_ROOT}%{_mandir}/man1/mk-ca-bundle.1

# Make libcurl-devel multilib-ready (bug #488922)
%if 0%{?__isa_bits} == 64
%define _curlbuild_h curlbuild-64.h
%else
%define _curlbuild_h curlbuild-32.h
%endif
mv $RPM_BUILD_ROOT%{_includedir}/curl/curlbuild.h \
   $RPM_BUILD_ROOT%{_includedir}/curl/%{_curlbuild_h}

install -m 644 %{SOURCE2} $RPM_BUILD_ROOT%{_includedir}/curl/curlbuild.h

# Base test subpackage will be copied to FIV location
mkdir -p $RPM_BUILD_ROOT%{fivdir}/%{name}/
cp -a tests $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests
# Steps to package the acpid tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

# Updated the location of the curl executable in runtests.pl
sed -i -e "s/\.\.\/src\/curl/\/usr\/bin\/curl/" $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/runtests.pl
# Remove libcurl test cases, .deps, .libs directories 
# Remove all Makefiles, .o, .h, .c files
rm -rf $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/Makefile{,.am,.in}
find $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/libtest -type f -not -name notexists.pl -delete
rm -rf $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/server/{.deps,.libs}
rm -rf $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/server/{*.o,*.h,*.c}
rm -rf $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/server/Makefile{,.am,.in}
rm -rf $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/data/Makefile{,.am,.in}

%clean
rm -rf $RPM_BUILD_ROOT

%post -n libcurl -p /sbin/ldconfig

%postun -n libcurl -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc CHANGES README* COPYING
%doc docs/BUGS docs/FAQ docs/FEATURES
%doc docs/MANUAL docs/RESOURCES
%doc docs/TheArtOfHttpScripting docs/TODO
%{_bindir}/curl
%{_mandir}/man1/curl.1*

%files -n libcurl
%defattr(-,root,root,-)
%{_libdir}/libcurl.so.*

%files -n libcurl-devel
%defattr(-,root,root,-)
%doc docs/examples/*.c docs/examples/Makefile.example docs/INTERNALS
%doc docs/CONTRIBUTE docs/libcurl/ABI
%{_bindir}/curl-config*
%{_includedir}/curl
%{_libdir}/*.so
%{_libdir}/pkgconfig/*.pc
%{_mandir}/man1/curl-config.1*
%{_mandir}/man3/*
%{_datadir}/aclocal/libcurl.m4

%files fivextra
%defattr(-,root,root, 0755)
%{prefix}

%changelog
* Thu Jan 23 2014 baseuser@ibm.com
- Base-f19.x spec file
