# if 0%{?fedora}
# global with_python3 1
# endif
%if 0%{?rhel} && 0%{?rhel} <= 5
%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}
%endif

Name:           pygpgme
Version:        0.3
%define base_release .4
Release:        6%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: %{cross_arches}
Summary:        Python module for working with OpenPGP messages

Group:          Development/Languages
License:        LGPLv2+
URL:            http://cheeseshop.python.org/pypi/pygpgme
# pygpgme is being developed for Ubuntu and built for Ubuntu out of
# launchpad's source control.  if we need to create a snapshot, here's how:
#
# Steps to create snapshot:
# bzr branch lp:pygpgme -r69
# cd pygpgme
# patch -p0 < ../pygpgme-examples.patch
# python setup.py sdist
# tarball is in dist/pygpgme-0.1.tar.gz
#Source0:        pygpgme-0.1.tar.gz
Source0:        http://cheeseshop.python.org/packages/source/p/%{name}/%{name}-%{version}.tar.gz
Source999:      fivextra.tar.bz2
Patch97333: setup_modify.patch 

BuildRequires:  python2-devel
BuildRequires:  gpgme-devel

%if 0%{?with_python3}
BuildRequires: python3-devel
%endif

%filter_provides_in %{python_sitearch}/gpgme/_gpgme.so
%filter_setup

%description
PyGPGME is a Python module that lets you sign, verify, encrypt and decrypt
files using the OpenPGP format.  It is built on top of GNU Privacy Guard and
the GPGME library.

%if 0%{?with_python3}
%package -n python3-pygpgme
Summary: Python3 module for working with OpenPGP messages
Group:   Development/Languages

%description -n python3-pygpgme
PyGPGME is a Python module that lets you sign, verify, encrypt and decrypt
files using the OpenPGP format.  It is built on top of GNU Privacy Guard and
the GPGME library.  This package installs the module for use with python3.
%endif

%Package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -a 999

%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
%endif

%build
CFLAGS="$RPM_OPT_FLAGS -fno-strict-aliasing" %{__python} setup.py build

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif # with_python3

pushd fivextra
make all
popd

%install
%{__python} setup.py install --skip-build --root $RPM_BUILD_ROOT
chmod 0755 $RPM_BUILD_ROOT%{python_sitearch}/gpgme/_gpgme.so

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install --skip-build --root $RPM_BUILD_ROOT
chmod 0755 $RPM_BUILD_ROOT%{python3_sitearch}/gpgme/*.so
popd
%endif # with_python3

for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

for dir in `cd gpgme; find . -type d`
do
 install -m 755 -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/gpgme/$dir
 install -m 755 $(find gpgme/$dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/gpgme/$dir || true
done

for dir in `cd tests; find . -type d`
do 
 install -m 755 -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests/$dir
 install -m 755 $(find tests/$dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests/$dir || true
done 

install -m 755 test_all.py $RPM_BUILD_ROOT/%{fivdir}/%{name}/test_all.py
install -m 755 setup.py $RPM_BUILD_ROOT/%{fivdir}/%{name}/setup.py

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
# LTC: fix fivextra failure here:
#  make install
#  patch -p0 <skip_interactive_test.diff
#  can't find file to patch at input line 3
#  Perhaps you used the wrong -p or --strip option?
make install
popd

%clean
rm -rf $RPM_BUILD_ROOT

%check
### Can't run the tests unconditionally because they depend on importing a private key.
# gpg2 on which our gpgme library depends does not import private keys so this
# won't work.  The issue in the real world is not so big as we  don't
# manipulate private keys outside of a keyring that often.
# We'll run this and ignore errors so we can manually look for problems more easily
# Use the installed gpgme because it has the built compiled module
#mv gpgme gpgme.bak
#ln -s $RPM_BUILD_ROOT%{python_sitearch}/gpgme .
#make check || :
find tests -name '*.pyc' -delete

%files
%defattr(-,root,root,-)
%doc README PKG-INFO examples tests
%{python_sitearch}/*

%if 0%{?with_python3}
%files -n python3-pygpgme
%defattr(-,root,root,-)
%doc README PKG-INFO examples tests
%{python3_sitearch}/*
%endif # with_python3

%files fivextra
%{prefix}

%changelog
* Thu Jul 11 2013 baseuser@ibm.com
- Base-8.x spec file
