%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}

%if (0%{?fedora} || 0%{?rhel} > 6) && !0%{?base:1}
%global with_python3 1
%{!?python3_version: %global python3_version %(%{__python3} -c "import sys; sys.stdout.write(sys.version[:3])")}
%endif

%define srcname Markdown

Name:           python-markdown
Version:        2.2.1
%define base_release .2
Release:        2%{?dist}%{?base_release}
Summary:        Markdown implementation in Python
Group:          Development/Languages
License:        BSD
URL:            http://packages.python.org/Markdown/
Source0:        http://pypi.python.org/packages/source/M/%{srcname}/%{srcname}-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:      noarch
BuildRequires:  python-devel
BuildRequires:  python-nose
%if (0%{?rhel} && 0%{?rhel} < 7) || (0%{?base} && 0%{?base} < 19)
BuildRequires:  python-elementtree
Requires:       python-elementtree
%endif
%if 0%{?with_python3}
BuildRequires:  python3-devel
BuildRequires:  python3-nose
# for converting before running the tests:
BuildRequires:  /usr/bin/2to3
%endif # with_python3


%description
This is a Python implementation of John Gruber's Markdown. It is
almost completely compliant with the reference implementation, though
there are a few known issues.


%if 0%{?with_python3}
%package -n python3-markdown
Summary:        Markdown implementation in Python
Group:          Development/Languages


%description -n python3-markdown
This is a Python implementation of John Gruber's Markdown. It is
almost completely compliant with the reference implementation, though
there are a few known issues.
%endif # with_python3


%prep
%setup -q -n %{srcname}-%{version}

# remove shebangs
find markdown -type f -name '*.py' \
  -exec sed -i -e '/^#!/{1D}' {} \;

# fix line-ending
sed -i 's/\r//' docs/release-2.2.0.txt

%if 0%{?with_python3}
cp -a . %{py3dir}
%endif # with_python3


%build
%{__python} setup.py build

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif # with_python3


%install
rm -rf %{buildroot}
%{__python} setup.py install -O1 --skip-build --root %{buildroot}

# rename binary
mv %{buildroot}%{_bindir}/markdown_py{,-%{python_version}}

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install -O1 --skip-build --root %{buildroot}
popd

# rename binary
mv %{buildroot}%{_bindir}/markdown_py{,-%{python3_version}}
%endif # with_python3

# 2.X binary is called by default for now
ln -s markdown_py-%{python_version} %{buildroot}%{_bindir}/markdown_py


%check
./run-tests.py

%if 0%{?with_python3}
pushd %{py3dir}
2to3 -d -w -n markdown tests run-tests.py > /dev/null
./run-tests.py
popd
%endif # with_python3


%clean
rm -rf %{buildroot}


%files
%defattr(-,root,root,-)
%doc build/docs/*
%{python_sitelib}/*
%{_bindir}/markdown_py
%{_bindir}/markdown_py-%{python_version}


%if 0%{?with_python3}
%files -n python3-markdown
%defattr(-,root,root,-)
%doc build/docs/*
%{python3_sitelib}/*
%{_bindir}/markdown_py-%{python3_version}
%endif # with_python3


%changelog
* Fri Aug 23 2013 baseuser@ibm.com
- Base-8.x spec file
