%if 0%{?fedora} > 19
%global _hardened_build 1
%endif
%define nsport 5666

Name: nrpe
Version: 2.14
%define base_release .2
Release: 5%{?dist}%{?base_release}
Summary: Host/service/network monitoring agent for Nagios

Group: Applications/System
License: GPLv2
URL: http://www.nagios.org
Source0: http://dl.sourceforge.net/nagios/%{name}-%{version}.tar.gz
Source1: nrpe.sysconfig
Source2: nrpe-tmpfiles.conf
Source3: nrpe.service
Patch1: nrpe-0001-Add-reload-target-to-the-init-script.patch
Patch2: nrpe-0002-Read-extra-configuration-from-etc-sysconfig-nrpe.patch
Patch3: nrpe-0003-Include-etc-npre.d-config-directory.patch
Patch4: nrpe-0004-Fix-initscript-return-codes.patch
Patch5: nrpe-0005-Do-not-start-by-default.patch
Patch6: nrpe-0006-Relocate-pid-file.patch
Patch7: nrpe-0007-Add-condrestart-try-restart-target-to-initscript.patch
Patch8:	nrpe-0008-Allow-user-to-override-all-defaults-even-command-def.patch

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

# For reconfiguration
BuildRequires: autoconf
BuildRequires: automake
BuildRequires: libtool
BuildRequires: openssl-devel
# OpenSSL package was split into openssl and openssl-libs in F18+
BuildRequires: openssl
%if 0%{?fedora} > 17 || 0%{?rhel} > 6
BuildRequires:  systemd-units
%endif

%if 0%{?el4}%{?el5}
BuildRequires: tcp_wrappers
%else
BuildRequires: tcp_wrappers-devel
%endif

Requires(pre): %{_sbindir}/useradd

%if 0%{?el4}%{?el5}%{?el6}
Requires(preun): /sbin/service, /sbin/chkconfig
Requires(post): /sbin/chkconfig, /sbin/service
Requires(postun): /sbin/service
Requires: initscripts
%else
Requires(post): systemd
Requires(preun): systemd
Requires(postun): systemd
%endif

# owns /etc/nagios
Requires: nagios-common
Provides: nagios-nrpe = %{version}-%{release}

%description
Nrpe is a system daemon that will execute various Nagios plugins
locally on behalf of a remote (monitoring) host that uses the
check_nrpe plugin.  Various plugins that can be executed by the
daemon are available at:
http://sourceforge.net/projects/nagiosplug

This package provides the core agent.

%package -n nagios-plugins-nrpe
Group: Applications/System
Summary: Provides nrpe plugin for Nagios
Requires: nagios-plugins
Provides: check_nrpe = %{version}-%{release}

%description -n nagios-plugins-nrpe
Nrpe is a system daemon that will execute various Nagios plugins
locally on behalf of a remote (monitoring) host that uses the
check_nrpe plugin.  Various plugins that can be executed by the
daemon are available at:
http://sourceforge.net/projects/nagiosplug

This package provides the nrpe plugin for Nagios-related applications.

%prep
%setup -q
%patch1 -p1 -b .reload
%patch2 -p1 -b .extra_config
%patch3 -p1 -b .include_etc_npre_d
%patch4 -p1 -b .initscript_return_codes
%patch5 -p1 -b .do_not_start_by_default
%patch6 -p1 -b .relocate_pid
%patch7 -p1 -b .condrestart
%patch8 -p1 -b .allow_override
# Allow building for aarch64
# https://bugzilla.redhat.com/926244
%if 0%{?fedora} > 17 || 0%{?rhel} > 6
mv config.sub config.sub.old
mv config.guess config.guess.old
cp /usr/share/libtool/config/config.guess .
cp /usr/share/libtool/config/config.sub .
%endif

%build
CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" LDFLAGS="%{?__global_ldflags}" \
./configure \
	--with-init-dir=%{_initrddir} \
	--with-nrpe-port=%{nsport} \
	--with-nrpe-user=nrpe \
	--with-nrpe-group=nrpe \
	--bindir=%{_sbindir} \
	--libdir=/doesnt/matter/ \
	--libexecdir=%{_libdir}/nagios/plugins \
	--datadir=%{_datadir}/nagios \
	--sysconfdir=%{_sysconfdir}/nagios \
	--localstatedir=%{_localstatedir}/log/nagios \
	--enable-command-args
make %{?_smp_mflags} all

%install
rm -rf %{buildroot}
%if 0%{?el4}%{?el5}%{?el6}
install -D -p -m 0755 init-script %{buildroot}/%{_initrddir}/nrpe
%else
install -D -m 0644 -p %{SOURCE3} %{buildroot}%{_unitdir}/%{name}.service
%endif
install -D -p -m 0644 sample-config/nrpe.cfg %{buildroot}/%{_sysconfdir}/nagios/%{name}.cfg
install -D -p -m 0755 src/nrpe %{buildroot}/%{_sbindir}/nrpe
install -D -p -m 0755 src/check_nrpe %{buildroot}/%{_libdir}/nagios/plugins/check_nrpe
install -D -p -m 0644 %{SOURCE1} %{buildroot}/%{_sysconfdir}/sysconfig/%{name}
install -d %{buildroot}%{_sysconfdir}/nrpe.d
install -d %{buildroot}%{_localstatedir}/run/%{name}
%if 0%{?fedora} > 14 || 0%{?rhel} > 6
install -D -p -m 0644 %{SOURCE2} %{buildroot}%{_tmpfilesdir}/%{name}.conf
%endif


%clean
rm -rf %{buildroot}

%pre
getent group %{name} >/dev/null || groupadd -r %{name}
getent passwd %{name} >/dev/null || \
%{_sbindir}/useradd -c "NRPE user for the NRPE service" -d %{_localstatedir}/run/%{name} -r -g %{name} -s /sbin/nologin %{name} 2> /dev/null || :

%preun
%if 0%{?el4}%{?el5}%{?el6}
if [ $1 = 0 ]; then
	/sbin/service %{name} stop > /dev/null 2>&1 || :
	/sbin/chkconfig --del %{name} || :
fi
%else
%systemd_preun nrpe.service
%endif

%post
%if 0%{?el4}%{?el5}%{?el6}
/sbin/chkconfig --add %{name} || :
%else
%systemd_post nrpe.service
%endif

%postun
%if 0%{?el4}%{?el5}%{?el6}
if [ "$1" -ge "1" ]; then
	/sbin/service %{name} condrestart > /dev/null 2>&1 || :
fi
%else
%systemd_postun_with_restart nrpe.service
%endif

%files
%if 0%{?el4}%{?el5}%{?el6}
%{_initrddir}/nrpe
%else
%{_unitdir}/%{name}.service
%endif
%{_sbindir}/nrpe
%dir %{_sysconfdir}/nrpe.d
%config(noreplace) %{_sysconfdir}/nagios/nrpe.cfg
%config(noreplace) %{_sysconfdir}/sysconfig/%{name}
%if 0%{?fedora} > 14 || 0%{?rhel} > 6
%config(noreplace) %{_tmpfilesdir}/%{name}.conf
%endif
%doc Changelog LEGAL README README.SSL SECURITY docs/NRPE.pdf
%dir %attr(775, %{name}, %{name}) %{_localstatedir}/run/%{name}

%files -n nagios-plugins-nrpe
%{_libdir}/nagios/plugins/check_nrpe
%doc Changelog LEGAL README

%changelog
* Mon Oct 28 2013 baseuser@ibm.com
- Base-8.x spec file
