Name:		leveldb
Version:	1.9.0
%define base_release .2
Release:	1%{?dist}%{?base_release}
Summary:	A fast and lightweight key/value database library by Google
Group:		Applications/Databases
License:	BSD
ExcludeArch: mips64 ppca2 ppc476 ppcnf
URL:		http://code.google.com/p/leveldb/
Source0:	http://leveldb.googlecode.com/files/%{name}-%{version}.tar.gz
# Sent upstream - https://code.google.com/p/leveldb/issues/detail?id=101
Patch1:		leveldb-0001-Initial-commit-of-the-autotools-stuff.patch
# Temporary workaround for secondary arches
Patch2:		leveldb-0002-Add-memory-barrier-on-PowerPC.patch
# https://groups.google.com/d/topic/leveldb/SbVPvl4j4vU/discussion
Patch3:		leveldb-0003-bloom_test-failure-on-big-endian-archs.patch
# available in https://github.com/fusesource/leveldbjni/blob/leveldbjni-[LEVELDBJNI VERSION]/leveldb.patch
Patch4:		leveldb-0004-leveldbjni.patch
BuildRequires:	snappy-devel
BuildRequires:	autoconf
BuildRequires:	automake
BuildRequires:	libtool


%description
LevelDB is a fast key-value storage library written at Google that provides an
ordered mapping from string keys to string values.


%package devel
Summary: The development files for %{name}
Group: Development/Libraries
Requires: pkgconfig
Requires: %{name}%{?_isa} = %{version}-%{release}
Requires: pkgconfig


%description devel
Additional header files for development with %{name}.


%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

%build
autoreconf -ivf
%configure --disable-static --with-pic
make %{?_smp_mflags}


%install
make install DESTDIR=%{buildroot}
rm -f %{buildroot}%{_libdir}/*.la


%check
%ifarch armv5tel armv7hl ppc %{power64}
# FIXME a couple of tests are failing on these secondary arches
make check || true
%else
# x86, x86_64, ppc, ppc64, ppc64v7 s390, and s390x are fine
make check
%endif

%post -p /sbin/ldconfig


%postun -p /sbin/ldconfig


%files
%doc doc/ AUTHORS LICENSE README
%{_libdir}/lib%{name}.so.*


%files devel
%{_includedir}/%{name}/
%{_libdir}/lib%{name}.so
%{_libdir}/pkgconfig/%{name}.pc


%changelog
* Mon Jul 01 2013 baseuser@ibm.com
- Base-8.x spec file
