Summary: An XML parser library
Name: expat
Version: 2.1.0
%define base_release .3
Release: 5%{?dist}%{?base_release}
Group: System Environment/Libraries
Source: http://downloads.sourceforge.net/expat/expat-%{version}.tar.gz
Source999: fivextra.tar.bz2
URL: http://www.libexpat.org/
License: MIT
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: autoconf, automake, libtool, check-devel

%description
This is expat, the C library for parsing XML, written by James Clark. Expat
is a stream oriented XML parser. This means that you register handlers with
the parser prior to starting the parse. These handlers are called when the
parser discovers the associated structures in the document being parsed. A
start tag is an example of the kind of structures for which you may
register handlers.

%package devel
Summary: Libraries and header files to develop applications using expat
Group: Development/Libraries
Requires: expat = %{version}-%{release}

%description devel
The expat-devel package contains the libraries, include files and documentation
to develop XML applications with expat.

%package static
Summary: expat XML parser static library
Group: Development/Libraries
Requires: expat-devel%{?_isa} = %{version}-%{release}

%description static
The expat-static package contains the static version of the expat library.
Install it if you need to link statically with expat.

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -n %{name}-%{version} -a 999

%build
rm -rf autom4te*.cache
libtoolize --copy --force --automake && aclocal && autoheader && autoconf
export CFLAGS="$RPM_OPT_FLAGS -fPIC"
%configure
make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
rm -rf ${RPM_BUILD_ROOT}

rm -f examples/*.dsp
chmod 644 README COPYING Changes doc/* examples/*

make install DESTDIR=$RPM_BUILD_ROOT

rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

# Steps to package the expat tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%check
make check

%clean
rm -rf ${RPM_BUILD_ROOT}

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
%doc README COPYING
%{_bindir}/*
%{_libdir}/lib*.so.*
%{_mandir}/*/*

%files devel
%defattr(-,root,root)
%doc Changes doc examples
%{_libdir}/lib*.so
%{_libdir}/pkgconfig/*.pc
%{_includedir}/*.h

%files static
%defattr(-,root,root)
%{_libdir}/lib*.a

%files fivextra
%{prefix}

%changelog
* Thu May 16 2013 baseuser@ibm.com
- Base-8.x spec file
