%if 0%{?base}
%bcond_with dane
%else
%bcond_without dane
%endif
%bcond_with guile
Summary: A TLS protocol implementation
Name: gnutls
Version: 3.1.20
%define base_release .2
Release: 4%{?dist}%{?base_release}
# The libraries are LGPLv2.1+, utilities are GPLv3+, however
# the bundled gnulib is LGPLv3+
License: GPLv3+ and LGPLv2+ and LGPLv3+
Group: System Environment/Libraries
BuildRequires: p11-kit-devel >= 0.11, gettext
BuildRequires: zlib-devel, readline-devel, libtasn1-devel >= 3.1
BuildRequires: libtool, automake, autoconf, texinfo
BuildRequires: nettle-devel >= 2.5
# Not suitable autogen is present in this release
# BuildRequires: autogen-libopts-devel >= 5.18 autogen

# Do not link against trousers in F19. The installed trousers
# package isn't sufficient.
#BuildRequires: trousers-devel >= 0.3.11.2
%if %{with dane}
BuildRequires: unbound-devel unbound-libs
%endif
%if %{with guile}
BuildRequires: guile-devel
%endif
URL: http://www.gnutls.org/
#Source0: ftp://ftp.gnutls.org/gcrypt/gnutls/%{name}-%{version}.tar.xz
#Source1: ftp://ftp.gnutls.org/gcrypt/gnutls/%{name}-%{version}.tar.xz.sig
# XXX patent tainted code removed.
Source0: %{name}-%{version}-hobbled.tar.xz
Source1: libgnutls-config
Source2: hobble-gnutls
Source3: ecc.c
Source999: fivextra.tar.bz2
Patch1: gnutls-3.1.17-rpath.patch
Patch2: gnutls-3.1.20-init-keyword.patch
Patch3: gnutls-3.1.20-supported-ecc.patch
# Use only FIPS approved ciphers in the FIPS mode
Patch7: gnutls-2.12.21-fips-algorithms.patch
Patch8: gnutls-3.1.11-nosrp.patch
# Use random port in some tests to avoid conflicts during simultaneous builds on the same machine
Patch9: gnutls-3.1.10-tests-rndport.patch
Patch10: gnutls-3.1.18-suiteb.patch
Patch11: gnutls-3.1.20-v1-fix.patch
Patch12: gnutls-3.1.18-cve-2014-0092.patch
Patch13: gnutls-3.1.18-cve-2014-3466.patch

# Wildcard bundling exception https://fedorahosted.org/fpc/ticket/174
Provides: bundled(gnulib) = 20130424

%package c++
Summary: The C++ interface to GnuTLS
Requires: %{name}%{?_isa} = %{version}-%{release}

%package devel
Summary: Development files for the %{name} package
Group: Development/Libraries
Requires: %{name}%{?_isa} = %{version}-%{release}
Requires: %{name}-c++%{?_isa} = %{version}-%{release}
%if %{with dane}
Requires: %{name}-dane%{?_isa} = %{version}-%{release}
%endif
Requires: pkgconfig
Requires(post): /sbin/install-info
Requires(preun): /sbin/install-info

%package utils
License: GPLv3+
Summary: Command line tools for TLS protocol
Group: Applications/System
Requires: %{name}%{?_isa} = %{version}-%{release}
%if %{with dane}
Requires: %{name}-dane%{?_isa} = %{version}-%{release}
%endif

%if %{with dane}
%package dane
Summary: A DANE protocol implementation for GnuTLS
Requires: %{name}%{?_isa} = %{version}-%{release}
%endif

%if %{with guile}
%package guile
Summary: Guile bindings for the GNUTLS library
Group: Development/Libraries
Requires: %{name}%{?_isa} = %{version}-%{release}
Requires: guile
%endif

%description
GnuTLS is a secure communications library implementing the SSL, TLS and DTLS 
protocols and technologies around them. It provides a simple C language 
application programming interface (API) to access the secure communications 
protocols as well as APIs to parse and write X.509, PKCS #12, OpenPGP and 
other required structures. 

%description c++
GnuTLS is a secure communications library implementing the SSL, TLS and DTLS 
protocols and technologies around them. It provides a simple C language 
application programming interface (API) to access the secure communications 
protocols as well as APIs to parse and write X.509, PKCS #12, OpenPGP and 
other required structures. 
This package contains the C++ interface for the GnuTLS library.

%description devel
GnuTLS is a secure communications library implementing the SSL, TLS and DTLS 
protocols and technologies around them. It provides a simple C language 
application programming interface (API) to access the secure communications 
protocols as well as APIs to parse and write X.509, PKCS #12, OpenPGP and 
other required structures. 
This package contains files needed for developing applications with
the GnuTLS library.

%description utils
GnuTLS is a secure communications library implementing the SSL, TLS and DTLS 
protocols and technologies around them. It provides a simple C language 
application programming interface (API) to access the secure communications 
protocols as well as APIs to parse and write X.509, PKCS #12, OpenPGP and 
other required structures. 
This package contains command line TLS client and server and certificate
manipulation tools.

%if %{with dane}
%description dane
GnuTLS is a secure communications library implementing the SSL, TLS and DTLS 
protocols and technologies around them. It provides a simple C language 
application programming interface (API) to access the secure communications 
protocols as well as APIs to parse and write X.509, PKCS #12, OpenPGP and 
other required structures. 
This package contains library that implements the DANE protocol for verifying
TLS certificates through DNSSEC.
%endif

%if %{with guile}
%description guile
GnuTLS is a secure communications library implementing the SSL, TLS and DTLS 
protocols and technologies around them. It provides a simple C language 
application programming interface (API) to access the secure communications 
protocols as well as APIs to parse and write X.509, PKCS #12, OpenPGP and 
other required structures. 
This package contains Guile bindings for the library.
%endif

%package fivextra
Summary: Test for %{name} package
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}

%prep
%setup -q -a 999

%patch1 -p1 -b .rpath
%patch2 -p1 -b .ikeyword
%patch3 -p1 -b .supported-ecc
# This patch is not applicable as we use nettle now but some parts will be
# later reused.
#%patch7 -p1 -b .fips
%patch8 -p1 -b .nosrp
%patch9 -p1 -b .rndport
%patch10 -p1 -b .suiteb
%patch11 -p1 -b .v1-fix
%patch12 -p1 -b .cve-2014-0092
%patch13 -p1 -b .cve-2014-3466

%{SOURCE2} -e

cp -f %{SOURCE3} lib/algorithms
rm -f doc/gnutls.info*

%build

export LDFLAGS="-Wl,--no-add-needed"

%configure --with-libtasn1-prefix=%{_prefix} \
           --with-included-libcfg \
           --disable-static \
           --disable-openssl-compatibility \
           --disable-srp-authentication \
	   --without-tpm \
	   --enable-local-libopts \
%if %{with guile}
           --enable-guile \
%ifarch %{arm}
           --disable-largefile \
%endif
%else
           --disable-guile \
%endif
%if %{with dane}
	   --with-unbound-root-key-file=/var/lib/unbound/root.key \
           --enable-dane \
%else
           --disable-dane \
%endif
           --disable-rpath
# Note that the arm hack above is not quite right and the proper thing would
# be to compile guile with largefile support.
make

pushd fivextra
make all
popd

%install
make install DESTDIR=$RPM_BUILD_ROOT
rm -f $RPM_BUILD_ROOT%{_bindir}/srptool
rm -f $RPM_BUILD_ROOT%{_bindir}/gnutls-srpcrypt
cp -f %{SOURCE1} $RPM_BUILD_ROOT%{_bindir}/libgnutls-config
cp -f %{SOURCE1} $RPM_BUILD_ROOT%{_bindir}/libgnutls-extra-config
rm -f $RPM_BUILD_ROOT%{_mandir}/man1/srptool.1
rm -f $RPM_BUILD_ROOT%{_mandir}/man1/tpmtool.1
rm -f $RPM_BUILD_ROOT%{_mandir}/man3/*srp*
rm -f $RPM_BUILD_ROOT%{_infodir}/dir
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la
rm -f $RPM_BUILD_ROOT%{_libdir}/libguile*.a
%if %{without dane}
rm -f $RPM_BUILD_ROOT%{_libdir}/pkgconfig/gnutls-dane.pc
rm -f $RPM_BUILD_ROOT%{_bindir}/danetool
%endif

# Steps to package the gnutls tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%find_lang gnutls

%check
make check

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%post c++ -p /sbin/ldconfig

%postun c++ -p /sbin/ldconfig

%post devel
if [ -f %{_infodir}/gnutls.info.gz ]; then
    /sbin/install-info %{_infodir}/gnutls.info.gz %{_infodir}/dir || :
fi

%preun devel
if [ $1 = 0 -a -f %{_infodir}/gnutls.info.gz ]; then
   /sbin/install-info --delete %{_infodir}/gnutls.info.gz %{_infodir}/dir || :
fi

%if %{with dane}
%post dane -p /sbin/ldconfig

%postun dane -p /sbin/ldconfig
%endif

%if %{with guile}
%post guile -p /sbin/ldconfig

%postun guile -p /sbin/ldconfig
%endif

%files -f gnutls.lang
%defattr(-,root,root,-)
%{_libdir}/libgnutls.so.28*
%{_libdir}/libgnutls-xssl.so.0*
%doc COPYING COPYING.LESSER README AUTHORS NEWS THANKS

%files c++
%{_libdir}/libgnutlsxx.so.*

%files devel
%defattr(-,root,root,-)
%{_bindir}/libgnutls*-config
%{_includedir}/*
%{_libdir}/libgnutls*.so
%{_libdir}/pkgconfig/*.pc
%{_mandir}/man3/*
%{_infodir}/gnutls*
%{_infodir}/pkcs11-vision*

%files utils
%defattr(-,root,root,-)
%{_bindir}/certtool
%{_bindir}/ocsptool
%{_bindir}/psktool
#%{_bindir}/tpmtool
%{_bindir}/p11tool
%if %{with dane}
%{_bindir}/danetool
%endif
%{_bindir}/gnutls*
%{_mandir}/man1/*
%doc doc/certtool.cfg

%if %{with dane}
%files dane
%defattr(-,root,root,-)
%{_libdir}/libgnutls-dane.so.*
%endif

%if %{with guile}
%files guile
%defattr(-,root,root,-)
%{_libdir}/libguile*.so*
%{_datadir}/guile/site/gnutls
%{_datadir}/guile/site/gnutls.scm
%endif

%files fivextra
%{prefix}

%changelog
* Wed Apr 02 2014 baseuser@ibm.com
- Base-8.x spec file

