%global _hardened_build 1
# TODO: uses private copy of libedit, should be modified to use system one

%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}
Summary: IPMI (Intelligent Platform Management Interface) library and tools
Name: OpenIPMI
Version: 2.0.19
%define base_release .1
Release: 5%{?dist}%{?base_release}
ExcludeArch: mips64 ppca2 ppc476 ppcnf
License: LGPLv2+ and GPLv2+ or BSD
Group: System Environment/Base
URL: http://sourceforge.net/projects/openipmi/
Source: http://downloads.sourceforge.net/openipmi/%{name}-%{version}.tar.gz
Source1: openipmi.sysconf
Source2: openipmi-helper
Source3: ipmi.service
Source4: openipmi.modalias
Source5: fivextra.tar.bz2
BuildRequires: gdbm-devel swig glib2-devel net-snmp-devel ncurses-devel
BuildRequires: openssl-devel python-devel perl-devel tcl-devel tkinter
BuildRequires: desktop-file-utils
BuildRequires: systemd-units

# aarch64 workaround remove once released package's config.sub contains aarch64
BuildRequires: automake
BuildRequires: autoconf
BuildRequires: libtool
# aarch64 end

Requires(post): systemd-units
Requires(preun): systemd-units
Requires(postun): systemd-units
Requires(post): systemd-sysv
Requires:%{name}-libs = %{version}-%{release}

Patch1: OpenIPMI-2.0.18-pthread-pkgconfig.patch
Patch2: OpenIPMI-2.0.19-man.patch

%description
The Open IPMI project aims to develop an open code base to allow access to
platform information using Intelligent Platform Management Interface (IPMI).
This package contains the tools of the OpenIPMI project.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%package modalias
Group: System Environment/Kernel
Summary: Module aliases for IPMI subsystem

%description modalias
The OpenIPMI-modalias provides configuration file with module aliases
of ACPI and PNP wildcards.

%package libs
Group: Development/Libraries
Summary: The OpenIPMI runtime libraries
Requires:%{name}-modalias = %{version}-%{release}

%description libs
The OpenIPMI-libs package contains the runtime libraries for shared binaries
and applications.

%package perl
Group: Development/Libraries
Summary: IPMI Perl language bindings
Requires: perl(:MODULE_COMPAT_%(eval "`%{__perl} -V:version`"; echo $version))
Requires: %{name}-libs = %{version}-%{release}

%description perl
The OpenIPMI-perl package contains the Perl language bindings for OpenIPMI.

%package python
Group: Development/Libraries
Summary: IPMI Python language bindings
Requires: %{name}-libs = %{version}-%{release}

%description python
The OpenIPMI-python package contains the Python language bindings for OpenIPMI.

%package devel
Group: Development/Libraries
Summary: The development environment for the OpenIPMI project
Requires: pkgconfig
Requires: %{name} = %{version}-%{release}

%description devel
The OpenIPMI-devel package contains the development libraries and header files
of the OpenIPMI project.

%prep
%setup -q -a 5
%patch1 -p1 -b .pthread
%patch2 -p1 -b .manscan

%build
export CFLAGS="-fPIC $RPM_OPT_FLAGS"

# aarch64 workaround remove once released package's config.sub contains aarch64
%{__libtoolize} --copy --force --automake
%{__aclocal}
%{__autoheader}
%{__automake} --add-missing --copy --foreign --force-missing
%{__autoconf}
# aarch64 end

%configure \
    --with-pythoninstall=%{python_sitearch} \
    --disable-dependency-tracking \
    --with-tcl=no \
    --disable-static \
    --with-tkinter=no

# get rid of rpath
#sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
#sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool

make   # not %{?_smp_mflags} safe

pushd fivextra
make all
popd


%install
make install DESTDIR=$RPM_BUILD_ROOT
rm -rf $RPM_BUILD_ROOT/%{_libdir}/*.la

install -d ${RPM_BUILD_ROOT}%{_sysconfdir}/sysconfig
install -m 644 %SOURCE1 ${RPM_BUILD_ROOT}%{_sysconfdir}/sysconfig/ipmi
install -d ${RPM_BUILD_ROOT}%{_libexecdir}
install -m 755 %SOURCE2 ${RPM_BUILD_ROOT}%{_libexecdir}/openipmi-helper
install -d ${RPM_BUILD_ROOT}%{_unitdir}
install -m 644 %SOURCE3 ${RPM_BUILD_ROOT}%{_unitdir}/ipmi.service
install -d ${RPM_BUILD_ROOT}%{_sysconfdir}/modprobe.d
install -m 644 %SOURCE4 ${RPM_BUILD_ROOT}%{_sysconfdir}/modprobe.d/OpenIPMI.conf

rm ${RPM_BUILD_ROOT}/%{_mandir}/man1/openipmigui.1

# add missing documentation symlinks
if test -L ${RPM_BUILD_ROOT}/%{_bindir}/ipmicmd && ! test -a ${RPM_BUILD_ROOT}/%{_mandir}/man1/ipmicmd.1.gz ; then
    %{__ln_s} openipmicmd.1.gz ${RPM_BUILD_ROOT}/%{_mandir}/man1/ipmicmd.1.gz
fi

if test -L ${RPM_BUILD_ROOT}/%{_bindir}/ipmish && ! test -a ${RPM_BUILD_ROOT}/%{_mandir}/man1/ipmish.1.gz ; then
    %{__ln_s} openipmish.1.gz ${RPM_BUILD_ROOT}/%{_mandir}/man1/ipmish.1.gz
fi

# Steps to package the OpenIPMI tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
	install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
	install -m 755 `find fivextra/$dir/* -type d -prune -o -print`  $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done 
find $RPM_BUILD_ROOT/%{fivdir}/%{name} -depth -name CVS -type d -exec rm -rf {} \;
     
install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%post
%systemd_post ipmi.service

%preun
%systemd_preun ipmi.service

%postun
%systemd_postun_with_restart ipmi.service

%post libs -p /sbin/ldconfig

%postun libs -p /sbin/ldconfig

### A sysv => systemd migration contains all of the same scriptlets as a
### systemd package.  These are additional scriptlets

%triggerun -- OpenIPMI < 2.0.18-14
# Save the current service runlevel info
# User must manually run systemd-sysv-convert --apply httpd
# to migrate them to systemd targets
/usr/bin/systemd-sysv-convert --save ipmi >/dev/null 2>&1 ||:
/bin/systemctl --no-reload enable ipmi.service >/dev/null 2>&1 ||:
# Run these because the SysV package being removed won't do them
/sbin/chkconfig --del ipmi >/dev/null 2>&1 || :
/bin/systemctl try-restart ipmi.service >/dev/null 2>&1 || :

%files
%doc CONFIGURING_FOR_LAN COPYING COPYING.BSD COPYING.LIB FAQ README README.Force README.MotorolaMXP
%config(noreplace) %{_sysconfdir}/sysconfig/ipmi
%{_libexecdir}/openipmi-helper
%{_bindir}/ipmicmd
%{_bindir}/ipmilan
%{_bindir}/ipmish
%{_bindir}/ipmi_ui
%{_bindir}/openipmicmd
%{_bindir}/openipmish
%{_bindir}/rmcp_ping
%{_bindir}/solterm
%{_unitdir}/ipmi.service
%{_mandir}/man1/ipmi_ui*
%{_mandir}/man1/openipmicmd*
%{_mandir}/man1/openipmish*
%{_mandir}/man1/rmcp_ping*
%{_mandir}/man1/solterm*
%{_mandir}/man1/ipmish*
%{_mandir}/man1/ipmicmd*
%{_mandir}/man7/ipmi_cmdlang*
%{_mandir}/man7/openipmi_conparms*
%{_mandir}/man8/ipmilan*

%files perl
%attr(644,root,root) %{perl_vendorarch}/OpenIPMI.pm
%{perl_vendorarch}/auto/OpenIPMI/

%files python
%{python_sitearch}/*OpenIPMI*

%files libs
%{_libdir}/*.so.*

%files devel
%{_includedir}/OpenIPMI
%{_libdir}/*.so
%{_libdir}/pkgconfig/*.pc

%files modalias
%config(noreplace) %{_sysconfdir}/modprobe.d/OpenIPMI.conf

%files fivextra
%{prefix}

%changelog
* Fri Mar 07 2014 baseuser@ibm.com
- Base-f19.x spec file
