%global WITH_DOCS 0
%global WITH_LDAP 1
%global WITH_DIRSRV 1
%if 0%{?fedora} >= 17 || 0%{?rhel} > 6
# These next two *will* change.
%global WITH_OPENSSL 1
%global WITH_NSS 0
%global WITH_SYSVERTO 1
%else
%global WITH_OPENSSL 1
%global WITH_NSS 0
%global WITH_SYSVERTO 0
%endif
# The "move everything to /usr" feature landed in Fedora 17, but we didn't
# catch up until the Fedora 18 development cycle, at which point we found
# that some packages were hard-coding paths.
%if 0%{?fedora} > 17 || 0%{?rhel} > 6
%global separate_usr 0
%else
%global separate_usr 1
%endif
# Systemd landed in Fedora 15, but this package was cut over for Fedora 16.
%if 0%{?fedora} >= 16 || 0%{?rhel} > 6
%global WITH_SYSTEMD 1
%else
%global WITH_SYSTEMD 0
%endif
# Set this so that find-lang.sh will recognize the .po files.
%global gettext_domain mit-krb5
# Guess where the -libs subpackage's docs are going to go.
%define libsdocdir %{?_pkgdocdir:%(echo %{_pkgdocdir} | sed -e s,krb5,krb5-libs,g)}%{!?_pkgdocdir:%{_docdir}/%{name}-libs-%{version}}

Summary: The Kerberos network authentication system
Name: krb5
Version: 1.11.3
# LTC Read this!  After rebuilding krb5 you need to rebuild libguestfs
# It's likely this is required only if the minor version (ie, 1.10 to 1.11)
# has changed.  Please rebuild after this build is complete and the repo ready.
# You can verify libkdb5 version in the krb5 provides and libguestfs requires,
# but take care libguestfs links to libkdb5.so.<number>.
%define base_release .1
Release: 25%{?dist}%{?base_release}
# Maybe we should explode from the now-available-to-everybody tarball instead?
# http://web.mit.edu/kerberos/dist/krb5/1.11/krb5-1.11.3-signed.tar
Source0: krb5-%{version}.tar.gz
Source1: krb5-%{version}.tar.gz.asc
# Use a dummy krb5-%{version}-pdf.tar.xz the first time through, then
#  tar cvJf $RPM_SOURCE_DIR/krb5-%%{version}-pdf.tar.xz build-pdf/*.pdf
# after the build phase finishes.
Source3: krb5-%{version}-pdf.tar.xz
Source2: kprop.service
Source4: kadmin.service
Source5: krb5kdc.service
Source6: krb5.conf
Source7: _kpropd
Source8: _kadmind
Source10: kdc.conf
Source11: kadm5.acl
Source19: krb5kdc.sysconfig
Source20: kadmin.sysconfig
Source29: ksu.pamd
Source31: kerberos-adm.portreserve
Source32: krb5_prop.portreserve
Source33: krb5kdc.logrotate
Source34: kadmind.logrotate
Source36: kpropd.init
Source37: kadmind.init
Source38: krb5kdc.init
Source999: fivextra.tar.bz2

BuildRequires: cmake
# Carry this locally until it's available in a packaged form.
Source100: nss_wrapper-0.0-20130719153839Z.git6cb59864.bz2
Source101: noport.c

Patch6: krb5-1.10-ksu-path.patch
Patch12: krb5-1.7-ktany.patch
Patch16: krb5-1.10-buildconf.patch
Patch23: krb5-1.3.1-dns.patch
Patch29: krb5-1.10-kprop-mktemp.patch
Patch30: krb5-1.3.4-send-pr-tempfile.patch
Patch39: krb5-1.8-api.patch
Patch56: krb5-1.10-doublelog.patch
Patch59: krb5-1.10-kpasswd_tcp.patch
Patch60: krb5-1.11-pam.patch
Patch63: krb5-1.11-selinux-label.patch
Patch71: krb5-1.11-dirsrv-accountlock.patch
Patch86: krb5-1.9-debuginfo.patch
Patch105: krb5-kvno-230379.patch
Patch113: krb5-1.11-alpha1-init.patch
Patch116: http://ausil.fedorapeople.org/aarch64/krb5/krb5-aarch64.patch
Patch117: krb5-1.11-gss-client-keytab.patch
Patch121: krb5-cccol-primary.patch
Patch123: krb5-1.11.2-empty_passwords.patch
Patch124: krb5-1.11.2-arcfour_short.patch
Patch125: krb5-1.11.2-skew1.patch
Patch126: krb5-1.11.2-skew2.patch
Patch127: krb5-master-test_gss_no_udp.patch
Patch128: krb5-master-test_no_pmap.patch 
Patch129: krb5-1.11-run_user_0.patch
Patch130: krb5-master-init_referral.patch
Patch131: krb5-1.11.3-skew3.patch
Patch132: krb5-1.11-gss-methods1.patch
Patch133: krb5-1.11-gss-methods2.patch 
Patch134: krb5-1.11-kpasswdtest.patch
Patch135: krb5-1.11-check_transited.patch
Patch136: krb5-1.11.3-prompter1.patch
Patch137: krb5-1.11.3-prompter2.patch
Patch138: krb5-1.11.3-gss-ccache-import.patch
Patch139: krb5-CVE-2013-1418.patch
Patch140: krb5-CVE-2013-1417.patch
Patch141: krb5-1.11.3-client-loop.patch
Patch142: krb5-master-no-malloc0.patch
Patch143: krb5-master-ignore-empty-unnecessary-final-token.patch
Patch144: krb5-master-gss_oid_leak.patch
Patch145: krb5-master-keytab_close.patch
Patch146: krb5-1.11-preauthcore.patch
Patch147: krb5-1.11.3-copy_context.patch
Patch148: krb5-1.11.3-spnego_error_messages.patch

Patch151: krb5-master-rcache-internal-const.patch
Patch152: krb5-master-rcache-acquirecred-cleanup.patch
Patch153: krb5-master-rcache-acquirecred-leak.patch
Patch154: krb5-1.11-rcache-acquirecred-source.patch
Patch155: krb5-master-empty-credstore.patch
Patch156: krb5-1.11.3-1.12.1-credstoretest.patch
Patch157: krb5-1.11-rcache-acquirecred-test.patch

Patch158: krb5-1.11-spnego-preserve-oid.patch

Patch159: krb5-1.12-CVE-2014-4341_4342.patch
Patch160: krb5-1.11-CVE-2014-4341_4342-tests.patch

Patch161: krb5-gssapi-mech-doublefree.patch
Patch162: krb5-gssapi-spnego-deref.patch

Patch163: http://web.mit.edu/kerberos/advisories/2014-001-patch.txt
Patch164: http://web.mit.edu/kerberos/advisories/2014-001-patch.txt.asc

# Patches for otp plugin backport
Patch201: krb5-1.11.2-keycheck.patch
Patch202: krb5-1.11.2-otp.patch
Patch203: krb5-1.11.3-otp2.patch

# Patches to teach ksu about cache collections
Patch300: 0000-ksu-intermediates.patch
Patch301: 0001-Don-t-try-to-stat-not-on-disk-ccache-residuals.patch
Patch302: 0002-Use-an-in-memory-cache-until-we-need-the-target-s.patch
Patch303: 0003-Learn-to-destroy-the-ccache-we-re-copying-from.patch
Patch304: 0004-Try-to-use-the-default_ccache_name-d-as-the-target.patch
Patch305: 0005-Be-more-careful-of-target-ccache-collections.patch
Patch306: 0006-Copy-config-entries-to-the-target-ccache.patch

License: MIT
URL: http://web.mit.edu/kerberos/www/
Group: System Environment/Libraries
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: autoconf, bison, flex, gawk, gettext, sed
%if 0%{?fedora} >= 12 || 0%{?rhel} >= 6
BuildRequires: libcom_err-devel, libss-devel
%endif
BuildRequires: gzip, ncurses-devel, tar
%{!?base:BuildRequires: python-sphinx}
# LTC: we dont want the texlive baggage; these docs won't be used
%if ! 0%{?base}
# The texlive package got a lot more complicated here.
%if 0%{?fedora} > 17 || 0%{?rhel} > 6
# Taken from \usepackage directives produced by sphinx:
BuildRequires: tex(babel.sty)
BuildRequires: tex(bookmark.sty)
BuildRequires: tex(fancybox.sty)
BuildRequires: tex(fncychap.sty)
BuildRequires: tex(fontenc.sty)
BuildRequires: tex(framed.sty)
BuildRequires: tex(hyperref.sty)
BuildRequires: tex(ifthen.sty)
BuildRequires: tex(inputenc.sty)
BuildRequires: tex(longtable.sty)
BuildRequires: tex(multirow.sty)
BuildRequires: tex(times.sty)
BuildRequires: tex(titlesec.sty)
BuildRequires: tex(threeparttable.sty)
BuildRequires: tex(wrapfig.sty)
BuildRequires: tex(report.cls)
%else
BuildRequires: texlive-texmf, texlive-texmf-latex
%endif
# Typical fonts, and the commands which we need to have present.
BuildRequires: texlive, texlive-latex, texlive-texmf-fonts
BuildRequires: /usr/bin/pdflatex /usr/bin/makeindex
%endif #end not base for LTC
BuildRequires: keyutils-libs-devel
BuildRequires: libselinux-devel
BuildRequires: pam-devel
%if %{WITH_SYSTEMD}
BuildRequires: systemd-units
%endif
# For the test framework.
BuildRequires: perl, %{!?cross_build:dejagnu,} tcl-devel
BuildRequires: net-tools, %{!?cross_build:rpcbind}
%if 0%{?fedora} >= 13 || 0%{?rhel} > 6
BuildRequires: hostname
BuildRequires: iproute
%endif
%if 0%{?fedora} >= 9
%{!?base:BuildRequires: python-pyrad}
%endif

%if %{WITH_LDAP}
BuildRequires: openldap-devel
%endif
%if %{WITH_OPENSSL} || %{WITH_NSS}
BuildRequires: openssl-devel >= 0.9.8
%endif
%if %{WITH_NSS}
BuildRequires: nss-devel >= 3.13
%endif
%if %{WITH_SYSVERTO}
BuildRequires: libverto-devel
%endif

%description
Kerberos V5 is a trusted-third-party network authentication system,
which can improve your network's security by eliminating the insecure
practice of sending passwords over the network in unencrypted form.

%package devel
Summary: Development files needed to compile Kerberos 5 programs
Group: Development/Libraries
Requires: %{name}-libs%{?_isa} = %{version}-%{release}
%if 0%{?fedora} >= 12 || 0%{?rhel} >= 6
Requires: libcom_err-devel
%endif
Requires: keyutils-libs-devel, libselinux-devel
Requires: libverto-devel

%description devel
Kerberos is a network authentication system. The krb5-devel package
contains the header files and libraries needed for compiling Kerberos
5 programs. If you want to develop Kerberos-aware programs, you need
to install this package.

%package libs
Summary: The shared libraries used by Kerberos 5
Group: System Environment/Libraries
%if 0%{?rhel} == 6
# Some of the older libsmbclient builds here incorrectly called
# krb5_locate_kdc(), which was mistakenly exported in 1.9.
Conflicts: libsmbclient < 3.5.10-124
%endif

%description libs
Kerberos is a network authentication system. The krb5-libs package
contains the shared libraries needed by Kerberos 5. If you are using
Kerberos, you need to install this package.

%package server
Group: System Environment/Daemons
Summary: The KDC and related programs for Kerberos 5
Requires: %{name}-libs%{?_isa} = %{version}-%{release}
Requires(post): chkconfig
%if %{WITH_SYSTEMD}
Requires(post): systemd-sysv
Requires(post): systemd-units
Requires(preun): systemd-units
Requires(postun): systemd-units
%else
Requires(preun): chkconfig
# portreserve is used by init scripts for kadmind, kpropd, and krb5kdc
Requires: portreserve
%endif
Requires(post): initscripts
Requires(postun): initscripts
# we need 'status -l' to work, and that option was added in 8.99
Requires: initscripts >= 8.99-1
# used by the triggers
Requires: chkconfig
# we drop files in its directory, but we don't want to own that directory
Requires: logrotate
Requires(preun): initscripts
# mktemp is used by krb5-send-pr
Requires: coreutils
# we specify /usr/share/dict/words as the default dict_file in kdc.conf
Requires: /usr/share/dict/words
%if %{WITH_SYSVERTO}
# for run-time, and for parts of the test suite
BuildRequires: libverto-module-base
Requires: libverto-module-base
%endif

%description server
Kerberos is a network authentication system. The krb5-server package
contains the programs that must be installed on a Kerberos 5 key
distribution center (KDC).  If you are installing a Kerberos 5 KDC,
you need to install this package (in other words, most people should
NOT install this package).

%package server-ldap
Group: System Environment/Daemons
Summary: The LDAP storage plugin for the Kerberos 5 KDC
Requires: %{name}-server%{?_isa} = %{version}-%{release}
Requires: %{name}-libs%{?_isa} = %{version}-%{release}

%description server-ldap
Kerberos is a network authentication system. The krb5-server package
contains the programs that must be installed on a Kerberos 5 key
distribution center (KDC).  If you are installing a Kerberos 5 KDC,
and you wish to use a directory server to store the data for your
realm, you need to install this package.

%package workstation
Summary: Kerberos 5 programs for use on workstations
Group: System Environment/Base
Requires: %{name}-libs%{?_isa} = %{version}-%{release}
# mktemp is used by krb5-send-pr
Requires: coreutils

%description workstation
Kerberos is a network authentication system. The krb5-workstation
package contains the basic Kerberos programs (kinit, klist, kdestroy,
kpasswd). If your network uses Kerberos, this package should be
installed on every workstation.

%if 0%{?fedora} >= 17 || 0%{?rhel} > 6
%package pkinit
%else
%package pkinit-openssl
%endif
Summary: The PKINIT module for Kerberos 5
Group: System Environment/Libraries
Requires: %{name}-libs%{?_isa} = %{version}-%{release}
%if 0%{?fedora} >= 17 || 0%{?rhel} >= 6
Obsoletes: krb5-pkinit-openssl < %{version}-%{release}
Provides: krb5-pkinit-openssl = %{version}-%{release}
%endif

%if 0%{?fedora} >= 17 || 0%{?rhel} > 6
%description pkinit
%else
%description pkinit-openssl
%endif
Kerberos is a network authentication system. The krb5-pkinit
package contains the PKINIT plugin, which allows clients
to obtain initial credentials from a KDC using a private key and a
certificate.

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -n %{name}-%{version} -a 3 -a 100 -a 999
ln -s NOTICE LICENSE

%patch300 -p1 -b .ksu-intermediates
%patch301 -p1 -b .Don-t-try-to-stat-not-on-disk-ccache-residuals
%patch302 -p1 -b .Use-an-in-memory-cache-until-we-need-the-target-s
%patch303 -p1 -b .Learn-to-destroy-the-ccache-we-re-copying-from
%patch304 -p1 -b .Try-to-use-the-default_ccache_name-d-as-the-target
%patch305 -p1 -b .Be-more-careful-of-target-ccache-collections
%patch306 -p1 -b .Copy-config-entries-to-the-target-ccache

%patch60 -p1 -b .pam

%patch63 -p1 -b .selinux-label

%patch6  -p1 -b .ksu-path
%patch12 -p1 -b .ktany
%patch16 -p1 -b .buildconf %{?_rawbuild}
%patch23 -p1 -b .dns %{?_rawbuild}
%patch29 -p1 -b .kprop-mktemp
%patch30 -p1 -b .send-pr-tempfile
%patch39 -p1 -b .api
%patch56 -p1 -b .doublelog
%patch59 -p1 -b .kpasswd_tcp
%patch71 -p1 -b .dirsrv-accountlock %{?_rawbuild}
%patch86 -p0 -b .debuginfo
%patch105 -p1 -b .kvno
%patch113 -p1 -b .init
%patch116 -p1 -b .aarch64
%patch117 -p1 -b .gss-client-keytab
%patch121 -p1 -b .cccol-primary
%patch123 -p1 -b .empty_passwords
%patch124 -p1 -b .arcfour_short
%patch125 -p1 -b .skew1
%patch126 -p1 -b .skew2
%patch127 -p1 -b .test_gss_no_udp
%patch128 -p1 -b .test_no_pmap
%patch129 -p1 -b .run_user_0
%patch130 -p1 -b .init_referral
%patch131 -p1 -b .skew3
%patch132 -p1 -b .gss-methods1
%patch133 -p1 -b .gss-methods2
%patch134 -p1 -b .kpasswdtest
%patch135 -p1 -b .check_transited
%patch136 -p1 -b .prompter1
%patch137 -p1 -b .prompter2
%patch138 -p1 -b .gss-ccache-import
%patch139 -p1 -b .CVE-2013-1418
%patch140 -p1 -b .CVE-2013-1417
%patch141 -p1 -b .client-loop
%patch142 -p1 -b .no-malloc0
%patch143 -p1 -b .ignore-empty-unnecessary-final-token
%patch144 -p1 -b .gss_oid_leak
%patch145 -p1 -b .keytab_close
%patch146 -p0 -b .preauthcore
%patch147 -p1 -b .copy_context
%patch148 -p1 -b .spnego_error_messages

%patch151 -p1 -b .rcache-internal-const
%patch152 -p1 -b .rcache-acquirecred-cleanup
%patch153 -p1 -b .rcache-acquirecred-leak
%patch154 -p1 -b .rcache-acquirecred-source
%patch155 -p1 -b .empty-credstore
%patch156 -p1 -b .credstoretest
%patch157 -p1 -b .rcache-acquirecred-test

%patch158 -p1 -b .spnego-preserve-oid

%patch159 -p1 -b .CVE-2014-4341_4342
%patch160 -p1 -b .CVE-2014-4341_4342-tests

%patch161 -p1 -b .gssapi-mech-doublefree
%patch162 -p1 -b .gssapi-spnego-deref

%patch163 -p1 -b .2014-001

%patch201 -p1 -b .keycheck
%patch202 -p1 -b .otp
%patch203 -p1 -b .otp2

# Take the execute bit off of documentation.
chmod -x doc/krb5-protocol/*.txt

# Generate an FDS-compatible LDIF file.
inldif=src/plugins/kdb/ldap/libkdb_ldap/kerberos.ldif
cat > 60kerberos.ldif << EOF
# This is a variation on kerberos.ldif which 389 Directory Server will like.
dn: cn=schema
EOF
egrep -iv '(^$|^dn:|^changetype:|^add:)' $inldif | \
sed -r 's,^		,                ,g' | \
sed -r 's,^	,        ,g' >> 60kerberos.ldif
touch -r $inldif 60kerberos.ldif

# Rebuild the configure scripts.
pushd src
#autoheader
#autoconf
./util/reconf --verbose
popd

# Create build space for the test wrapper.
mkdir -p nss_wrapper/build

# Mess with some of the default ports that we use for testing, so that multiple
# builds going on the same host don't step on each other.
cfg="src/kadmin/testing/proto/kdc.conf.proto \
     src/kadmin/testing/proto/krb5.conf.proto \
     src/lib/kadm5/unit-test/api.current/init-v2.exp \
     src/util/k5test.py \
     src/tests/kdc_realm/input_conf/*.conf \
     src/tests/mk_migr/ldap_backend/input_conf/*.conf \
     src/tests/mk_migr/db2_backend/input_conf/*.conf"
LONG_BIT=`getconf LONG_BIT`
PORT=`expr 61000 + $LONG_BIT - 48`
sed -i -e s,61000,`expr "$PORT" + 0`,g $cfg
PORT=`expr 1750 + $LONG_BIT - 48`
sed -i -e s,1750,`expr "$PORT" + 0`,g $cfg
sed -i -e s,1751,`expr "$PORT" + 1`,g $cfg
sed -i -e s,1752,`expr "$PORT" + 2`,g $cfg
PORT=`expr 8888 + $LONG_BIT - 48`
sed -i -e s,8888,`expr "$PORT" - 0`,g $cfg
sed -i -e s,8887,`expr "$PORT" - 1`,g $cfg
sed -i -e s,8886,`expr "$PORT" - 2`,g $cfg
PORT=`expr 7777 + $LONG_BIT - 48`
sed -i -e s,7777,`expr "$PORT" + 0`,g $cfg
sed -i -e s,7778,`expr "$PORT" + 1`,g $cfg

%build
# Go ahead and supply tcl info, because configure doesn't know how to find it.
. %{_libdir}/tclConfig.sh
pushd src
# Keep the old default if the package is built against older releases.
%if 0%{?fedora} > 18 || 0%{?rhel} > 6
DEFCCNAME=DIR:/run/user/%%{uid}/krb5cc; export DEFCCNAME
%endif
# Work out the CFLAGS and CPPFLAGS which we intend to use.
INCLUDES=-I%{_includedir}/et
CFLAGS="`echo $RPM_OPT_FLAGS $DEFINES $INCLUDES -fPIC -fno-strict-aliasing -fstack-protector-all`"
CPPFLAGS="`echo $DEFINES $INCLUDES`"
%configure \
	CC="%{__cc}" \
	CFLAGS="$CFLAGS" \
	CPPFLAGS="$CPPFLAGS" \
%if 0%{?fedora} >= 7 || 0%{?rhel} >= 6
	SS_LIB="-lss" \
%else
	SS_LIB="-lss -lncurses" \
%endif
	--enable-shared \
	--localstatedir=%{_var}/kerberos \
	--disable-rpath \
	--without-krb5-config \
	--with-system-et \
	--with-system-ss \
	--with-netlib=-lresolv \
	--with-tcl \
	--enable-dns-for-realm \
%if %{WITH_LDAP}
	--with-ldap \
%if %{WITH_DIRSRV}
	--with-dirsrv-account-locking \
%endif
%endif
%if %{WITH_OPENSSL} || %{WITH_NSS}
	--enable-pkinit \
%else
	--disable-pkinit \
%endif
%if %{WITH_OPENSSL}
	--with-pkinit-crypto-impl=openssl \
%endif
%if %{WITH_NSS}
	--with-crypto-impl=nss \
%endif
%if %{WITH_SYSVERTO}
	--with-system-verto \
%else
	--without-system-verto \
%endif
	--with-pam \
	--with-selinux
# Now build it.
make
popd

pushd fivextra
make all
popd

%if %{?WITH_DOCS}
# Build the docs.
make -C src/doc paths.py version.py
cp src/doc/paths.py doc/
mkdir -p build-man build-html build-pdf
sphinx-build -a -b man   -t pathsubs doc build-man
sphinx-build -a -b html  -t pathsubs doc build-html
rm -fr build-html/_sources
sphinx-build -a -b latex -t pathsubs doc build-pdf
# Build the PDFs if we didn't have pre-built ones.
for pdf in admin appdev basic build plugindev user ; do
	test -s build-pdf/$pdf.pdf || make -C build-pdf
done
%endif

# Build the test wrapper.
pushd nss_wrapper/build
cmake ..
make
popd

# We need to cut off any access to locally-running nameservers, too.
%{__cc} -fPIC -shared -o noport.so -Wall -Wextra $RPM_SOURCE_DIR/noport.c

%check
# Alright, this much is still a work in progress.
%if %{?__isa_bits:%{__isa_bits}}%{!?__isa_bits:32} == 64
if hostname | grep -q build ; then
	sleep 600
fi
%endif

# Set things up to use the test wrappers.
NSS_WRAPPER_HOSTNAME=test.example.com ; export NSS_WRAPPER_HOSTNAME
NSS_WRAPPER_HOSTS="`pwd`/nss_wrapper/fakehosts" ; export NSS_WRAPPER_HOSTS
echo 127.0.0.1 $NSS_WRAPPER_HOSTNAME $NSS_WRAPPER_HOSTNAME >"$NSS_WRAPPER_HOSTS"
NOPORT=53,111; export NOPORT
LD_PRELOAD=`pwd`/noport.so:`pwd`/nss_wrapper/build/src/libnss_wrapper.so ; export LD_PRELOAD

# Run the test suite. We can't actually run the whole thing in the build
# system, but we can at least run more than we used to.
make -C src runenv.py
: make -C src check TMPDIR=%{_tmppath}
make -C src/lib check TMPDIR=%{_tmppath} OFFLINE=yes
make -C src/kdc check TMPDIR=%{_tmppath}
make -C src/appl check TMPDIR=%{_tmppath}
make -C src/clients check TMPDIR=%{_tmppath}
make -C src/util check TMPDIR=%{_tmppath}

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

# Sample KDC config files (bundled kdc.conf and kadm5.acl).
mkdir -p $RPM_BUILD_ROOT%{_var}/kerberos/krb5kdc
install -pm 600 %{SOURCE10} $RPM_BUILD_ROOT%{_var}/kerberos/krb5kdc/
install -pm 600 %{SOURCE11} $RPM_BUILD_ROOT%{_var}/kerberos/krb5kdc/

# Where per-user keytabs live by default.
mkdir -p $RPM_BUILD_ROOT%{_var}/kerberos/krb5/user

# Default configuration file for everything.
mkdir -p $RPM_BUILD_ROOT/etc
install -pm 644 %{SOURCE6} $RPM_BUILD_ROOT/etc/krb5.conf

# Parent of configuration file for list of loadable GSS mechs ("mechs").  This
# location is not relative to sysconfdir, but is hard-coded in g_initialize.c.
mkdir -m 755 -p $RPM_BUILD_ROOT/etc/gss

# Server init scripts (krb5kdc,kadmind,kpropd) and their sysconfig files.
%if %{WITH_SYSTEMD}
mkdir -p $RPM_BUILD_ROOT%{_unitdir}
for unit in \
	%{SOURCE5}\
	%{SOURCE4} \
	%{SOURCE2} ; do
	# In the past, the init script was supposed to be named after the
	# service that the started daemon provided.  Changing their names
	# is an upgrade-time problem I'm in no hurry to deal with.
	install -pm 644 ${unit} $RPM_BUILD_ROOT%{_unitdir}
done
mkdir -p $RPM_BUILD_ROOT%{_sbindir}
for wrapper in \
	%{SOURCE7} \
	%{SOURCE8} ; do
	install -pm 755 ${wrapper} $RPM_BUILD_ROOT%{_sbindir}/
done
%else
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
for init in \
	%{SOURCE36}\
	%{SOURCE37} \
	%{SOURCE38} ; do
	# In the past, the init script was supposed to be named after the
	# service that the started daemon provided.  Changing their names
	# is an upgrade-time problem I'm in no hurry to deal with.
	service=`basename ${init} .init`
	install -pm 755 ${init} \
	$RPM_BUILD_ROOT/etc/rc.d/init.d/${service%d}
done
# portreserve configuration files.
mkdir -p $RPM_BUILD_ROOT/etc/portreserve
for portreserve in \
	%{SOURCE31} \
	%{SOURCE32} ; do
	install -pm 644 ${portreserve} \
	$RPM_BUILD_ROOT/etc/portreserve/`basename ${portreserve} .portreserve`
done
%endif

mkdir -p $RPM_BUILD_ROOT/etc/sysconfig
for sysconfig in \
	%{SOURCE19}\
	%{SOURCE20} ; do
	install -pm 644 ${sysconfig} \
	$RPM_BUILD_ROOT/etc/sysconfig/`basename ${sysconfig} .sysconfig`
done

# logrotate configuration files
mkdir -p $RPM_BUILD_ROOT/etc/logrotate.d/
for logrotate in \
	%{SOURCE33} \
	%{SOURCE34} ; do
	install -pm 644 ${logrotate} \
	$RPM_BUILD_ROOT/etc/logrotate.d/`basename ${logrotate} .logrotate`
done

# PAM configuration files.
mkdir -p $RPM_BUILD_ROOT/etc/pam.d/
for pam in \
	%{SOURCE29} ; do
	install -pm 644 ${pam} \
	$RPM_BUILD_ROOT/etc/pam.d/`basename ${pam} .pamd`
done

# Plug-in directories.
install -pdm 755 $RPM_BUILD_ROOT/%{_libdir}/krb5/plugins/preauth
install -pdm 755 $RPM_BUILD_ROOT/%{_libdir}/krb5/plugins/kdb
install -pdm 755 $RPM_BUILD_ROOT/%{_libdir}/krb5/plugins/authdata

# The rest of the binaries, headers, libraries, and docs.
make -C src DESTDIR=$RPM_BUILD_ROOT EXAMPLEDIR=%{libsdocdir}/examples install

# Munge krb5-config yet again.  This is totally wrong for 64-bit, but chunks
# of the buildconf patch already conspire to strip out /usr/<anything> from the
# list of link flags, and it helps prevent file conflicts on multilib systems.
sed -r -i -e 's|^libdir=/usr/lib(64)?$|libdir=/usr/lib|g' $RPM_BUILD_ROOT%{_bindir}/krb5-config

%if %{separate_usr}
# Move specific libraries from %%{_libdir} to /%%{_lib}, and fixup the symlinks.
touch $RPM_BUILD_ROOT/rootfile
rellibdir=..
while ! test -r $RPM_BUILD_ROOT/%{_libdir}/${rellibdir}/rootfile ; do
	rellibdir=../${rellibdir}
done
rm -f $RPM_BUILD_ROOT/rootfile
mkdir -p $RPM_BUILD_ROOT/%{_lib}
for library in libgssapi_krb5 libgssrpc libk5crypto libkrb5 libkrb5support ; do
	mv $RPM_BUILD_ROOT/%{_libdir}/${library}.so.* $RPM_BUILD_ROOT/%{_lib}/
	pushd $RPM_BUILD_ROOT/%{_libdir}
	ln -fs ${rellibdir}/%{_lib}/${library}.so.*.* ${library}.so
	popd
done
%endif

%if %{?WITH_DOCS}
# Install processed man pages.
for section in 1 5 8 ; do
	install -m 644 build-man/*.${section} \
		       $RPM_BUILD_ROOT/%{_mandir}/man${section}/
done
%endif

# Steps to package the krb5 tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print`  $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done 
find $RPM_BUILD_ROOT/%{fivdir}/%{name} -depth -name CVS -type d -exec rm -rf {} \;

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%find_lang %{gettext_domain}

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%post libs -p /sbin/ldconfig

%postun libs -p /sbin/ldconfig

%post server-ldap -p /sbin/ldconfig

%postun server-ldap -p /sbin/ldconfig

%post server
# Remove the init script for older servers.
[ -x /etc/rc.d/init.d/krb5server ] && /sbin/chkconfig --del krb5server
%if %{WITH_SYSTEMD}
if [ $1 -eq 1 ] ; then 
    # Initial installation 
    /bin/systemctl daemon-reload >/dev/null 2>&1 || :
fi
%else
# Install the new ones.
/sbin/chkconfig --add krb5kdc
/sbin/chkconfig --add kadmin
/sbin/chkconfig --add kprop
%endif
exit 0

%preun server
if [ "$1" -eq "0" ] ; then
%if %{WITH_SYSTEMD}
	/bin/systemctl --no-reload disable krb5kdc.service > /dev/null 2>&1 || :
	/bin/systemctl --no-reload disable kadmin.service > /dev/null 2>&1 || :
	/bin/systemctl --no-reload disable kprop.service > /dev/null 2>&1 || :
	/bin/systemctl stop krb5kdc.service > /dev/null 2>&1 || :
	/bin/systemctl stop kadmin.service > /dev/null 2>&1 || :
	/bin/systemctl stop kprop.service > /dev/null 2>&1 || :
%else
	/sbin/chkconfig --del krb5kdc
	/sbin/chkconfig --del kadmin
	/sbin/chkconfig --del kprop
	/sbin/service krb5kdc stop > /dev/null 2>&1 || :
	/sbin/service kadmin stop > /dev/null 2>&1 || :
	/sbin/service kprop stop > /dev/null 2>&1 || :
%endif
fi
exit 0

%postun server
%if %{WITH_SYSTEMD}
/bin/systemctl daemon-reload >/dev/null 2>&1 || :
if [ "$1" -ge 1 ] ; then
	/bin/systemctl try-restart krb5kdc.service >/dev/null 2>&1 || :
	/bin/systemctl try-restart kadmin.service >/dev/null 2>&1 || :
	/bin/systemctl try-restart kprop.service >/dev/null 2>&1 || :
fi
%else
if [ "$1" -ge 1 ] ; then
	/sbin/service krb5kdc condrestart > /dev/null 2>&1 || :
	/sbin/service kadmin condrestart > /dev/null 2>&1 || :
	/sbin/service kprop condrestart > /dev/null 2>&1 || :
fi
%endif
exit 0

%if %{WITH_SYSTEMD}
%triggerun server -- krb5-server < 1.9.1-13
# Save the current service runlevel info
# User must manually run 
#  systemd-sysv-convert --apply krb5kdc
#  systemd-sysv-convert --apply kadmin
#  systemd-sysv-convert --apply kprop
# to migrate them to systemd targets
/usr/bin/systemd-sysv-convert --save krb5kdc >/dev/null 2>&1 ||:
/usr/bin/systemd-sysv-convert --save kadmin >/dev/null 2>&1 ||:
/usr/bin/systemd-sysv-convert --save kprop >/dev/null 2>&1 ||:

# Run these because the SysV package being removed won't do them
/sbin/chkconfig --del krb5kdc >/dev/null 2>&1 || :
/sbin/chkconfig --del kadmin >/dev/null 2>&1 || :
/sbin/chkconfig --del kprop >/dev/null 2>&1 || :
/bin/systemctl try-restart krb5kdc.service >/dev/null 2>&1 || :
/bin/systemctl try-restart kadmin.service >/dev/null 2>&1 || :
/bin/systemctl try-restart kprop.service >/dev/null 2>&1 || :
%endif

%triggerun server -- krb5-server < 1.6.3-100
if [ "$2" -eq "0" ] ; then
	/sbin/install-info --delete %{_infodir}/krb425.info.gz %{_infodir}/dir
	/sbin/service krb524 stop > /dev/null 2>&1 || :
	/sbin/chkconfig --del krb524 > /dev/null 2>&1 || :
fi
exit 0

%files workstation
%defattr(-,root,root,-)
%doc src/config-files/services.append
%if %{?WITH_DOCS}
%doc build-html/*
%doc build-pdf/user.pdf build-pdf/basic.pdf
%endif
%attr(0755,root,root) %doc src/config-files/convert-config-files

# Clients of the KDC, including tools you're likely to need if you're running
# app servers other than those built from this source package.
%{_bindir}/kdestroy
%{_mandir}/man1/kdestroy.1*
%{_bindir}/kinit
%{_mandir}/man1/kinit.1*
%{_bindir}/klist
%{_mandir}/man1/klist.1*
%{_bindir}/kpasswd
%{_mandir}/man1/kpasswd.1*
%{_bindir}/kswitch
%{_mandir}/man1/kswitch.1*

%{_bindir}/kvno
%{_mandir}/man1/kvno.1*
%{_bindir}/kadmin
%{_mandir}/man1/kadmin.1*
%{_bindir}/k5srvutil
%{_mandir}/man1/k5srvutil.1*
%{_bindir}/ktutil
%{_mandir}/man1/ktutil.1*

# Doesn't really fit anywhere else.
%attr(4755,root,root) %{_bindir}/ksu
%{_mandir}/man1/ksu.1*
%config(noreplace) /etc/pam.d/ksu

# Problem-reporting tool.
%{_sbindir}/krb5-send-pr
%dir %{_datadir}/gnats
%{_datadir}/gnats/mit
%{_mandir}/man1/krb5-send-pr.1*

%files server
%defattr(-,root,root,-)
%docdir %{_mandir}
%{?WITH_DOCS:%doc build-pdf/admin.pdf build-pdf/build.pdf}
%if %{WITH_SYSTEMD}
%{_unitdir}/krb5kdc.service
%{_unitdir}/kadmin.service
%{_unitdir}/kprop.service
%else
/etc/rc.d/init.d/krb5kdc
/etc/rc.d/init.d/kadmin
/etc/rc.d/init.d/kprop
%config(noreplace) /etc/portreserve/kerberos-adm
%config(noreplace) /etc/portreserve/krb5_prop
%endif
%config(noreplace) /etc/sysconfig/krb5kdc
%config(noreplace) /etc/sysconfig/kadmin
%config(noreplace) /etc/logrotate.d/krb5kdc
%config(noreplace) /etc/logrotate.d/kadmind

%dir %{_var}/kerberos
%dir %{_var}/kerberos/krb5kdc
%config(noreplace) %{_var}/kerberos/krb5kdc/kdc.conf
%config(noreplace) %{_var}/kerberos/krb5kdc/kadm5.acl

%dir %{_libdir}/krb5
%dir %{_libdir}/krb5/plugins
%dir %{_libdir}/krb5/plugins/kdb
%dir %{_libdir}/krb5/plugins/preauth
%dir %{_libdir}/krb5/plugins/authdata
%{_libdir}/krb5/plugins/preauth/otp.so


# Problem-reporting tool.
%{_sbindir}/krb5-send-pr
%dir %{_datadir}/gnats
%{_datadir}/gnats/mit
%{_mandir}/man1/krb5-send-pr.1*

# KDC binaries and configuration.
%{_mandir}/man5/kadm5.acl.5*
%{_mandir}/man5/kdc.conf.5*
%{_sbindir}/kadmin.local
%{_mandir}/man8/kadmin.local.8*
%{_sbindir}/kadmind
%{_sbindir}/_kadmind
%{_mandir}/man8/kadmind.8*
%{_sbindir}/kdb5_util
%{_mandir}/man8/kdb5_util.8*
%{_sbindir}/kprop
%{_mandir}/man8/kprop.8*
%{_sbindir}/kpropd
%{_sbindir}/_kpropd
%{_mandir}/man8/kpropd.8*
%{_sbindir}/kproplog
%{_mandir}/man8/kproplog.8*
%{_sbindir}/krb5kdc
%{_mandir}/man8/krb5kdc.8*

# This is here for people who want to test their server, and also 
# included in devel package for similar reasons.
%{_bindir}/sclient
%{_mandir}/man1/sclient.1*
%{_sbindir}/sserver
%{_mandir}/man8/sserver.8*

%if %{WITH_LDAP}
%files server-ldap
%defattr(-,root,root,-)
%docdir %{_mandir}
%doc src/plugins/kdb/ldap/libkdb_ldap/kerberos.ldif
%doc src/plugins/kdb/ldap/libkdb_ldap/kerberos.schema
%doc 60kerberos.ldif
%dir %{_libdir}/krb5
%dir %{_libdir}/krb5/plugins
%dir %{_libdir}/krb5/plugins/kdb
%{_libdir}/krb5/plugins/kdb/kldap.so
%{_libdir}/libkdb_ldap.so
%{_libdir}/libkdb_ldap.so.*
%{_mandir}/man8/kdb5_ldap_util.8.gz
%{_sbindir}/kdb5_ldap_util
%endif

%files libs -f %{gettext_domain}.lang
%defattr(-,root,root,-)
%doc README NOTICE LICENSE
%docdir %{_mandir}
# This is a hard-coded, not-dependent-on-the-configure-script path.
%dir /etc/gss
%verify(not md5 size mtime) %config(noreplace) /etc/krb5.conf
/%{_mandir}/man5/.k5identity.5*
/%{_mandir}/man5/.k5login.5*
/%{_mandir}/man5/k5identity.5*
/%{_mandir}/man5/k5login.5*
/%{_mandir}/man5/krb5.conf.5*
%if %{separate_usr}
/%{_lib}/libgssapi_krb5.so.*
/%{_lib}/libgssrpc.so.*
/%{_lib}/libk5crypto.so.*
%else
%{_libdir}/libgssapi_krb5.so.*
%{_libdir}/libgssrpc.so.*
%{_libdir}/libk5crypto.so.*
%endif
%{_libdir}/libkadm5clnt_mit.so.*
%{_libdir}/libkadm5srv_mit.so.*
%{_libdir}/libkdb5.so.*
%{_libdir}/libkrad.so.*
%if %{separate_usr}
/%{_lib}/libkrb5.so.*
/%{_lib}/libkrb5support.so.*
%else
%{_libdir}/libkrb5.so.*
%{_libdir}/libkrb5support.so.*
%endif
%dir %{_libdir}/krb5
%dir %{_libdir}/krb5/plugins
%dir %{_libdir}/krb5/plugins/*
%{_libdir}/krb5/plugins/kdb/db2.so
%dir %{_var}/kerberos
%dir %{_var}/kerberos/krb5
%dir %{_var}/kerberos/krb5/user
%if ! %{WITH_SYSVERTO}
%{_libdir}/libverto-k5ev.so
%{_libdir}/libverto-k5ev.so.*
# These really shouldn't be here, but until we have a system copy of libverto,
# don't force people who are using libverto to install the KDC just to get the
# shared library.  Not that there are any development headers, but anyway.
%{_libdir}/libverto.so
%{_libdir}/libverto.so.*
%endif

%if 0%{?fedora} >= 17 || 0%{?rhel} > 6
%files pkinit
%else
%files pkinit-openssl
%endif
%defattr(-,root,root,-)
%dir %{_libdir}/krb5
%dir %{_libdir}/krb5/plugins
%dir %{_libdir}/krb5/plugins/preauth
%{_libdir}/krb5/plugins/preauth/pkinit.so

%files devel
%defattr(-,root,root,-)
%docdir %{_mandir}
%doc doc/krb5-protocol
%doc build-pdf/appdev.pdf build-pdf/plugindev.pdf

%{_includedir}/*
%{_libdir}/libgssapi_krb5.so
%{_libdir}/libgssrpc.so
%{_libdir}/libk5crypto.so
%{_libdir}/libkadm5clnt.so
%{_libdir}/libkadm5clnt_mit.so
%{_libdir}/libkadm5srv.so
%{_libdir}/libkadm5srv_mit.so
%{_libdir}/libkdb5.so
%{_libdir}/libkrad.so
%{_libdir}/libkrb5.so
%{_libdir}/libkrb5support.so

%{_bindir}/krb5-config
%{_bindir}/sclient
%{_mandir}/man1/krb5-config.1*
%{_mandir}/man1/sclient.1*
%{_mandir}/man8/sserver.8*
%{_sbindir}/sserver

# Protocol test clients.
%{_bindir}/sim_client
%{_bindir}/gss-client
%{_bindir}/uuclient

# Protocol test servers.
%{_sbindir}/sim_server
%{_sbindir}/gss-server
%{_sbindir}/uuserver

%files fivextra
%{prefix}

%changelog
* Thu Sep 04 2014 baseuser@ibm.com
- Base-f19.x spec file
