################################################################################
# Edit the following as needed for your release package
################################################################################
%define base_major_version 19
# REPOSITORY verify base full version (eg 7.0, 7.1, etc)
%define base_full_version 19_0
# PKVM STREAM
%define pkvm_stream 2.1.0
# Red Hat STREAM
%define rh_stream 3.4
# REPOSITORY update customer titlecase name (eg: Bedrock)
%define customer_titlecase powerKVM
# REPOSITORY update repository name. This should match what you entered
# for "Repository Name" in the web ui.
%define repo_name pkvm2_1
# REPOSITORY update repository extention. This is the value appened to all
# RPMs built for your repo and should match your %dist value (include inital .).
%define repo_extension .pkvm2_1
# REPOSITORY verify milestone (Alpha/Beta/RC/Gold/Service)
%define milestone service
# Bump this number to incremement the Release (required for each new build).
%define pkvm_release 39
# Bump this number to increment the respin
%define respin .0
# Define service stream
%define service_stream 3
################################################################################

%define debug_package %{nil}
%define product_family IBM_PowerKVM
%define rh_product_family RHEV for IBM POWER
%define rh_product_id rhev for ibm power

Name:		%{repo_name}-release
Version:	%{base_full_version}
Release:	%{?rh_stream}.%{?service_stream}.%{?pkvm_release}%{?respin}%{?dist}
Summary:	%{product_family}%{?customer_titlecase: %{customer_titlecase}} release files
Group:		System Environment/Base
License:	EPL
Obsoletes:	rawhide-release redhat-release-as redhat-release-es redhat-release-ws redhat-release-de comps rpmdb-redhat fedora-release redhat-release frobisher2_0-release
Provides:	redhat-release system-release
Source1:	base.repo
BuildArch:	noarch

%description
%{product_family}%{?customer_titlecase: %{customer_titlecase}} release files

%prep
# Put sources in the BUILD dir
%{__cp} %{SOURCE1} .
%{__cp} %{_sourcedir}/RPM-GPG-KEY-ibm_powerkvm-%{pkvm_stream} .
%{__cp} -r %{_sourcedir}/licenses .

%build

%install
rm -rf %{buildroot}
%{__mkdir_p} %{buildroot}/etc/pki/rpm-gpg/
%{__mkdir_p} %{buildroot}%{_docdir}/%{name}-%{version}

# copy licenses
%{__cp} -r licenses %{buildroot}%{_docdir}/%{name}-%{version}

# copy rpm key and create a link handle it in code easily
%{__cp} RPM-GPG-KEY-ibm_powerkvm-%{pkvm_stream} %{buildroot}/etc/pki/rpm-gpg/
ln -s /etc/pki/rpm-gpg/RPM-GPG-KEY-ibm_powerkvm-%{pkvm_stream} %{buildroot}/etc/pki/rpm-gpg/RPM-GPG-KEY-ibm_powerkvm

# create a symlink in /opt/ibm
%{__mkdir_p} %{buildroot}/opt/ibm
ln -s %{_docdir}/%{name}-%{version}/licenses %{buildroot}/opt/ibm/powerkvm-licenses

# create /etc/system-release and /etc/base-release
echo "%{rh_product_family} release %{rh_stream} build %{pkvm_release} %{milestone} (%{repo_name})" > %{buildroot}/etc/base-release
ln -s base-release %{buildroot}/etc/system-release

# create /etc/ibm_powerkvm-release
echo "%{product_family} release %{pkvm_stream} build %{pkvm_release} %{milestone} (%{repo_name})" > %{buildroot}/etc/ibm_powerkvm-release

# write cpe to /etc/system-release-cpe
# http://cpe.mitre.org/specification/index.html
echo "cpe:/o:ibm:ibm_powerkvm:%{rh_stream}:%{milestone}:%{repo_name}:" | tr [A-Z] [a-z] > %{buildroot}/etc/system-release-cpe

# create an /etc/os-release file
echo "NAME=\"%{rh_product_family}\"" > %{buildroot}/etc/os-release
echo "VERSION=\"%{rh_stream}\"" >> %{buildroot}/etc/os-release
echo "ID=\"%{rh_product_id}\"" >> %{buildroot}/etc/os-release
echo "VERSION_ID=\"%{rh_stream}\"" >> %{buildroot}/etc/os-release
echo "BUILD_ID=\"%{pkvm_release}%{?respin}-%{milestone}\"" >> %{buildroot}/etc/os-release
echo "PRETTY_NAME=\"%{rh_product_family} %{rh_stream}\"" >> %{buildroot}/etc/os-release
echo "ANSI_COLOR=\"0;34\"" >> %{buildroot}/etc/os-release
echo -n "CPE_NAME=" >> %{buildroot}/etc/os-release
echo "\"cpe:/o:ibm:%{milestone}:%{repo_name}\"" | tr [A-Z] [a-z] >> %{buildroot}/etc/os-release

# create /etc/issue and /etc/issue.net
cp %{buildroot}/etc/base-release %{buildroot}/etc/issue
echo "Kernel \r on a \m (\l)" >> %{buildroot}/etc/issue
cp %{buildroot}/etc/issue %{buildroot}/etc/issue.net
echo >> %{buildroot}/etc/issue

mkdir -p %{buildroot}/etc/yum/vars
echo "%{rh_stream}" > %{buildroot}/etc/yum/vars/ibmver

# set up the dist tag macros
install -d -m 755 %{buildroot}/etc/rpm
cat >> %{buildroot}/etc/rpm/macros.dist << EOF
# dist macros.

%%fedora %{base_major_version}
%%dist %{repo_extension}
%%fedora%{base_full_version} 1

#Define base also
%%base %{base_major_version}
%%base%{base_full_version} 1
EOF

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root)
%{_docdir}/%{name}-%{version}/licenses/*
%dir %{_docdir}/%{name}-%{version}/licenses
%attr(0644,root,root) /etc/base-release
/etc/ibm_powerkvm-release
/etc/system-release
%dir /opt/ibm
/opt/ibm/powerkvm-licenses
%attr(0644,root,root) /etc/pki/rpm-gpg/RPM-GPG-KEY-ibm_powerkvm-%{pkvm_stream}
/etc/pki/rpm-gpg/RPM-GPG-KEY-ibm_powerkvm
%config %attr(0644,root,root) /etc/system-release-cpe
%config %attr(0644,root,root) /etc/os-release
%config %attr(0644,root,root) /etc/issue
%config %attr(0644,root,root) /etc/issue.net
%config %attr(0644,root,root) /etc/yum/vars/ibmver
%config %attr(0644,root,root) /etc/rpm/macros.dist

%changelog
* Mon May 19 2014 <usr>  <user@domain> - 19-2.1.0.0.16
- Added service stream
* Mon Feb 10 2014 <usr>  <user@domain> - 19-2.1.9
- New pkvm naming space
- Adjusting several variables to comply with rpm versioning guidelines
- Bumped to build 9 (beta1)
* Mon Jan 13 2014 <usr>  <user@domain> - 8.0-7.0
- Bumped build release
* Fri Dec 6 2013 <usr>  <user@domain> - 8.0-6.0
- Bumped build release
- Changed product_family
- Adjusted base.repo to a stricter policy for add. packages
* Wed Dec 4 2013 <user> <user@domain> - 8.0-5.1
- Bumped build release (re-spin)
- Minor label changes (issue, os-release...)
* Fri Nov 29 2013 <user> <user@domain> - 8.0-5
- Bumped build release
- Changed product_family
- General modifications in the product nomenclature
* Wed Nov 6 2013 <user> <user@domain> - 8.0-4
- Added ibmver yum variable
* Thu Oct 28 2010 <user> <user@domain> - 7.0-1
- Created Initial release package
