Name:		GeoIP
Version:	1.5.0
%define base_release .4
Release:	6%{?dist}%{?base_release}
Summary:	Library for country/city/organization to IP address or hostname mapping
Group:		Development/Libraries
License:	LGPLv2+ and GPLv2+
URL:		http://www.maxmind.com/app/c
Source0:	http://www.maxmind.com/download/geoip/api/c/GeoIP-%{version}.tar.gz
Source1:	LICENSE.txt
Source2:	fetch-geoipdata-city.pl
Source3:	fetch-geoipdata.pl
Source5:	geoipupdate.cron
Patch10:	GeoIP-1.5.0-UTF8.patch
Source999:	fivextra.tar.bz2
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(id -nu)
BuildRequires:	zlib-devel
Obsoletes:	geoip < %{version}-%{release}
Provides:	geoip = %{version}-%{release}

%description
GeoIP is a C library that enables the user to find the country that any IP
address or hostname originates from. It uses a file based database that is
updated at install time if possible, and can optionally be updated on a weekly
basis by installing the GeoIP-update package. This database simply contains IP
blocks as keys, and countries as values. This database should be more complete
and accurate than using reverse DNS lookups.

%package update
Summary:	Crontab entry to facilitate automatic updates of databases
Group:		Applications/Databases
Requires:	crontabs
Requires:	%{name} = %{version}-%{release}

%description update
Crontab entry to provide weekly updates of the GeoIP free databases.

%package devel
Summary:	Development headers and libraries for GeoIP
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}
Provides:	geoip-devel = %{version}-%{release}
Obsoletes:	geoip-devel < %{version}-%{release}

%description devel
Development headers and static libraries for building GeoIP-based applications.

%Package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -a 999

# Recode docs as UTF-8
%patch10 -p1

install -D -m644 %{SOURCE1} LICENSE.txt
install -D -m644 %{SOURCE2} fetch-geoipdata-city.pl
install -D -m644 %{SOURCE3} fetch-geoipdata.pl
install -D -m644 %{SOURCE5} geoipupdate.cron

%build
# Fix timestamp order to avoid trying to re-run autotools and configure,
# thus clobbering our hacked libtool later on
touch aclocal.m4
touch configure
touch config.h.in
touch config.status
find . -name Makefile.in -exec touch {} \;

%configure --disable-static --disable-dependency-tracking

# Kill bogus rpaths
sed -i -e 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' \
	-e 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool

make %{?_smp_mflags}

%install
rm -rf %{buildroot}
make DESTDIR=%{buildroot} DEFAULT_DB_FILE="%{_datadir}/GeoIP/GeoIP-initial.dat" install

# fetch database updates weekly
install -D -m755 geoipupdate.cron %{buildroot}%{_sysconfdir}/cron.weekly/geoipupdate

# Steps to package the GeoIP tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
 install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
 install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

pushd test/.libs
install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/test
install * $RPM_BUILD_ROOT/%{fivdir}/%{name}/test
popd

pushd test/
install city_test.txt  $RPM_BUILD_ROOT/%{fivdir}/%{name}/test
popd
find $RPM_BUILD_ROOT/%{fivdir}/%{name}/test -name '*.o' | xargs rm -rf

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

# nix the stuff we don't need like .la files.
rm -f %{buildroot}%{_libdir}/*.la

# fix up the config file to use the free products by default
sed -i \
	-e 's/YOUR_LICENSE_KEY_HERE$/000000000000/' \
	-e 's/YOUR_USER_ID_HERE$/999999/' \
	-e 's/106$/506 533 517/' \
	%{buildroot}%{_sysconfdir}/GeoIP.conf

# make the default GeoIP.dat a symlink to GeoIP-initial.dat,
# at least until %%post has run
ln -sf GeoIP-initial.dat %{buildroot}%{_datadir}/GeoIP/GeoIP.dat

# create empty files for initial %%ghost databases
touch %{buildroot}%{_datadir}/GeoIP/GeoLite{ASNum,City,Country}.dat
chmod 644 %{buildroot}%{_datadir}/GeoIP/GeoLite{ASNum,City,Country}.dat

%clean
rm -rf %{buildroot}

%post
/sbin/ldconfig
geoipupdate > /dev/null && \
	ln -sf GeoLiteCountry.dat %{_datadir}/GeoIP/GeoIP.dat

%postun -p /sbin/ldconfig

%files
# LGPLv2+
%doc AUTHORS COPYING ChangeLog README TODO LICENSE* fetch-*
%config(noreplace) %{_sysconfdir}/GeoIP.conf
%config(noreplace) %{_sysconfdir}/GeoIP.conf.default
%{_bindir}/geoiplookup
%{_bindir}/geoiplookup6
%dir %{_datadir}/GeoIP/
%{_datadir}/GeoIP/GeoIP-initial.dat
%verify(not md5 size link mtime) %{_datadir}/GeoIP/GeoIP.dat
%ghost %{_datadir}/GeoIP/GeoLiteASNum.dat
%ghost %{_datadir}/GeoIP/GeoLiteCity.dat
%ghost %{_datadir}/GeoIP/GeoLiteCountry.dat
%{_libdir}/libGeoIP.so.1
%{_libdir}/libGeoIP.so.1.*
%{_mandir}/man1/geoiplookup.1*
%{_mandir}/man1/geoiplookup6.1*
# GPLv2+
%{_bindir}/geoipupdate
%{_libdir}/libGeoIPUpdate.so.0
%{_libdir}/libGeoIPUpdate.so.0.*
%{_mandir}/man1/geoipupdate.1*

%files update
%{_sysconfdir}/cron.weekly/geoipupdate

%files devel
# LGPLv2+
%{_includedir}/GeoIP.h
%{_includedir}/GeoIPCity.h
%{_includedir}/GeoIPUpdate.h
%{_libdir}/libGeoIP.so
%{_libdir}/pkgconfig/geoip.pc
# GPLv2+
%{_libdir}/libGeoIPUpdate.so

%files fivextra
%{prefix}

%changelog
* Wed Jul 17 2013 baseuser@ibm.com
- Base-8.x spec file
