%if %{?WITH_SELINUX:0}%{!?WITH_SELINUX:1}
%global WITH_SELINUX 1
%endif
Summary: A GNU file archiving program
Name: tar
Epoch: 2
Version: 1.26
%define base_release .2
Release: 28%{?dist}%{?base_release}
License: GPLv3+
Group: Applications/Archiving
URL: http://www.gnu.org/software/tar/

Source0: ftp://ftp.gnu.org/pub/gnu/tar/tar-%{version}.tar.xz
Source1: ftp://ftp.gnu.org/pub/gnu/tar/tar-%{version}.tar.xz.sig
# Manpage for tar and gtar, a bit modified help2man generated manpage
Source2: tar.1
Source999: fivextra.tar.bz2

# Stop issuing lone zero block warnings.
# ~> https://bugzilla.redhat.com/show_bug.cgi?id=135601
# ~> downstream
Patch1: tar-1.14-loneZeroWarning.patch

# Fix extracting sparse files to a file system like vfat, when ftruncate may fail
# to grow the size of a file.
# ~> #179507,
# ~> http://lists.gnu.org/archive/html/bug-tar/2006-02/msg00000.html
# ~> still downtream (do we need this now? ftruncate & vfat works is now OK)
Patch2: tar-1.15.1-vfatTruncate.patch

# Change inclusion defaults of tar to
# "--wildcards --anchored --wildcards-match-slash" for compatibility reasons.
# ~> #206841
# ~> downstream (compatibility)
Patch3: tar-1.17-wildcards.patch

# Ignore errors from setting utime() for source file on read-only file-system.
# ~> #500742
# ~> http://lists.gnu.org/archive/html/bug-tar/2009-06/msg00016.html
# ~> still downstream
Patch4: tar-1.22-atime-rofs.patch

# The --old-archive option was not working.
# ~> #594044
# ~> http://lists.gnu.org/archive/html/bug-tar/2010-05/msg00015.html
# ~> upstream (2a61a37)
Patch5: tar-1.23-oldarchive.patch

# Fix for bad cooperation of -C and -u options.
# ~> #688567
# ~> http://lists.gnu.org/archive/html/bug-tar/2012-02/msg00007.html
# ~> still downstream
Patch6: tar-1.26-update-with-change-directory.patch

# Fix rawhide build failure with undefined gets.
# ~> upstream (gnulib)
Patch7: tar-1.26-stdio.in.patch

# Fix regression with --keep-old-files option.
# ~> #799252
# ~> http://lists.gnu.org/archive/html/bug-tar/2011-11/msg00043.html
# ~> upstream (7a5a3708c)
Patch8: tar-1.26-add-skip-old-files-option.patch

# Prepare included gnulib library for SELinux support.
# -> Related to the next patch.
Patch9:  tar-1.26-selinux-gnulib.patch

# Add support for extended attributes, SELinux and POSIX ACLs.
# ~> Original implementation #200925
# ~> http://lists.gnu.org/archive/html/bug-tar/2012-08/msg00012.html
# ~> upstream (b997c90f9, 696338043, d36f5a3cc, 085cace18, up-to ~> 83701a590)
Patch10: tar-1.26-xattrs.patch

# Fix problem with bit UIDs/GIDs (> 2^21) and --posix format.
# ~> #913406
# ~> upstream (it is part of df7b55a8f6354e)
Patch11: tar-1.26-posix-biguid.patch

# Allow store sparse files of effective size >8GB into pax archives
# ~> #516309
# ~> http://lists.gnu.org/archive/html/bug-tar/2013-01/msg00001.html
# ~> already upstream (2f6c03cba)
Patch12: tar-1.26-pax-big-sparse-files.patch

# Fix: Allow extracting single volume in a multi-volume archive
# ~> #919897
# ~> http://lists.gnu.org/archive/html/bug-tar/2013-03/msg00002.html
# ~> upstream (beca89bc)
Patch13: tar-1.26-allow-extract-single-volume.patch

# Do not print xattrs/selinux/acls when --no-xattrs/--no-acls/--no-selinux
# options are used during -tvv output.  (TODO: merge this with xattrs patch
# once becomes upstream)
# ~> downstream (yet)
# ~> proposal: http://lists.gnu.org/archive/html/bug-tar/2013-05/msg00020.html
Patch14: tar-1.26-xattrs-printing.patch

# Use a birthtime instead of ctime.
# ~> upstream (189e43 & 49bd10)
# ~> http://lists.gnu.org/archive/html/bug-tar/2011-06/msg00000.html
# ~> http://lists.gnu.org/archive/html/bug-tar/2013-05/msg00022.html
Patch15: tar-1.26-fix-symlink-eating-bug.patch

# Add documentation which was not yet pushed upstream
# ~> downstream
# ~> #996753
Patch16: tar-1.26-docu-xattrs.patch

# The --xattrs-include or --xattrs-exclude options should imply --xattrs.
# ~> still downstream
#    http://lists.gnu.org/archive/html/bug-tar/2013-05/msg00020.html
# ~> #965969

Patch17: tar-1.26-xattrs-include-implies-xattrs.patch

# If the 'st_size' != 0 && count(blocks) == 0 && st_size < size(block), this
# does not necessarily must be a sparse file.
# ~> upstream (paxutils):  986382a0bb3261
# ~> #1024095
Patch18: tar-1.26-sparse-stat-detection.patch

# Fix for --compare (or --verify) & --listed-incremental
# ~> #1040702
# ~> upstream (d88b2a61)
Patch19: tar-1.26-compare-incremental.patch

# Test case for ^^^
# ~> downstream, proposed:
#    http://www.mail-archive.com/bug-tar@gnu.org/msg04294.html
Patch20: tar-1.26-testsuite-diff-incr.patch

# Silence gcc warnings
# ~> upstream tar: 17f99bc6f, 5bb0433
# ~> upstream paxutils: 0b3d84a0
Patch999: tar-1.26-silence-gcc.patch

Patch104103: bug-104103-tar-warn-for-waste-xattrs-inc-exc-lude.patch

# run "make check" by default
%bcond_without check

BuildRequires: autoconf automake texinfo gettext libacl-devel %{!?cross_build:rsh}

%if %{with check}
# cover needs of tar's testsuite
BuildRequires: attr acl %{!?cross_build:policycoreutils}
%endif

%if %{WITH_SELINUX}
BuildRequires: libselinux-devel
%endif
Provides: bundled(gnulib)
Provides: /bin/tar
Provides: /bin/gtar
Requires(post): /sbin/install-info
Requires(preun): /sbin/install-info

%description
The GNU tar program saves many files together in one archive and can
restore individual files (or all of the files) from that archive. Tar
can also be used to add supplemental files to an archive and to update
or list files in the archive. Tar includes multivolume support,
automatic archive compression/decompression, the ability to perform
remote archives, and the ability to perform incremental and full
backups.

If you want to use tar for remote backups, you also need to install
the rmt package on the remote box.

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -a 999
%patch1 -p1 -b .loneZeroWarning
%patch2 -p1 -b .vfatTruncate
%patch3 -p1 -b .wildcards
%patch4 -p1 -b .rofs
%patch5 -p1 -b .oldarchive
%patch6 -p1 -b .update_and_changedir
%patch7 -p1 -b .gets  %{?_rawbuild}
%patch8 -p1 -b .skip-old-files
%patch9 -p1 -b .selinux-gnulib-prep
%patch10 -p1 -b .xattrs-selinux-acls
%patch11 -p1 -b .big_uid_gid
%patch12 -p1 -b .pax-sparse-big-files
%patch13 -p1 -b .extract-single-volume
%patch14 -p1 -b .print-xattrs-fix
%patch15 -p1 -b .birthtime
%patch16 -p1 -b .xattrs-documentation
%patch17 -p1 -b .xattrs-if-xattrs-include
%patch18 -p1 -b .sparse-stat-detection
%patch19 -p1 -b .compare-and-incremental
%patch20 -p1 -b .testsuite-diff-incr
%patch999 -p1 -b .silence-gcc
%patch104103 -p1

autoreconf -v

%build
%if ! %{WITH_SELINUX}
%global CONFIGURE_SELINUX --without-selinux
%endif

%configure %{?CONFIGURE_SELINUX} \
    DEFAULT_RMT_DIR=%{_sysconfdir} \
    RSH=/usr/bin/ssh
make

pushd fivextra
make all
popd

%install
make DESTDIR=$RPM_BUILD_ROOT install

ln -s tar $RPM_BUILD_ROOT%{_bindir}/gtar
rm -f $RPM_BUILD_ROOT/%{_infodir}/dir
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man1
install -c -p -m 0644 %{SOURCE2} $RPM_BUILD_ROOT%{_mandir}/man1
ln -s tar.1.gz $RPM_BUILD_ROOT%{_mandir}/man1/gtar.1

# XXX Nuke unpackaged files.
rm -f $RPM_BUILD_ROOT%{_sysconfdir}/rmt

%find_lang %name

# Steps to package the tar tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print`  $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done 
find $RPM_BUILD_ROOT/%{fivdir}/%{name} -depth -name CVS -type d -exec rm -rf {} \;

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%check
%if %{with check}
rm -f $RPM_BUILD_ROOT/test/testsuite
make check || TESTSUITEFLAGS=-v make check
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%post
if [ -f %{_infodir}/tar.info.gz ]; then
   /sbin/install-info %{_infodir}/tar.info.gz %{_infodir}/dir || :
fi

%preun
if [ $1 = 0 ]; then
   if [ -f %{_infodir}/tar.info.gz ]; then
      /sbin/install-info --delete %{_infodir}/tar.info.gz %{_infodir}/dir || :
   fi
fi

%files -f %{name}.lang
%doc AUTHORS ChangeLog ChangeLog.1 COPYING NEWS README THANKS TODO
%{_bindir}/tar
%{_bindir}/gtar
%{_mandir}/man1/tar.1*
%{_mandir}/man1/gtar.1*
%{_infodir}/tar.info*

%files fivextra
%{prefix}

%changelog
* Wed Jan 22 2014 baseuser@ibm.com
- Base-f19.x spec file
