Name:       SDL
Version:    1.2.15
%define base_release .3
Release:    8%{?dist}%{?base_release}
Summary:    A cross-platform multimedia library
Group:      System Environment/Libraries
URL:        http://www.libsdl.org/
# The license of the file src/video/fbcon/riva_mmio.h is bad, but the contents
# of the file has been relicensed to MIT in 2008 by Nvidia for the 
# xf86_video-nv driver, therefore it can be considered ok.
License:    LGPLv2+
# Source: http://www.libsdl.org/release/%%{name}-%%{version}.tar.gz
# To create the repackaged archive use ./repackage.sh %%{version}
Source0:    %{name}-%{version}_repackaged.tar.gz
Source1:    SDL_config.h
Source2:    repackage.sh
Patch0:     SDL-1.2.12-multilib.patch
# Rejected by upstream as sdl1155, rh480065
Patch1:     SDL-1.2.10-GrabNotViewable.patch
# Proposed to upstream as sdl1680, rh891973
Patch2:     SDL-1.2.15-x11-Bypass-SetGammaRamp-when-changing-gamma.patch
# Proposded to upstream as sdl1769
Patch3:     SDL-1.2.15-const_XData32.patch

BuildRequires:  alsa-lib-devel
%if ! 0%{?cross_build}
BuildRequires:  audiofile-devel
BuildRequires:  mesa-libGL-devel
BuildRequires:  mesa-libGLU-devel
BuildRequires:  libXrandr-devel
BuildRequires:  pulseaudio-libs-devel
%endif
BuildRequires:  libXext-devel
BuildRequires:  libX11-devel
BuildRequires:  libXrender-devel
%ifarch %{ix86}
BuildRequires:  nasm
%endif
# Autotools
BuildRequires:  automake
BuildRequires:  autoconf
BuildRequires:  libtool

%description
Simple DirectMedia Layer (SDL) is a cross-platform multimedia library designed
to provide fast access to the graphics frame buffer and audio device.

%package devel
Summary:    Files needed to develop Simple DirectMedia Layer applications
Group:      Development/Libraries
Requires:   SDL%{?_isa} = %{version}-%{release}
Requires:   alsa-lib-devel
%if ! 0%{?cross_build}
Requires:   mesa-libGL-devel
Requires:   mesa-libGLU-devel
Requires:   libXrandr-devel
%endif
Requires:   libX11-devel
Requires:   libXext-devel
Requires:   libXrender-devel

%description devel
Simple DirectMedia Layer (SDL) is a cross-platform multimedia library designed
to provide fast access to the graphics frame buffer and audio device. This
package provides the libraries, include files, and other resources needed for
developing SDL applications.

%package static
Summary:    Files needed to develop static Simple DirectMedia Layer applications
Group:      Development/Libraries
Requires:   SDL-devel%{?_isa} = %{version}-%{release}

%description static
Simple DirectMedia Layer (SDL) is a cross-platform multimedia library designed
to provide fast access to the graphics frame buffer and audio device. This
package provides the static libraries needed for developing static SDL
applications.

%prep
%setup -q -b0
%patch0 -p1 -b .multilib
%patch1 -p0 -b .grabnotviewable
%patch2 -p1 -b .gamma
%patch3 -p1 -b .XData32
for F in CREDITS; do 
    iconv -f iso8859-1 -t utf-8 < "$F" > "${F}.utf"
    touch --reference "$F" "${F}.utf"
    mv "${F}.utf" "$F"
done
# Compilation without ESD
sed -i -e 's/.*AM_PATH_ESD.*//' configure.in
# Update config.sub to support aarch64, bug #926510
cp -p %{_datadir}/automake-*/config.{sub,guess} build-scripts

%build
aclocal
libtoolize
autoconf
# LTC: we hit this http://bugzilla.libsdl.org/show_bug.cgi?id=257 unless we disable x11-shared
%configure \
    %{?fedora:--disable-x11-shared} \
    --disable-video-svga \
    --disable-video-ggi \
    --disable-video-aalib \
    --enable-sdl-dlopen \
    --disable-arts \
    --disable-esd \
    --enable-pulseaudio-shared \
    --enable-alsa \
    --disable-video-ps3 \
    --disable-rpath
make %{?_smp_mflags}

%install
make install DESTDIR=%{buildroot}

# Rename SDL_config.h to SDL_config-<arch>.h to avoid file conflicts on
# multilib systems and install SDL_config.h wrapper
mv %{buildroot}/%{_includedir}/SDL/SDL_config.h %{buildroot}/%{_includedir}/SDL/SDL_config-%{_arch}.h
install -m644 %{SOURCE1} %{buildroot}/%{_includedir}/SDL/SDL_config.h

# remove libtool .la file
rm -f %{buildroot}%{_libdir}/*.la

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%doc BUGS COPYING CREDITS README-SDL.txt
%{_libdir}/lib*.so.*

%files devel
%doc README docs.html docs/html docs/index.html TODO WhatsNew
%{_bindir}/*-config
%{_libdir}/lib*.so
%{_libdir}/pkgconfig/sdl.pc
%{_includedir}/SDL
%{_datadir}/aclocal/*
%{_mandir}/man3/SDL*.3*

%files static
%{_libdir}/lib*.a

%changelog
* Mon Jul 08 2013 baseuser@ibm.com
- Base-8.x spec file
