%global cache /var/cache/man
%global gnulib_ver 20120404-stable

Summary: Tools for searching and reading man pages
Name: man-db
Version: 2.6.3
%define base_release .2
Release: 6%{?dist}%{?base_release}
# GPLv2+ .. man-db
# GPLv3+ .. gnulib
License: GPLv2+ and GPLv3+
Group: System Environment/Base
URL: http://www.nongnu.org/man-db/

Source0: http://download.savannah.gnu.org/releases/%{name}/%{name}-%{version}.tar.xz
Source1: man-db.crondaily
Source2: man-db.sysconfig

# resolves: #655385
Patch0: man-db-2.5.9-sgr.patch
# resolves: #677669
Patch1: man-db-2.6.1-wildcards.patch
# resolves: #693458
Patch2: man-db-2.6.1-so-links.patch
# resolves: #657409
Patch3: man-db-2.6.1-locale-fallback.patch
# resolves: #841431
Patch4: man-db-2.6.2-invalid-cache.patch
# adds support for man-pages-overrides
Patch5: man-db-2.6.3-overrides.patch
# fixed some compiler warnings
Patch6: man-db-2.6.3-gcc.patch
# fixed memory leaks detected by valgrind
Patch7: man-db-2.6.3-valgrind.patch
# fixed certain man pages to match options with --help and --usage
Patch8: man-db-2.6.3-man-options.patch

Obsoletes: man < 2.0
Provides: man = %{version}
Provides: man-pages-reader = %{version}
# FPC exception for gnulib - copylib - https://fedorahosted.org/fpc/ticket/174
Provides: bundled(gnulib) = %{gnulib_ver}

Requires: coreutils, grep, groff-base, gzip, less
BuildRequires: gdbm-devel, gettext, groff, less, libpipeline-devel, zlib-devel

%description
The man-db package includes five tools for browsing man-pages:
man, whatis, apropos, manpath and lexgrog. man formats and displays
manual pages. whatis searches the manual page names. apropos searches the
manual page names and descriptions. manpath determines search path
for manual pages. lexgrog directly reads header information in
manual pages.

%prep
%setup -q
%patch0 -p1 -b .sgr
%patch1 -p1 -b .wildcards
%patch2 -p1 -b .so-links
%patch3 -p1 -b .locale-fallback
%patch4 -p1 -b .invalid-cache
%patch5 -p1 -b .overrides
%patch6 -p1 -b .gcc
%patch7 -p1 -b .valgrind-mem
%patch8 -p1 -b .man-options

%build
%configure \
    --with-sections="1 1p 8 2 3 3p 4 5 6 7 9 0p n l p o 1x 2x 3x 4x 5x 6x 7x 8x" \
    --disable-setuid --with-browser=elinks --with-lzip=lzip
make CC="%{__cc} %{optflags}" %{?_smp_mflags} V=1

%check
make check

%install
make install DESTDIR=$RPM_BUILD_ROOT prefix=%{_prefix} INSTALL='install -p'

# move the documentation to the relevant place
mv $RPM_BUILD_ROOT%{_datadir}/doc/man-db/* ./

# remove zsoelim - part of groff package
rm $RPM_BUILD_ROOT%{_bindir}/zsoelim
rm $RPM_BUILD_ROOT%{_datadir}/man/man1/zsoelim.1

# remove libtool archives
rm $RPM_BUILD_ROOT%{_libdir}/man-db/*.la

# install cache directory
install -d -m 0755  $RPM_BUILD_ROOT%{cache}

# install cron script for man-db creation/update
install -D -p -m 0755 %{SOURCE1} $RPM_BUILD_ROOT/etc/cron.daily/man-db.cron

# config for cron script
install -D -p -m 0644 %{SOURCE2} $RPM_BUILD_ROOT/etc/sysconfig/man-db

%find_lang %{name}
%find_lang %{name}-gnulib

# clear the old cache
%post
%{__rm} -rf %{cache}/*

%files -f %{name}.lang -f %{name}-gnulib.lang
%doc README man-db-manual.txt man-db-manual.ps docs/COPYING ChangeLog NEWS
%config(noreplace) %{_sysconfdir}/man_db.conf
%config(noreplace) %{_sysconfdir}/sysconfig/man-db
%{_sysconfdir}/cron.daily/man-db.cron
%{_sbindir}/accessdb
%{_bindir}/man
%{_bindir}/whatis
%{_bindir}/apropos
%{_bindir}/manpath
%{_bindir}/lexgrog
%{_bindir}/catman
%{_bindir}/mandb
%dir %{_libdir}/man-db
%{_libdir}/man-db/*.so
%dir %{_libexecdir}/man-db
%{_libexecdir}/man-db/globbing
%{_libexecdir}/man-db/manconv
%attr(0755,root,root)   %dir %{cache}
# documentation and translation
%{_mandir}/man1/apropos.1*
%{_mandir}/man1/lexgrog.1*
%{_mandir}/man1/man.1*
%{_mandir}/man1/manconv.1*
%{_mandir}/man1/manpath.1*
%{_mandir}/man1/whatis.1*
%{_mandir}/man5/manpath.5*
%{_mandir}/man8/accessdb.8*
%{_mandir}/man8/catman.8*
%{_mandir}/man8/mandb.8*
%lang(es)   %{_datadir}/man/es/man*/*
%lang(it)   %{_datadir}/man/it/man*/*

%changelog
* Thu Jul 04 2013 baseuser@ibm.com
- Base-8.x spec file
