Summary: An interface to MySQL
Name: MySQL-python
Version: 1.2.3
%define base_release .2
Release: 7%{?dist}%{?base_release}
# exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
License: GPLv2+
Group: Development/Libraries
URL: http://sourceforge.net/projects/mysql-python/

Source0: http://prdownloads.sourceforge.net/mysql-python/MySQL-python-%{version}.tar.gz

Patch1: MySQL-python-no-openssl.patch

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: python-devel python-setuptools
BuildRequires: mysql-devel zlib-devel
# is this still needed?
# Requires: mx

%description
Python interface to MySQL

MySQLdb is an interface to the popular MySQL database server for Python.
The design goals are:

-     Compliance with Python database API version 2.0 
-     Thread-safety 
-     Thread-friendliness (threads will not block each other) 
-     Compatibility with MySQL 3.23 and up

This module should be mostly compatible with an older interface
written by Joe Skinner and others. However, the older version is
a) not thread-friendly, b) written for MySQL 3.21, c) apparently
not actively maintained. No code from that version is used in MySQLdb.

%prep
%setup -q -n %{name}-%{version}

%patch1 -p1

%build
rm -f doc/*~
export libdirname=%{_lib}
CFLAGS="$RPM_OPT_FLAGS" python setup.py build

%install
rm -rf $RPM_BUILD_ROOT

export libdirname=%{_lib}
python setup.py install --root=$RPM_BUILD_ROOT --record=INSTALLED_FILES

%clean
rm -rf $RPM_BUILD_ROOT

%files -f INSTALLED_FILES
%defattr(-,root,root)
%doc README doc/*
%dir %{_libdir}/python?.?/site-packages/MySQLdb
%{_libdir}/python?.?/site-packages/MySQLdb/*.pyo
%{_libdir}/python?.?/site-packages/MySQLdb/constants/*.pyo
%{_libdir}/python?.?/site-packages/*.pyo
%dir /usr/%{_lib}/python?.?/site-packages/MySQLdb/constants

%changelog
* Mon Dec 16 2013 baseuser@ibm.com
- Base-8.x spec file
