%global use_alternatives 1
%global lspp 1

# {_exec_prefix}/lib/cups is correct, even on x86_64.
# It is not used for shared objects but for executables.
# It's more of a libexec-style ({_libexecdir}) usage,
# but we use lib for compatibility with 3rd party drivers (at upstream request).
%global cups_serverbin %{_exec_prefix}/lib/cups

Summary: CUPS printing system
Name: cups
Epoch: 1
Version: 1.6.4
%define base_release .1
Release: 5%{?dist}%{?base_release}
License: GPLv2
Group: System Environment/Daemons
Url: http://www.cups.org/
Source: http://www.cups.org/software/%{version}/cups-%{version}-source.tar.bz2
# Pixmap for desktop file
Source2: cupsprinter.png
# socket unit for cups-lpd service
Source3: cups-lpd.socket
# cups-lpd service unit configuration
Source4: cups-lpd@.service
# Logrotate configuration
Source6: cups.logrotate
# Backend for NCP protocol
Source7: ncp.backend
Source8: macros.cups
Source999: fivextra.tar.bz2

Patch1: cups-no-gzip-man.patch
Patch2: cups-system-auth.patch
Patch3: cups-multilib.patch
Patch4: cups-dbus-utf8.patch
Patch5: cups-banners.patch
Patch6: cups-serverbin-compat.patch
Patch7: cups-no-export-ssllibs.patch
Patch8: cups-direct-usb.patch
Patch9: cups-lpr-help.patch
Patch10: cups-peercred.patch
Patch11: cups-pid.patch
Patch12: cups-eggcups.patch
Patch13: cups-driverd-timeout.patch
Patch14: cups-strict-ppd-line-length.patch
Patch15: cups-logrotate.patch
Patch16: cups-usb-paperout.patch
Patch17: cups-res_init.patch
Patch18: cups-filter-debug.patch
Patch19: cups-uri-compat.patch
Patch20: cups-str3382.patch
Patch21: cups-0755.patch
Patch22: cups-hp-deviceid-oid.patch
Patch23: cups-dnssd-deviceid.patch
Patch24: cups-ricoh-deviceid-oid.patch
Patch25: cups-systemd-socket.patch
Patch26: cups-lpd-manpage.patch
Patch27: cups-avahi-address.patch
Patch28: cups-usblp-quirks.patch
Patch29: cups-enum-all.patch
Patch30: cups-stringpool-setprinterattr.patch
Patch31: cups-dymo-deviceid.patch
Patch32: cups-use-ipp1.1.patch
Patch33: cups-no-gcry.patch
Patch34: cups-avahi-no-threaded.patch
Patch35: cups-gz-crc.patch
Patch36: cups-ipp-multifile.patch
Patch37: cups-full-relro.patch
Patch38: cups-web-devices-timeout.patch
Patch39: cups-final-content-type.patch
Patch40: cups-dbus-notifier.patch
Patch41: cups-usb-timeout.patch
Patch42: cups-avahi-browse.patch
Patch43: cups-str4380.patch
Patch44: cups-str4366.patch
Patch45: cups-str4332.patch
Patch46: cups-str4356.patch

Patch100: cups-lspp.patch

Requires: /sbin/chkconfig
Requires: %{name}-filesystem = %{epoch}:%{version}-%{release}
Requires: %{name}-libs%{?_isa} = %{epoch}:%{version}-%{release}
%if %use_alternatives
Provides: /usr/bin/lpq /usr/bin/lpr /usr/bin/lp /usr/bin/cancel /usr/bin/lprm /usr/bin/lpstat
Requires: /usr/sbin/alternatives
%endif

Provides: lpd lpr cupsddk cupsddk-drivers

BuildRequires: pam-devel pkgconfig
BuildRequires: openssl-devel libacl-devel
BuildRequires: openldap-devel
BuildRequires: libusb1-devel
BuildRequires: krb5-devel
BuildRequires: avahi-devel
BuildRequires: systemd, systemd-devel
BuildRequires: dbus-devel
BuildRequires: automake

# Make sure we get postscriptdriver tags.
BuildRequires: python-cups

%if %lspp
BuildRequires: libselinux-devel
BuildRequires: audit-libs-devel
%endif

Requires: dbus

# Requires working PrivateTmp (bug #807672)
Requires(pre): systemd
Requires(post): systemd
Requires(post): systemd-sysv
Requires(post): grep, sed
Requires(preun): systemd
Requires(postun): systemd

# We ship udev rules which use setfacl.
Requires: systemd
Requires: acl

# Make sure we have some filters for converting to raster format.
Requires: ghostscript-cups
Requires: cups-filters

%package devel
Summary: CUPS printing system - development environment
Group: Development/Libraries
License: LGPLv2
Requires: %{name}-libs%{?_isa} = %{epoch}:%{version}-%{release}
Requires: openssl-devel
Requires: krb5-devel
Requires: zlib-devel
Provides: cupsddk-devel

%package libs
Summary: CUPS printing system - libraries
Group: System Environment/Libraries
License: LGPLv2 and zlib

%package filesystem
Summary: CUPS printing system - directory layout
Group: System Environment/Base
BuildArch: noarch

%package lpd
Summary: CUPS printing system - lpd emulation
Group: System Environment/Daemons
Requires: %{name} = %{epoch}:%{version}-%{release}
Requires: %{name}-libs%{?_isa} = %{epoch}:%{version}-%{release}

%package ipptool
Summary: CUPS printing system - tool for performing IPP requests
Group: System Environment/Daemons
Requires: %{name}-libs%{?_isa} = %{epoch}:%{version}-%{release}

%description
CUPS printing system provides a portable printing layer for
UNIX® operating systems. It has been developed by Apple Inc.
to promote a standard printing solution for all UNIX vendors and users.
CUPS provides the System V and Berkeley command-line interfaces.

%description devel
CUPS printing system provides a portable printing layer for
UNIX® operating systems. This is the development package for creating
additional printer drivers, and other CUPS services.

%description libs
CUPS printing system provides a portable printing layer for
UNIX® operating systems. It has been developed by Apple Inc.
to promote a standard printing solution for all UNIX vendors and users.
CUPS provides the System V and Berkeley command-line interfaces.
The cups-libs package provides libraries used by applications to use CUPS
natively, without needing the lp/lpr commands.

%description filesystem
CUPS printing system provides a portable printing layer for
UNIX® operating systems. This package provides some directories which are
required by other packages that add CUPS drivers (i.e. filters, backends etc.).

%description lpd
CUPS printing system provides a portable printing layer for
UNIX® operating systems. This is the package that provides standard
lpd emulation.

%description ipptool
Sends IPP requests to the specified URI and tests and/or displays the results.

%package fivextra 
Summary: Comman Unix Printing System - test cases
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
Collection of testcase to test cups package 

%prep
%setup -q -a 999
# Don't gzip man pages in the Makefile, let rpmbuild do it.
%patch1 -p1 -b .no-gzip-man
# Use the system pam configuration.
%patch2 -p1 -b .system-auth
# Prevent multilib conflict in cups-config script.
%patch3 -p1 -b .multilib
# Ensure attributes are valid UTF-8 in dbus notifier (bug #863387).
%patch4 -p1 -b .dbus-utf8
# Ignore rpm save/new files in the banners directory.
%patch5 -p1 -b .banners
# Use compatibility fallback path for ServerBin.
%patch6 -p1 -b .serverbin-compat
# Don't export SSLLIBS to cups-config.
%patch7 -p1 -b .no-export-ssllibs
# Allow file-based usb device URIs.
%patch8 -p1 -b .direct-usb
# Add --help option to lpr.
%patch9 -p1 -b .lpr-help
# Fix compilation of peer credentials support.
%patch10 -p1 -b .peercred
# Maintain a cupsd.pid file.
%patch11 -p1 -b .pid
# Fix implementation of com.redhat.PrinterSpooler D-Bus object.
%patch12 -p1 -b .eggcups
# Increase driverd timeout to 70s to accommodate foomatic (bug #744715).
%patch13 -p1 -b .driverd-timeout
# Only enforce maximum PPD line length when in strict mode.
%patch14 -p1 -b .strict-ppd-line-length
# Re-open the log if it has been logrotated under us.
%patch15 -p1 -b .logrotate
# Support for errno==ENOSPACE-based USB paper-out reporting.
%patch16 -p1 -b .usb-paperout
# Re-initialise the resolver on failure in httpAddrGetList() (bug #567353).
%patch17 -p1 -b .res_init
# Log extra debugging information if no filters are available.
%patch18 -p1 -b .filter-debug
# Allow the usb backend to understand old-style URI formats.
%patch19 -p1 -b .uri-compat
# Fix temporary filename creation.
%patch20 -p1 -b .str3382
# Use mode 0755 for binaries and libraries where appropriate.
%patch21 -p1 -b .0755
# Add an SNMP query for HP's device ID OID (STR #3552).
%patch22 -p1 -b .hp-deviceid-oid
# Mark DNS-SD Device IDs that have been guessed at with "FZY:1;".
%patch23 -p1 -b .dnssd-deviceid
# Add an SNMP query for Ricoh's device ID OID (STR #3552).
%patch24 -p1 -b .ricoh-deviceid-oid
# Add support for systemd socket activation (patch from Lennart
# Poettering).
%patch25 -p1 -b .systemd-socket
# Talk about systemd in cups-lpd manpage (part of bug #884641).
%patch26 -p1 -b .lpd-manpage
# Use IP address when resolving DNSSD URIs (bug #948288).
%patch27 -p1 -b .avahi-address
# Added usblp quirk for Canon PIXMA MP540 (bug #967873).
%patch28 -p1 -b .usblp-quirks
# Return from cupsEnumDests() once all records have been returned.
%patch29 -p1 -b .enum-all
# Prevent stringpool damage leading to memory leaks (bug #974048).
%patch30 -p1 -b .stringpool-setprinterattr
# Added IEEE 1284 Device ID for a Dymo device (bug #747866).
%patch31 -p1 -b .dymo-deviceid
# Default to IPP/1.1 for now (bug #977813).
%patch32 -p1 -b .use-ipp1.1
# Don't link against libgcrypt needlessly.
%patch33 -p1 -b .no-gcry
# Don't use D-Bus from two threads (bug #979748).
%patch34 -p1 -b .avahi-no-threaded
# Avoid sign-extending CRCs for gz decompression (bug #983486).
%patch35 -p1 -b .gz-crc
# Fixes for jobs with multiple files and multiple formats.
%patch36 -p1 -b .ipp-multifile
# Full relro (bug #996740).
%patch37 -p1 -b .full-relro
# Increase web interface get-devices timeout to 10s (bug #996664).
%patch38 -p1 -b .web-devices-timeout
# Reverted upstream change to FINAL_CONTENT_TYPE in order to fix
# printing to remote CUPS servers (bug #1010580).
%patch39 -p1 -b .final-content-type
# Avoid stale lockfile in dbus notifier (bug #1026949).
%patch40 -p1 -b .dbus-notifier
# Prevent USB timeouts causing incorrect print output (bug #1026914).
%patch41 -p1 -b .usb-timeout
# Prevent dnssd backend exiting too early (bug #1026940, STR #4365).
%patch42 -p1 -b .avahi-browse
# Fix for cupsEnumDest() 'removed' callbacks (bug #1054312, STR #4380).
%patch43 -p1 -b .str4380
# Prevent feedback loop when fetching error_log over HTTP (STR #4366).
%patch44 -p1 -b .str4366
# Track local default in cupsEnumDests() (STR #4332).
%patch45 -p1 -b .str4332
# Scheduler now blocks URLs containing embedded HTML (bug #1087123, STR #4356)
%patch46 -p1 -b .str4356

%if %lspp
# LSPP support.
%patch100 -p1 -b .lspp
%endif

sed -i -e '1iMaxLogSize 0' conf/cupsd.conf.in

# Let's look at the compilation command lines.
perl -pi -e "s,^.SILENT:,," Makedefs.in

f=CREDITS.txt
mv "$f" "$f"~
iconv -f MACINTOSH -t UTF-8 "$f"~ > "$f"
rm -f "$f"~

aclocal -I config-scripts
autoconf -I config-scripts

%build
export CFLAGS="$RPM_OPT_FLAGS -fstack-protector-all -DLDAP_DEPRECATED=1"
# --enable-debug to avoid stripping binaries
%configure --with-docdir=%{_datadir}/%{name}/www --enable-debug \
%if %lspp
	--enable-lspp \
%endif
	--with-cupsd-file-perm=0755 \
	--with-log-file-perm=0600 \
	--enable-relro \
	--with-dbusdir=%{_sysconfdir}/dbus-1 \
	--with-php=/usr/bin/php-cgi \
	--enable-avahi \
	--enable-threads --enable-openssl \
	--enable-webif \
	--with-xinetd=no \
	localedir=%{_datadir}/locale

# If we got this far, all prerequisite libraries must be here.
make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
make BUILDROOT=$RPM_BUILD_ROOT install 

rm -rf	$RPM_BUILD_ROOT%{_initddir} \
	$RPM_BUILD_ROOT%{_sysconfdir}/init.d \
	$RPM_BUILD_ROOT%{_sysconfdir}/rc?.d
mkdir -p $RPM_BUILD_ROOT%{_unitdir}

find $RPM_BUILD_ROOT%{_datadir}/cups/model -name "*.ppd" |xargs gzip -n9f

%if %use_alternatives
pushd $RPM_BUILD_ROOT%{_bindir}
for i in cancel lp lpq lpr lprm lpstat; do
	mv $i $i.cups
done
cd $RPM_BUILD_ROOT%{_sbindir}
mv lpc lpc.cups
cd $RPM_BUILD_ROOT%{_mandir}/man1
for i in cancel lp lpq lpr lprm lpstat; do
	mv $i.1 $i-cups.1
done
cd $RPM_BUILD_ROOT%{_mandir}/man8
mv lpc.8 lpc-cups.8
popd
%endif

mkdir -p $RPM_BUILD_ROOT%{_datadir}/pixmaps $RPM_BUILD_ROOT%{_sysconfdir}/X11/sysconfig $RPM_BUILD_ROOT%{_sysconfdir}/X11/applnk/System $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d
install -p -m 644 %{SOURCE2} $RPM_BUILD_ROOT%{_datadir}/pixmaps
install -p -m 644 %{SOURCE3} %{buildroot}%{_unitdir}
install -p -m 644 %{SOURCE4} %{buildroot}%{_unitdir}
install -p -m 644 %{SOURCE6} $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/cups
install -p -m 755 %{SOURCE7} $RPM_BUILD_ROOT%{cups_serverbin}/backend/ncp

# Ship an rpm macro for where to put driver executables.
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/rpm/
install -m 0644 %{SOURCE8} $RPM_BUILD_ROOT%{_sysconfdir}/rpm/

# Ship a printers.conf file, and a client.conf file.  That way, they get
# their SELinux file contexts set correctly.
touch $RPM_BUILD_ROOT%{_sysconfdir}/cups/printers.conf
touch $RPM_BUILD_ROOT%{_sysconfdir}/cups/classes.conf
touch $RPM_BUILD_ROOT%{_sysconfdir}/cups/client.conf
touch $RPM_BUILD_ROOT%{_sysconfdir}/cups/subscriptions.conf
touch $RPM_BUILD_ROOT%{_sysconfdir}/cups/lpoptions

# LSB 3.2 printer driver directory
mkdir -p $RPM_BUILD_ROOT%{_datadir}/ppd

# Remove unshipped files.
rm -rf $RPM_BUILD_ROOT%{_mandir}/cat? $RPM_BUILD_ROOT%{_mandir}/*/cat?
rm -f $RPM_BUILD_ROOT%{_datadir}/applications/cups.desktop
rm -rf $RPM_BUILD_ROOT%{_datadir}/icons
# there are pdf-banners shipped with cups-filters (#919489)
rm -rf $RPM_BUILD_ROOT%{_datadir}/cups/banners
rm -f $RPM_BUILD_ROOT%{_datadir}/cups/data/testprint

# install /usr/lib/tmpfiles.d/cups.conf (bug #656566, bug #893834)
mkdir -p ${RPM_BUILD_ROOT}%{_tmpfilesdir}
cat > ${RPM_BUILD_ROOT}%{_tmpfilesdir}/cups.conf <<EOF
# See tmpfiles.d(5) for details

d /run/cups 0755 root lp -
d /run/cups/certs 0511 lp sys -

d /var/spool/cups/tmp - - - 30d
EOF

# /usr/lib/tmpfiles.d/cups-lp.conf (bug #812641)
cat > ${RPM_BUILD_ROOT}%{_tmpfilesdir}/cups-lp.conf <<EOF
# Legacy parallel port character device nodes, to trigger the
# auto-loading of the kernel module on access.
#
# See tmpfiles.d(5) for details

c /dev/lp0 0660 root lp - 6:0
c /dev/lp1 0660 root lp - 6:1
c /dev/lp2 0660 root lp - 6:2
c /dev/lp3 0660 root lp - 6:3
EOF

find $RPM_BUILD_ROOT -type f -o -type l | sed '
s:.*\('%{_datadir}'/\)\([^/_]\+\)\(.*\.po$\):%lang(\2) \1\2\3:
/^%lang(C)/d
/^\([^%].*\)/d
' > %{name}.lang

mkdir -p $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests
cp -a test/*.test test/test* test/*.html test/*.sh $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/
mkdir -p $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/testfiles/data
cp -a data/* $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/testfiles/data/
mkdir -p $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/testfiles/notifier
install -c -m 755 notifier/testnotify $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/testfiles/notifier/
mkdir -p $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/testfiles/ppdc
install -c -m 755 ppdc/sample.drv $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/testfiles/ppdc/

# Steps to package the cups tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%post
%systemd_post %{name}.path %{name}.socket %{name}.service

# Remove old-style certs directory; new-style is /var/run
# (see bug #194581 for why this is necessary).
/bin/rm -rf %{_sysconfdir}/cups/certs
%if %use_alternatives
/usr/sbin/alternatives --install %{_bindir}/lpr print %{_bindir}/lpr.cups 40 \
	 --slave %{_bindir}/lp print-lp %{_bindir}/lp.cups \
	 --slave %{_bindir}/lpq print-lpq %{_bindir}/lpq.cups \
	 --slave %{_bindir}/lprm print-lprm %{_bindir}/lprm.cups \
	 --slave %{_bindir}/lpstat print-lpstat %{_bindir}/lpstat.cups \
	 --slave %{_bindir}/cancel print-cancel %{_bindir}/cancel.cups \
	 --slave %{_sbindir}/lpc print-lpc %{_sbindir}/lpc.cups \
	 --slave %{_mandir}/man1/cancel.1.gz print-cancelman %{_mandir}/man1/cancel-cups.1.gz \
	 --slave %{_mandir}/man1/lp.1.gz print-lpman %{_mandir}/man1/lp-cups.1.gz \
	 --slave %{_mandir}/man8/lpc.8.gz print-lpcman %{_mandir}/man8/lpc-cups.8.gz \
	 --slave %{_mandir}/man1/lpq.1.gz print-lpqman %{_mandir}/man1/lpq-cups.1.gz \
	 --slave %{_mandir}/man1/lpr.1.gz print-lprman %{_mandir}/man1/lpr-cups.1.gz \
	 --slave %{_mandir}/man1/lprm.1.gz print-lprmman %{_mandir}/man1/lprm-cups.1.gz \
	 --slave %{_mandir}/man1/lpstat.1.gz print-lpstatman %{_mandir}/man1/lpstat-cups.1.gz
%endif
rm -f %{_localstatedir}/cache/cups/*.ipp %{_localstatedir}/cache/cups/*.cache

# Deal with config migration due to CVE-2012-5519 (STR #4223)
IN=%{_sysconfdir}/cups/cupsd.conf
OUT=%{_sysconfdir}/cups/cups-files.conf
copiedany=no
for keyword in AccessLog CacheDir ConfigFilePerm	\
    DataDir DocumentRoot ErrorLog FatalErrors		\
    FileDevice FontPath Group LogFilePerm		\
    LPDConfigFile PageLog Printcap PrintcapFormat	\
    RemoteRoot RequestRoot ServerBin ServerCertificate	\
    ServerKey ServerRoot SMBConfigFile StateDir		\
    SystemGroup SystemGroupAuthKey TempDir User; do
    if ! [ -f "$IN" ] || ! /bin/grep -iq ^$keyword "$IN"; then continue; fi
    copy=yes
    if /bin/grep -iq ^$keyword "$OUT"; then
	if [ "`/bin/grep -i ^$keyword "$IN"`" ==	\
	     "`/bin/grep -i ^$keyword "$OUT"`" ]; then
	    copy=no
	else
	    /bin/sed -i -e "s,^$keyword,#$keyword,i" "$OUT" || :
	fi
    fi
    if [ "$copy" == "yes" ]; then
	if [ "$copiedany" == "no" ]; then
	    (cat >> "$OUT" <<EOF

# Settings automatically moved from cupsd.conf by RPM package:
EOF
	    ) || :
	fi

	(/bin/grep -i ^$keyword "$IN" >> "$OUT") || :
	copiedany=yes
    fi

    /bin/sed -i -e "s,^$keyword,#$keyword,i" "$IN" || :
done

exit 0

%post lpd
%systemd_post cups-lpd.socket
exit 0

%post libs -p /sbin/ldconfig

%postun libs -p /sbin/ldconfig

%preun
%systemd_preun %{name}.path %{name}.socket %{name}.service

%if %use_alternatives
if [ $1 -eq 0 ] ; then
	/usr/sbin/alternatives --remove print %{_bindir}/lpr.cups
fi
%endif

exit 0

%preun lpd
%systemd_preun cups-lpd.socket
exit 0

%postun
%systemd_postun_with_restart %{name}.service
exit 0

%postun lpd
%systemd_postun_with_restart cups-lpd.socket
exit 0

%triggerun -- %{name} < 1:1.5.0-22
# This package is allowed to autostart; however, the upgrade trigger
# in Fedora 16 final failed to actually do this.  Do it now as a
# one-off fix for bug #748841.
/bin/systemctl --no-reload enable %{name}.{service,socket,path} >/dev/null 2>&1 || :

%triggerun -- %{name} < 1:1.5-0.9
# Save the current service runlevel info
# User must manually run systemd-sysv-convert --apply cups
# to migrate them to systemd targets
%{_bindir}/systemd-sysv-convert --save %{name} >/dev/null 2>&1 || :

# This package is allowed to autostart:
/bin/systemctl --no-reload enable %{name}.{service,socket,path} >/dev/null 2>&1 || :

# Run these because the SysV package being removed won't do them
/sbin/chkconfig --del cups >/dev/null 2>&1 || :
/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :

%triggerin -- samba-client
ln -sf ../../../bin/smbspool %{cups_serverbin}/backend/smb || :
exit 0

%triggerun -- samba-client
[ $2 = 0 ] || exit 0
rm -f %{cups_serverbin}/backend/smb

%triggerin -- samba4-client
ln -sf %{_bindir}/smbspool %{cups_serverbin}/backend/smb || :
exit 0

%triggerun -- samba4-client
[ $2 = 0 ] || exit 0
rm -f %{cups_serverbin}/backend/smb

%files -f %{name}.lang
%doc README.txt CREDITS.txt CHANGES.txt
%dir %attr(0755,root,lp) %{_sysconfdir}/cups
%dir %attr(0755,root,lp) %{_localstatedir}/run/cups
%dir %attr(0511,lp,sys) %{_localstatedir}/run/cups/certs
%{_tmpfilesdir}/cups.conf
%{_tmpfilesdir}/cups-lp.conf
%verify(not md5 size mtime) %config(noreplace) %attr(0640,root,lp) %{_sysconfdir}/cups/cupsd.conf
%verify(not md5 size mtime) %config(noreplace) %attr(0640,root,lp) %{_sysconfdir}/cups/cups-files.conf
%attr(0640,root,lp) %{_sysconfdir}/cups/cupsd.conf.default
%verify(not md5 size mtime) %config(noreplace) %attr(0644,root,lp) %{_sysconfdir}/cups/client.conf
%verify(not md5 size mtime) %config(noreplace) %attr(0600,root,lp) %{_sysconfdir}/cups/classes.conf
%verify(not md5 size mtime) %config(noreplace) %attr(0600,root,lp) %{_sysconfdir}/cups/printers.conf
%verify(not md5 size mtime) %config(noreplace) %attr(0644,root,lp) %{_sysconfdir}/cups/snmp.conf
%verify(not md5 size mtime) %config(noreplace) %attr(0644,root,lp) %{_sysconfdir}/cups/subscriptions.conf
%{_sysconfdir}/cups/interfaces
%verify(not md5 size mtime) %config(noreplace) %attr(0644,root,lp) %{_sysconfdir}/cups/lpoptions
%dir %attr(0755,root,lp) %{_sysconfdir}/cups/ppd
%dir %attr(0700,root,lp) %{_sysconfdir}/cups/ssl
%config(noreplace) %{_sysconfdir}/pam.d/cups
%config(noreplace) %{_sysconfdir}/logrotate.d/cups
%dir %{_datadir}/%{name}/www
%dir %{_datadir}/%{name}/www/ca
%dir %{_datadir}/%{name}/www/cs
%dir %{_datadir}/%{name}/www/es
%dir %{_datadir}/%{name}/www/fr
%dir %{_datadir}/%{name}/www/ja
%dir %{_datadir}/%{name}/www/ru
%{_datadir}/%{name}/www/images
%{_datadir}/%{name}/www/*.css
%doc %{_datadir}/%{name}/www/index.html
%doc %{_datadir}/%{name}/www/help
%doc %{_datadir}/%{name}/www/robots.txt
%doc %{_datadir}/%{name}/www/ca/index.html
%doc %{_datadir}/%{name}/www/cs/index.html
%doc %{_datadir}/%{name}/www/es/index.html
%doc %{_datadir}/%{name}/www/fr/index.html
%doc %{_datadir}/%{name}/www/ja/index.html
%doc %{_datadir}/%{name}/www/ru/index.html
%{_unitdir}/%{name}.service
%{_unitdir}/%{name}.socket
%{_unitdir}/%{name}.path
%{_bindir}/cupstestppd
%{_bindir}/cupstestdsc
%{_bindir}/cancel*
%{_bindir}/lp*
%{_bindir}/ppd*
%{cups_serverbin}/backend/*
%{cups_serverbin}/cgi-bin
%dir %{cups_serverbin}/daemon
%{cups_serverbin}/daemon/cups-deviced
%{cups_serverbin}/daemon/cups-driverd
%{cups_serverbin}/daemon/cups-exec
%{cups_serverbin}/notifier
%{cups_serverbin}/filter/*
%{cups_serverbin}/monitor
%{_mandir}/man[1578]/*
# devel subpackage
%exclude %{_mandir}/man1/cups-config.1.gz
# ipptool subpackage
%exclude %{_mandir}/man1/ipptool.1.gz
%exclude %{_mandir}/man5/ipptoolfile.5.gz
# lpd subpackage
%exclude %{_mandir}/man8/cups-lpd.8.gz
%{_sbindir}/*
%dir %{_datadir}/cups/templates
%dir %{_datadir}/cups/templates/ca
%dir %{_datadir}/cups/templates/cs
%dir %{_datadir}/cups/templates/es
%dir %{_datadir}/cups/templates/fr
%dir %{_datadir}/cups/templates/ja
%dir %{_datadir}/cups/templates/ru
%dir %{_datadir}/cups/usb
%{_datadir}/cups/templates/*.tmpl
%{_datadir}/cups/templates/ca/*.tmpl
%{_datadir}/cups/templates/cs/*.tmpl
%{_datadir}/cups/templates/es/*.tmpl
%{_datadir}/cups/templates/fr/*.tmpl
%{_datadir}/cups/templates/ja/*.tmpl
%{_datadir}/cups/templates/ru/*.tmpl
%{_datadir}/cups/usb/org.cups.usb-quirks
%dir %attr(1770,root,lp) %{_localstatedir}/spool/cups/tmp
%dir %attr(0710,root,lp) %{_localstatedir}/spool/cups
%dir %attr(0755,lp,sys) %{_localstatedir}/log/cups
%{_datadir}/pixmaps/cupsprinter.png
%config(noreplace) %{_sysconfdir}/dbus-1/system.d/cups.conf
%{_datadir}/cups/drv/sample.drv
%{_datadir}/cups/examples
%{_datadir}/cups/mime/mime.types
%{_datadir}/cups/mime/mime.convs
%{_datadir}/cups/ppdc/*.defs
%{_datadir}/cups/ppdc/*.h

%files libs
%doc LICENSE.txt
%{_libdir}/*.so.*

%files filesystem
%dir %{cups_serverbin}
%dir %{cups_serverbin}/backend
%dir %{cups_serverbin}/driver
%dir %{cups_serverbin}/filter
%dir %{_datadir}/cups
#%%dir %%{_datadir}/cups/banners
#%%dir %%{_datadir}/cups/charsets
%dir %{_datadir}/cups/data
%dir %{_datadir}/cups/drv
%dir %{_datadir}/cups/mime
%dir %{_datadir}/cups/model
%dir %{_datadir}/cups/ppdc
%dir %{_datadir}/ppd

%files devel
%{_bindir}/cups-config
%{_libdir}/*.so
%{_includedir}/cups
%{_mandir}/man1/cups-config.1.gz
%{_sysconfdir}/rpm/macros.cups

%files lpd
%{_unitdir}/cups-lpd.socket
%{_unitdir}/cups-lpd@.service
%{cups_serverbin}/daemon/cups-lpd
%{_mandir}/man8/cups-lpd.8.gz

%files ipptool
%{_bindir}/ipptool
%dir %{_datadir}/cups/ipptool
%{_datadir}/cups/ipptool/*
%{_mandir}/man1/ipptool.1.gz
%{_mandir}/man5/ipptoolfile.5.gz

%files fivextra
%{prefix}

%changelog
* Tue Jun 17 2014 baseuser@ibm.com
- Base-f19.x spec file
