Name:	ppc64-diag
Version:	2.6.6
%define base_release .9
%define build_tag ppc64-diag-2_6_6-17_3_pkvm2_1_0
Release:	1%{?dist}%{?base_release}
Summary: 	PowerLinux Platform Diagnostics
Group: 		System Environment/Base
License: 	Eclipse Public License (EPL) v1.0
Packager: 	IBM Corp. 
Vendor: 	IBM Corp.
ExclusiveArch:  ppc ppc64
BuildRequires:  libservicelog-devel, flex, perl, /usr/bin/yacc
BuildRequires:  libvpd-devel
BuildRequires:  librtas-devel >= 1.3.9
BuildRequires:	ncurses-devel

Requires: 	servicelog, /sbin/chkconfig
# PCI hotplug support on PowerKVM guest depends on below
# powerpc-utils version.
Requires:	powerpc-utils >= 1.2.19
# Light Path Diagnostics depends on below lsvpd version.
Requires:	lsvpd >= 1.7.1
BuildRoot:	%{_tmppath}/%{name}-%{version}-build
Source0: 	ppc64-diag-2.6.6-pkvm2_1.tar.gz

# for building from git
BuildRequires:  git
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  gettext-devel

%description
This package contains various diagnostic tools for PowerLinux.
These tools captures the diagnostic events from Power Systems
platform firmware, SES enclosures and device drivers, and
write events to servicelog database. It also provides automated
responses to urgent events such as environmental conditions and
predictive failures, if appropriate modifies the FRUs fault
indicator(s) and provides event notification to system
administrators or connected service frameworks.

%prep
git clone git://9.42.66.204/littleb/ppc64-diag.git ./
git checkout %{?build_tag}
git log --pretty=oneline |head -n10

%build
make

%install
make install DESTDIR=$RPM_BUILD_ROOT
chmod 644 $RPM_BUILD_ROOT/etc/ppc64-diag/servevent_parse.pl
mkdir -p $RPM_BUILD_ROOT/etc/ppc64-diag/ses_pages
mkdir -p $RPM_BUILD_ROOT/var/log/dump
mkdir -p $RPM_BUILD_ROOT/var/log/opal-elog
ln -sfv /usr/sbin/usysattn $RPM_BUILD_ROOT/usr/sbin/usysfault

%files
%defattr (-,root,root,-)
%doc /usr/share/doc/packages/ppc64-diag/COPYRIGHT
%doc /usr/share/man/man8/*
/usr/sbin/*
%dir /etc/ppc64-diag
%dir /etc/ppc64-diag/ses_pages
%dir /var/log/dump
%dir /var/log/opal-elog
%config /etc/ppc64-diag/*
%config /etc/rc.powerfail
%config %attr(755,root,root) /etc/init.d/rtas_errd
%config %attr(755,root,root) /etc/init.d/opal_errd
%config %attr(744,root,root) /etc/ppc64-diag/prrn_hotplug

%post
# Post-install script --------------------------------------------------
# We will install both opal_errd and rtas_errd daemon and during boottime
# daemon will fail gracefully if its not relevant to the running platform
/etc/ppc64-diag/ppc64_diag_setup --register >/dev/null 2>&1
/etc/ppc64-diag/lp_diag_setup --register >/dev/null 2>&1
if [ "$1" = "1" ]; then # first install
    /sbin/chkconfig --add rtas_errd
    /sbin/chkconfig --add opal_errd
    /etc/init.d/opal_errd start >/dev/null || /etc/init.d/rtas_errd start >/dev/null
elif [ "$1" = "2" ]; then # upgrade
    /etc/init.d/rtas_errd restart >/dev/null || /etc/init.d/opal_errd restart >/dev/null
fi

%preun
# Pre-uninstall script -------------------------------------------------
if [ "$1" = "0" ]; then # last uninstall
    /etc/init.d/opal_errd stop >/dev/null || /etc/init.d/rtas_errd stop >/dev/null
    /sbin/chkconfig --del opal_errd
    /sbin/chkconfig --del rtas_errd
    /etc/ppc64-diag/ppc64_diag_setup --unregister >/dev/null
    /etc/ppc64-diag/lp_diag_setup --unregister >/dev/null
fi

%triggerin -- librtas
# trigger on librtas upgrades ------------------------------------------
if [ "$2" = "2" ]; then
    /etc/init.d/opal_errd restart >/dev/null || /etc/init.d/rtas_errd restart >/dev/null
fi

%changelog
* Wed Apr 16 2014 baseuser@ibm.com
- Base-f19.x spec file
