Name:       fbterm
Version:    1.7
%define base_release .1
Release:    2%{?dist}%{?base_release}
License:    GPLv2+
Group:      Applications/System
URL:        http://code.google.com/p/fbterm/
Source0:    http://fbterm.googlecode.com/files/%{name}-%{version}.tar.gz

#Patch0:    %{name}-1.2-kernel-header.patch
#Patch1:    %{name}-1.3-setcap.patch
#Patch2:    %{name}-1.4-iminput.patch
#Patch3:    %{name}-1.6-rpmpack.patch
#Patch4:    %{name}-1.6-el5.patch

Summary:    A frame-buffer terminal emulator
Summary(zh_CN): 运行在帧缓冲的快速终端仿真器
Summary(zh_TW): 運行在frame-buffer的快速終端模擬機

%define fbterm_rules_name 99-fbterm.rules
%define fbterm_rules_dir %{_sysconfdir}/udev/rules.d
%define fbterm_rules_path %{fbterm_rules_dir}/%{fbterm_rules_name}

BuildRoot:  %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires: autoconf, automake
BuildRequires: fontconfig-devel gpm-devel
Requires: fontconfig

%description
FbTerm is a fast terminal emulator for Linux with frame-buffer device. 
Features include: 
- mostly as fast as terminal of Linux kernel while accelerated scrolling
  is enabled on frame-buffer device 
- select font with fontconfig and draw text with freetype2, same as 
  Qt/Gtk+ based GUI apps 
- dynamically create/destroy up to 10 windows initially running default
  shell 
- record scroll back history for every window 
- auto-detect text encoding with current locale, support double width 
  scripts like  Chinese, Japanese etc 
- switch between configurable additional text encodings with hot keys
  on the fly 
- copy/past selected text between windows with mouse when gpm server 
  is running


%if 0%{?fedora} >= 9
%package udevrules
Group:      Applications/System
Summary:    udev rules that grant regular user access
Requires:   udev

%description udevrules
Regular users might use some applications that require access to frame-buffer device.
For example, ibus-fbterm requires access to /dev/fb0.
This sub-package enables regular user for such access.
%endif

%prep

%setup -q
#%patch0 -p0 -b .kernel-header
#%patch1 -p0 -b .setcap
#%patch2 -p0 -b .iminput
#%patch3 -p0 -b .rpmpack
#%if 0%{?fedora} >= 9
#%else
#%patch4 -p0 -b .el5
#%endif

%build
autoreconf -iv
%configure --disable-static --disable-rpath
make %{?_smp_mflags}

%install
%__rm -rf %{buildroot}
%__make DESTDIR=%{buildroot} install
%__chmod 755 %{buildroot}/%{_bindir}/%{name}
%if 0%{?fedora} >= 9
%__mkdir -p %{buildroot}/%{fbterm_rules_dir}
%__cat >>%{buildroot}/%{fbterm_rules_path} <<EOF
KERNEL=="fb[0-9]*", SUBSYSTEM=="graphics", MODE="0666"
EOF
%endif

%clean
rm -rf %{buildroot}

%if 0%{?fedora} >= 9
%post
setcap 'cap_sys_tty_config+ep' %{_bindir}/%{name}
%endif

%files 
%defattr(-,root,root,-)
%doc AUTHORS ChangeLog COPYING README
%if 0%{?fedora} >= 9
%{_bindir}/%{name}
%else
%attr(4755,root,root) %{_bindir}/%{name}
%endif
%{_mandir}/man1/%{name}.1.gz

%if 0%{?fedora} >= 9
%files udevrules
%defattr(-,root,root,-)
%config(noreplace) %{fbterm_rules_path}
%endif


%changelog
* Thu May 29 2014 baseuser@ibm.com
- Base-f19.x spec file
