Summary: Utilities for managing the JFS filesystem
Name: jfsutils
Version: 1.1.13
%define base_release .2
Release: 10%{?dist}%{?base_release}
Source0: http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.gz
Patch1: include_stdint.patch
URL: http://jfs.sourceforge.net/
Group: System Environment/Base
License: GPLv2+
Buildroot: %(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)
Buildrequires: libuuid-devel

%description
The jfsutils package contains a number of utilities for creating,
checking, modifying, and correcting any inconsistencies in JFS
filesystems.  The following utilities are available: fsck.jfs - initiate
replay of the JFS transaction log, and check and repair a JFS formatted
device; logdump - dump a JFS formatted device's journal log; logredo -
"replay" a JFS formatted device's journal log;  mkfs.jfs - create a JFS
formatted partition; xchkdmp - dump the contents of a JFS fsck log file
created with xchklog; xchklog - extract a log from the JFS fsck workspace
into a file;  xpeek - shell-type JFS file system editor.


%prep
%setup -q
%patch1 -p0
find . -type f -name *.[ch] -exec chmod -x {} \;

%build
%configure --sbindir=/sbin
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
/sbin/*
%{_mandir}/man8/*
%doc AUTHORS COPYING NEWS ChangeLog

%changelog
* Tue Aug 13 2013 baseuser@ibm.com
- Base-8.x spec file
