# if 0%{?fedora} > 15 || 0%{?rhel} > 6
# global with_python3 1
# else
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print (get_python_lib())")}
# endif

%global modname simplegeneric

Name:           python-simplegeneric
Version:        0.8
%define base_release .2
Release:        6%{?dist}%{?base_release}
Summary:        Simple generic functions (similar to Python's own len(), pickle.dump(), etc.)

Group:          Development/Languages
License:        Python or ZPLv2.1
URL:            http://cheeseshop.python.org/pypi/simplegeneric
Source0:        http://pypi.python.org/packages/source/s/%{modname}/%{modname}-%{version}.zip
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildArch:      noarch
BuildRequires:  python-devel
BuildRequires:  python-setuptools
%if 0%{?with_python3}
BuildRequires:  python3-devel
BuildRequires:  python3-setuptools
BuildRequires:  /usr/bin/2to3
%endif

%description
The simplegeneric module lets you define simple single-dispatch generic
functions, akin to Python's built-in generic functions like len(), iter() and
so on. However, instead of using specially-named methods, these generic
functions use simple lookup tables, akin to those used by e.g. pickle.dump()
and other generic functions found in the Python standard library.


%if 0%{?with_python3}
%package -n python3-%{modname}
Summary:        Simple generic functions (similar to Python's own len(), pickle.dump(), etc.)

Group:          Development/Languages
License:        Python or ZPLv2.1

%description -n python3-%{modname}
The simplegeneric module lets you define simple single-dispatch generic
functions, akin to Python's built-in generic functions like len(), iter() and
so on. However, instead of using specially-named methods, these generic
functions use simple lookup tables, akin to those used by e.g. pickle.dump()
and other generic functions found in the Python standard library.
%endif # with_python3


%prep
%setup -q -n %{modname}-%{version}

%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
pushd %{py3dir}
    2to3 --write --nobackups .
    sed -i "s/file(/open(/g" setup.py
popd
find %{py3dir} -name '*.py' | xargs sed -i '1s|^#!python|#!%{__python3}|'
%endif # with_python3

find -name '*.py' | xargs sed -i '1s|^#!python|#!%{__python}|'


%build
%{__python} setup.py build

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif # with_python3


%install
rm -rf %{buildroot}
%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install --skip-build --root %{buildroot}
popd
%endif # with_python3

%{__python} setup.py install --skip-build --root %{buildroot}

%check
%if 0%{?with_python3}
pushd %{py3dir}
PYTHONPATH=$(pwd) %{__python3} setup.py test
popd
%endif # with_python3

PYTHONPATH=$(pwd) %{__python} setup.py test

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root,-)
%doc README.txt
%{python_sitelib}/simplegeneric.py*
%{python_sitelib}/simplegeneric-%{version}-py?.?.egg-info

%if 0%{?with_python3}
%files -n python3-%{modname}
%defattr(-,root,root,-)
%doc README.txt
%{python3_sitelib}/__pycache__/simplegeneric.cpython*
%{python3_sitelib}/simplegeneric.py*
%{python3_sitelib}/simplegeneric-%{version}-py?.?.egg-info
%endif # with_python3

%changelog
* Tue Dec 17 2013 baseuser@ibm.com
- Base-8.x spec file
