%if 0%{?fedora} <= 18
%global        vendortag 1
%endif

Summary:       Hardware lister
Name:          lshw
Version:       B.02.17
%define base_release .3
Release:       2%{?dist}%{?base_release}
License:       GPLv2
Group:         Applications/System
URL:           http://ezix.org/project/wiki/HardwareLiSter
Source0:       http://www.ezix.org/software/files/lshw-%{version}.tar.gz
Source1:       lshw.desktop
Source2:       org.ezix.lshw.gui.policy
Source3:       lshw-gui
Patch0:        lshw-B.02.17-scan-fat-mem-bug.patch
Patch109577:   bug-109577-wrong-dev-type.patch
Patch1078851:  bug107885-restrict.memory.access.patch
Patch1078852:  bug107885-detect.powernv.systems.patch
Patch1078853:  bug107885-display.memory.cards.patch
Patch1078854:  bug107885-use.vendor.field.in.dt.patch
Patch1078855:  bug107885-scan.other.devices.patch
Patch1078856:  bug107885-add.location.code.patch
Patch1078857:  bug107885-add.part.number.patch
Patch1078858:  bug107885-add.memory.attributes.patch




BuildRequires: sqlite-devel
Requires:      hwdata

%description
lshw is a small tool to provide detailed informaton on the hardware
configuration of the machine. It can report exact memory configuration,
firmware version, mainboard configuration, CPU version and speed, cache
configuration, bus speed, etc. on DMI-capable x86 systems and on some
PowerPC machines (PowerMac G4 is known to work).

Information can be output in plain text, XML or HTML.

%package       gui
Summary:       Graphical hardware lister
Group:         Applications/System
Requires:      polkit
Requires:      %{name} = %{version}-%{release}
BuildRequires: gtk2-devel >= 2.4
BuildRequires: desktop-file-utils

%description   gui
Graphical frontend for the hardware lister (lshw) tool.
If desired, hardware information can be saved to file in
plain, XML or HTML format.

%prep
%setup -q
%patch0 -p0
%patch109577 -p0
%patch1078851 -p1
%patch1078852 -p1
%patch1078853 -p1
%patch1078854 -p1
%patch1078855 -p1
%patch1078856 -p1
%patch1078857 -p1
%patch1078858 -p1

%build
%{__make} %{?_smp_mflags} SBINDIR="%{_sbindir}" RPM_OPT_FLAGS="%{optflags}" SQLITE=1 gui 

# Replace copyrighted icons
pushd src
%{__make} nologo

%install
%{__make} install              \
        DESTDIR="%{buildroot}" \
        PREFIX="%{_prefix}"    \
        SBINDIR="%{_sbindir}"  \
        MANDIR="%{_mandir}"    \
        SQLITE=1               \
        STRIP="/bin/true"      \
        INSTALL="%{__install} -p"

%{__make} install-gui          \
        DESTDIR="%{buildroot}" \
        PREFIX="%{_prefix}"    \
        SBINDIR="%{_sbindir}"  \
        MANDIR="%{_mandir}"    \
        SQLITE=1               \
        STRIP="/bin/true"      \
        INSTALL="%{__install} -p"

%{__ln_s} -f gtk-lshw %{buildroot}%{_sbindir}/lshw-gui

# don't package these copies, use the ones from hwdata instead
%{__rm} -f %{buildroot}%{_datadir}/%{name}/pci.ids
%{__rm} -f %{buildroot}%{_datadir}/%{name}/usb.ids
# don't package these copies, they're not actually used by the app,
# and even if they were, should use the hwdata versions
%{__rm} -f %{buildroot}%{_datadir}/%{name}/oui.txt
%{__rm} -f %{buildroot}%{_datadir}/%{name}/manuf.txt

# desktop icon
%{__install} -D -m 0644 -p ./src/gui/artwork/logo.svg \
     %{buildroot}%{_datadir}/pixmaps/%{name}-logo.svg
desktop-file-install %{?vendortag:--vendor fedora} \
  --dir %{buildroot}%{_datadir}/applications %{SOURCE1}

# PolicyKit
%{__install} -D -m 0644 %{SOURCE2} \
    %{buildroot}%{_datadir}/polkit-1/actions/org.ezix.lshw.gui.policy
%{__install} -D -m 0755 %{SOURCE3} %{buildroot}%{_bindir}/lshw-gui

# translations seems borken, remove for now
#find_lang %{name}
rm -rf %{buildroot}%{_datadir}/locale/fr/

#files -f %{name}.lang
%files
%doc COPYING README docs/*
%doc %{_mandir}/man1/lshw.1*
%{_sbindir}/%{name}

%files gui
%doc COPYING
%{_bindir}/%{name}-gui
%{_sbindir}/gtk-%{name}
%{_sbindir}/%{name}-gui
%{_datadir}/%{name}
%{_datadir}/pixmaps/%{name}-logo.svg
%{_datadir}/applications/*%{name}.desktop
%{_datadir}/polkit-1/actions/org.ezix.lshw.gui.policy

%changelog
* Wed Jan 22 2014 baseuser@ibm.com
- Base-f19.x spec file
