%global fontname lato
%global fontconf 61-%{fontname}.conf

Name:           %{fontname}-fonts
Version:        1.105
%define base_release .1
Release:        1%{?dist}%{?base_release}
Summary:        A sanserif typeface family

Group:          User Interface/X
License:        OFL
URL:            http://www.latofonts.com/
# Fonts retrieved 2013-06-06 from http://www.latofonts.com/download/LatoOFL.zip
Source0:        %{name}-%{version}.zip
Source1:        %{name}-fontconfig.conf

BuildArch:      noarch
BuildRequires:  fontpackages-devel
Requires:       fontpackages-filesystem
Provides:       google-lato-fonts = %{version}-%{release}
Obsoletes:      google-lato-fonts < 1.014-1

%description
Lato is a sanserif typeface family designed in the Summer 2010 by Warsaw-based
designer Łukasz Dziedzic ("Lato" means "Summer" in Polish). In December 2010 the
Lato family was published under the open-source Open Font License by his foundry
tyPoland, with support from Google.

When working on Lato, Łukasz tried to carefully balance some potentially
conflicting priorities. He wanted to create a typeface that would seem quite
"transparent" when used in body text but would display some original treats when
used in larger sizes. He used classical proportions (particularly visible in the
uppercase) to give the letterforms familiar harmony and elegance. At the same
time, he created a sleek sanserif look, which makes evident the fact that Lato
was designed in 2010 - even though it does not follow any current trend.

The semi-rounded details of the letters give Lato a feeling of warmth, while the
strong structure provides stability and seriousness. "Male and female, serious
but friendly. With the feeling of the Summer," says Łukasz.

Lato consists of five weights (plus corresponding italics), including a
beautiful hairline style.


%prep
%setup -q -c

# Fix wrong end-of-lines encoding
sed "s/\r//" OFL.txt > OFL.txt.new
touch -r OFL.txt OFL.txt.new
mv OFL.txt.new OFL.txt


%build


%install
install -m 0755 -d $RPM_BUILD_ROOT%{_fontdir}
install -m 0644 -p OTF/*.otf $RPM_BUILD_ROOT%{_fontdir}

install -m 0755 -d $RPM_BUILD_ROOT%{_fontconfig_templatedir} $RPM_BUILD_ROOT%{_fontconfig_confdir}

install -m 0644 -p %{SOURCE1} $RPM_BUILD_ROOT%{_fontconfig_templatedir}/%{fontconf}
ln -s %{_fontconfig_templatedir}/%{fontconf} $RPM_BUILD_ROOT%{_fontconfig_confdir}/%{fontconf}


%_font_pkg -f %{fontconf} *.otf
%doc OFL.txt README.txt


%changelog
* Wed May 28 2014 baseuser@ibm.com
- Base-f19.x spec file
