Summary: Shared MIME information database
Name: shared-mime-info
Version: 1.1
%define base_release .3
Release: 4%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
License: GPLv2+
Group: System Environment/Base
URL: http://freedesktop.org/Software/shared-mime-info
Source0: http://people.freedesktop.org/~hadess/%{name}-%{version}.tar.xz
Source1: defaults.list
# Generated with:
# for i in `cat /home/hadess/Projects/jhbuild/totem/data/mime-type-list.txt | grep -v real | grep -v ^#` ; do if grep MimeType /home/hadess/Projects/jhbuild/rhythmbox/data/rhythmbox.desktop.in.in | grep -q "$i;" ; then echo "$i=rhythmbox.desktop;totem.desktop;" >> totem-defaults.list ; else echo "$i=totem.desktop;" >> totem-defaults.list ; fi ; done ; for i in `cat /home/hadess/Projects/jhbuild/totem/data/uri-schemes-list.txt | grep -v ^#` ; do echo "x-scheme-handler/$i=totem.desktop;" >> totem-defaults.list ; done
Source2: totem-defaults.list
# Generated with:
# for i in `grep MimeType= /usr/share/applications/file-roller.desktop | sed 's/MimeType=//' | sed 's/;/ /g'` application/x-source-rpm ; do if ! `grep -q $i defaults.list` ; then echo $i=file-roller.desktop\; >> file-roller-defaults.list ; fi ; done
Source3: file-roller-defaults.list
# Generated with:
# for i in `grep MimeType= /usr/share/applications/shotwell-viewer.desktop | sed 's/MimeType=//' | sed 's/;/ /g'` ; do echo $i=shotwell-viewer.desktop\; >> shotwell-viewer-defaults.list ; done
Source4: shotwell-viewer-defaults.list
Source999: fivextra.tar.bz2

# Work-around for https://bugs.freedesktop.org/show_bug.cgi?id=40354
Patch0: 0001-Remove-sub-classing-from-OO.o-mime-types.patch

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires:  libxml2-devel
BuildRequires:  glib2-devel
BuildRequires:  gettext
# For intltool:
BuildRequires: perl(XML::Parser) intltool
Requires: pkgconfig

Requires(post): glib2

%description
This is the freedesktop.org shared MIME info database.

Many programs and desktops use the MIME system to represent the types of
files. Frequently, it is necessary to work out the correct MIME type for
a file. This is generally done by examining the file's name or contents,
and looking up the correct MIME type in a database.

%prep
%setup -q -n %{name}-%{version} -a 999
%patch0 -p1 -b .ooo-zip

%build

%configure
# make %{?_smp_mflags}
make

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp
Requires: desktop-file-utils

%description fivextra
This package contains testcases for %{name}

%install
make install DESTDIR=$RPM_BUILD_ROOT

find $RPM_BUILD_ROOT%{_datadir}/mime -type d \
| sed -e "s|^$RPM_BUILD_ROOT|%%dir |" > %{name}.files
find $RPM_BUILD_ROOT%{_datadir}/mime -type f -not -path "*/packages/*" \
| sed -e "s|^$RPM_BUILD_ROOT|%%ghost |" >> %{name}.files

mkdir -p $RPM_BUILD_ROOT/%{_datadir}/applications
install -m 644 %SOURCE1 $RPM_BUILD_ROOT/%{_datadir}/applications/defaults.list
cat %SOURCE2 >> $RPM_BUILD_ROOT/%{_datadir}/applications/defaults.list
cat %SOURCE3 >> $RPM_BUILD_ROOT/%{_datadir}/applications/defaults.list
cat %SOURCE4 >> $RPM_BUILD_ROOT/%{_datadir}/applications/defaults.list

for dir in `cd fivextra; find . -type d -not -name CVS`
do
        install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
        install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

## remove bogus translation files
## translations are already in the xml file installed
rm -rf $RPM_BUILD_ROOT%{_datadir}/locale/*

%if 0%{?fedora} < 17
# f17+ mozilla-firefox.desktop renamed to firefox.desktop (#736558)
# defaults.list fixed, handle this exceptional case separately, if at all
%endif


%post
# Should fail, as it would mean a problem in the mime database
%{_bindir}/update-mime-database %{_datadir}/mime &> /dev/null

%files -f %{name}.files
%defattr(-,root,root,-)
%doc README NEWS HACKING COPYING shared-mime-info-spec.xml
%{_bindir}/*
%{_datadir}/mime/packages/*
%{_datadir}/applications/defaults.list
%{_datadir}/pkgconfig/*
%{_mandir}/man*/*

%files fivextra
%{prefix}
 
%changelog
* Wed Jun 05 2013 baseuser@ibm.com
- Base-8.x spec file
