# if 0%{?fedora}
# global _with_python3 1
# else
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print (get_python_lib())")}
# endif

Name:           python-requests
Version:        1.2.3
%define base_release .2
Release:        5%{?dist}%{?base_release}
Summary:        HTTP library, written in Python, for human beings

License:        ASL 2.0
URL:            http://pypi.python.org/pypi/requests
Source0:        http://pypi.python.org/packages/source/r/requests/requests-%{version}.tar.gz
# Explicitly use the system certificates in ca-certificates.
# https://bugzilla.redhat.com/show_bug.cgi?id=904614
Patch0:         python-requests-system-cert-bundle.patch
# Unbundle python-charade (a fork of python-chardet).
# https://bugzilla.redhat.com/show_bug.cgi?id=904623
Patch1:         python-requests-system-chardet-not-charade.patch
# Unbundle python-charade (a fork of python-urllib3).
# https://bugzilla.redhat.com/show_bug.cgi?id=904623
Patch2:         python-requests-system-urllib3.patch

BuildArch:      noarch
BuildRequires:  python2-devel
BuildRequires:  python-chardet
BuildRequires:  python-urllib3

Requires:       ca-certificates
Requires:       python-chardet
Requires:       python-urllib3 >= 1.7

%if 0%{?fedora} && 0%{?fedora} <= 18
BuildRequires:  python-ordereddict
Requires:       python-ordereddict
%endif

%description
Most existing Python modules for sending HTTP requests are extremely verbose and 
cumbersome. Python’s built-in urllib2 module provides most of the HTTP 
capabilities you should need, but the API is thoroughly broken. This library is 
designed to make HTTP requests easy for developers.

%if 0%{?_with_python3}
%package -n python3-requests
Summary: HTTP library, written in Python, for human beings
BuildRequires:  python3-devel
BuildRequires:  python3-chardet
BuildRequires:  python3-urllib3
Requires:       python3-chardet
Requires:       python3-urllib3 >= 1.7

%description -n python3-requests
Most existing Python modules for sending HTTP requests are extremely verbose and
cumbersome. Python’s built-in urllib2 module provides most of the HTTP
capabilities you should need, but the API is thoroughly broken. This library is
designed to make HTTP requests easy for developers.
%endif

%prep
%setup -q -n requests-%{version}

%patch0 -p1
%patch1 -p1
%patch2 -p1

# Unbundle the certificate bundle from mozilla.
rm -rf requests/cacert.pem

%if 0%{?_with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
%endif # with_python3

%build
%if 0%{?_with_python3}
pushd %{py3dir}
%{__python3} setup.py build

# Unbundle chardet.  Patch1 switches usage to system chardet.
rm -rf build/lib/requests/packages/charade

# Unbundle urllib3.  Patch1 switches usage to system urllib3.
rm -rf build/lib/requests/packages

popd
%endif

%{__python} setup.py build

# Unbundle chardet.  Patch1 switches usage to system chardet.
rm -rf build/lib/requests/packages/charade

# Unbundle urllib3.  Patch1 switches usage to system urllib3.
rm -rf build/lib/requests/packages

%install
rm -rf $RPM_BUILD_ROOT
%if 0%{?_with_python3}
pushd %{py3dir}
%{__python3} setup.py install --skip-build --root $RPM_BUILD_ROOT
popd
%endif

%{__python} setup.py install --skip-build --root $RPM_BUILD_ROOT

## The tests succeed if run locally, but fail in koji.
## They require an active network connection to query httpbin.org
#%%check
#%%{__python} test_requests.py
#%%if 0%%{?_with_python3}
#pushd %%{py3dir}
#%%{__python3} test_requests.py
#popd
#%%endif

%files
%defattr(-,root,root,-)
%doc NOTICE LICENSE README.rst HISTORY.rst
%{python_sitelib}/*.egg-info
%dir %{python_sitelib}/requests
%{python_sitelib}/requests/*

%if 0%{?_with_python3}
%files -n python3-requests
%{python3_sitelib}/*.egg-info
%{python3_sitelib}/requests/
%endif

%changelog
* Mon Dec 16 2013 baseuser@ibm.com
- Base-8.x spec file
