%global fontname     sil-abyssinica
%global archive_name AbyssinicaSIL
%global fontconf     66-%{fontname}.conf


Name:           %{fontname}-fonts
Version:        1.200
%define base_release .1
Release:        5%{?dist}%{?base_release}
Summary:        SIL Abyssinica fonts

License:        OFL
URL:            http://scripts.sil.org/AbyssinicaSIL
# download from http://scripts.sil.org/cms/scripts/render_download.php?site_id=nrsi&format=file&media_id=AbyssinicaSIL1.200.zip&filename=AbyssinicaSIL1.200.zip
Source0:        %{archive_name}%{version}.zip
Source1:        %{fontconf}

BuildArch:      noarch

Requires:       fontpackages-filesystem
BuildRequires:  fontpackages-devel
BuildRequires:  dos2unix


%description
SIL Abyssinica is a Unicode typeface family containing glyphs for the
Ethiopic script.

The Ethiopic script is used for writing many of the languages of Ethiopia and
Eritrea. Abyssinica SIL supports all Ethiopic characters which are in Unicode
including the Unicode 4.1 extensions. Some languages of Ethiopia are not yet
able to be fully represented in Unicode and, where necessary, we have included
non-Unicode characters in the Private Use Area (see Private-use (PUA)
characters supported by Abyssinica SIL).

Abyssinica SIL is based on Ethiopic calligraphic traditions. This release is
a regular typeface, with no bold or italic version available or planned.


%prep
%setup -q -n %{archive_name}-%{version}


%build
dos2unix FONTLOG.txt OFL.txt OFL-FAQ.txt README.txt documentation/DOCUMENTATION.txt


%install
#fonts
install -d -m 0755 %{buildroot}%{_fontdir}
install -m 0644 *.ttf %{buildroot}%{_fontdir}

#fontconfig
install -d -m 0755 %{buildroot}%{_fontconfig_templatedir} \
                   %{buildroot}%{_fontconfig_confdir}
install -m 0644 -p %{SOURCE1} %{buildroot}%{_fontconfig_templatedir}/%{fontconf}
ln -s %{_fontconfig_templatedir}/%{fontconf} \
      %{buildroot}%{_fontconfig_confdir}/%{fontconf}


%_font_pkg -f %{fontconf} *.ttf

%doc FONTLOG.txt OFL.txt OFL-FAQ.txt README.txt
%doc documentation/*


%changelog
* Thu May 29 2014 baseuser@ibm.com
- Base-f19.x spec file
