%if ! 0%{?base}
%global with_python3 1
%endif

%global modname dogpile.cache

Name:               python-dogpile-cache
Version:            0.5.0
%define base_release .1
Release:            1%{?dist}%{?base_release}
Summary:            A caching front-end based on the Dogpile lock

Group:              Development/Libraries
License:            BSD
URL:                http://pypi.python.org/pypi/dogpile.cache
Source0:            http://pypi.python.org/packages/source/d/%{modname}/%{modname}-%{version}.tar.gz

BuildArch:          noarch

BuildRequires:      python2-devel
BuildRequires:      python-setuptools
BuildRequires:      python-nose
BuildRequires:      python-mock
BuildRequires:      python-dogpile-core >= 0.4.1

%if 0%{?with_python3}
BuildRequires:      python3-devel
BuildRequires:      python3-setuptools
BuildRequires:      python3-nose
BuildRequires:      python3-mock
BuildRequires:      python3-dogpile-core >= 0.4.1
%endif

Requires:      python-dogpile-core >= 0.4.1

%description
A caching API built around the concept of a "dogpile lock", which allows
continued access to an expiring data value while a single thread generates
a new value.

dogpile.cache builds on the `dogpile.core
<http://pypi.python.org/pypi/dogpile.core>`_ locking system, which
implements the idea of "allow one creator to write while others read" in
the abstract.   Overall, dogpile.cache is intended as a replacement to the
`Beaker <http://beaker.groovie.org>`_ caching system, the internals of
which are written by the same author.   All the ideas of Beaker which
"work" are re-implemented in dogpile.cache in a more efficient and succinct
manner, and all the cruft (Beaker's internals were first written in 2005)
relegated to the trash heap.

%if 0%{?with_python3}
%package -n python3-dogpile-cache
Summary:            A caching front-end based on the Dogpile lock.
Group:              Development/Libraries

Requires:      python3-dogpile-core >= 0.4.1

%description -n python3-dogpile-cache
A caching API built around the concept of a "dogpile lock", which allows
continued access to an expiring data value while a single thread generates
a new value.

dogpile.cache builds on the `dogpile.core
<http://pypi.python.org/pypi/dogpile.core>`_ locking system, which
implements the idea of "allow one creator to write while others read" in
the abstract.   Overall, dogpile.cache is intended as a replacement to the
`Beaker <http://beaker.groovie.org>`_ caching system, the internals of
which are written by the same author.   All the ideas of Beaker which
"work" are re-implemented in dogpile.cache in a more efficient and succinct
manner, and all the cruft (Beaker's internals were first written in 2005)
relegated to the trash heap.
%endif

%prep
%setup -q -n %{modname}-%{version}

# Remove bundled egg-info in case it exists
rm -rf %{modname}.egg-info
%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
%endif

%build
%{__python} setup.py build
%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif

%install
%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install -O1 --skip-build --root=%{buildroot}
popd
%endif
%{__python} setup.py install -O1 --skip-build --root=%{buildroot}

%files
%doc README.rst LICENSE
%{python_sitelib}/dogpile/cache/
%{python_sitelib}/%{modname}-%{version}*

%if 0%{?with_python3}
%files -n python3-dogpile-cache
%doc README.rst LICENSE
%{python3_sitelib}/dogpile/cache/
%{python3_sitelib}/%{modname}-%{version}-*
%endif

%changelog
* Tue Feb 11 2014 baseuser@ibm.com
- Base-f19.x spec file
