Summary: Utility for modifying/upgrading files
Name: patch
Version: 2.7.1
%define base_release .4
Release: 6%{?dist}%{?base_release}
License: GPLv3+
URL: http://www.gnu.org/software/patch/patch.html
Group: Development/Tools
Source: ftp://ftp.gnu.org/gnu/patch/patch-%{version}.tar.xz
Source999: fivextra.tar.bz2
Patch1: patch-remove-empty-dir.patch
Patch2: patch-args.patch
Patch3: patch-args-segfault.patch
Patch100: patch-selinux.patch
Patch83227: bug-83227-break-backups.patch

Buildroot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires: libselinux-devel
BuildRequires: libattr-devel
# LTC: doesn't have ed
%{!?fedora:BuildRequires: ed}

%description
The patch program applies diff files to originals.  The diff command
is used to compare an original to a changed file.  Diff lists the
changes made to the file.  A person who has the original file can then
use the patch command with the diff file to add the changes to their
original file (patching the file).

Patch should be installed because it is a common way of upgrading
applications.

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -a 999

# Upstream patch to fix removal of empty directories (bug #919489).
%patch1 -p1 -b .remove-empty-dir

# Don't document unsupported -m option; document -x option (bug #948972).
%patch2 -p1 -b .args

# Don't segfault when given bad arguments (bug #972330).
%patch3 -p1 -b .args-segfault

# SELinux support.
%patch100 -p1 -b .selinux

# LTC disable patch -b backups
%patch83227 -p1 -b .fools

# LTC: during cross, do not let localcharset get LIBDIR from configmake.h. This
# var includes BUILDROOT, and since we dont relocate for cross, we just want
# _libdir. If we don't make this substitution, the build will embed BUILDROOT into
# localecharset.o -> patch.a -> patch which fails the post install check-buildroot.
%{?cross_build:sed -i '/relocate.*LIBDIR/ s,LIBDIR,"%{_libdir}",g' lib/localcharset.c}

%build
CFLAGS="$RPM_OPT_FLAGS -D_GNU_SOURCE"
%ifarch sparcv9
CFLAGS=`echo $CFLAGS|sed -e 's|-fstack-protector||g'`
%endif
%configure --disable-silent-rules
make %{?_smp_mflags}

pushd fivextra
make all
popd

%check
# LTC broke -b, don't do this
#make check

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall

# Steps to package the patch tests for FIV
for dir in `cd fivextra; find . -type d`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print`  $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done 
find $RPM_BUILD_ROOT/%{fivdir}/%{name} -depth -name CVS -type d -exec rm -rf {} \;

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%doc COPYING NEWS README
%{_bindir}/*
%{_mandir}/*/*

%files fivextra
%{prefix}

%changelog
* Wed Aug 07 2013 baseuser@ibm.com
- Base-8.x spec file
