Name:          ceph
Version:       0.56.4
%define base_release .2
Release:       1%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: %{cross_arches}
Summary:       User space components of the Ceph file system
License:       LGPLv2
Group:         System Environment/Base
URL:           http://ceph.com/

Source:        http://ceph.com/download/%{name}-%{version}.tar.bz2
Patch0:        ceph-init-fix.patch
Patch1:        ceph-build-support-for-automake-1.12.patch
Patch2:        0001-silence-logrotate-some-more.patch

BuildRequires: fuse-devel, libtool, libtool-ltdl-devel, boost-devel, 
BuildRequires: libedit-devel, fuse-devel, git, perl, gdbm, libaio-devel,
# google-perftools is not available on these:
%ifnarch ppc ppc64 s390 s390x
BuildRequires: gperftools-devel
%endif
BuildRequires: cryptopp-devel, libatomic_ops-static, gcc-c++
BuildRequires: pkgconfig, libcurl-devel, keyutils-libs-devel
BuildRequires: gtkmm24-devel, gtk2-devel, libuuid, libuuid-devel
BuildRequires: leveldb-devel, snappy-devel

Requires(post): chkconfig, binutils, libedit
Requires(preun): chkconfig
Requires(preun): initscripts

%description
Ceph is a distributed network file system designed to provide excellent
performance, reliability, and scalability.

%package libs
Summary:       Ceph libraries
Group:         System Environment/Libraries
%description libs
Common libraries for Ceph distributed network file system

%package libcephfs
Summary:       Ceph libcephfs libraries
Group:         System Environment/Libraries
%description libcephfs
libcephfs library for Ceph distributed network file system

%package       fuse
Summary:       Ceph fuse-based client
Group:         System Environment/Base
Requires:      %{name} = %{version}-%{release}
BuildRequires: fuse-devel
%description   fuse
FUSE based client for Ceph distributed network file system

%package     devel
Summary:     Ceph headers
Group:       Development/Libraries
License:     LGPLv2
Requires:    %{name} = %{version}-%{release}
Requires:    %{name}-libs = %{version}-%{release}
Requires:    %{name}-libcephfs = %{version}-%{release}
%description devel
This package contains the headers needed to develop programs that use Ceph.

%package radosgw
Summary:        rados REST gateway
Group:          Development/Libraries
Requires:       mod_fcgid
BuildRequires:  fcgi-devel
BuildRequires:  expat-devel

%description radosgw
radosgw is an S3 HTTP REST gateway for the RADOS object store. It is
implemented as a FastCGI module using libfcgi, and can be used in
conjunction with any FastCGI capable web server.

%prep
%setup -q
%patch0 -p1 -b .init
%patch1 -p1
%patch2 -p1

%build
./autogen.sh

%ifarch armv5tel
# libatomic_ops does not have correct asm for ARMv5tel
EXTRA_CFLAGS="-DAO_USE_PTHREAD_DEFS"
%endif
%ifarch %{arm}
# libatomic_ops seems to fallback on some pthread implementation on ARM
EXTRA_LDFLAGS="-lpthread"
%endif

%{configure} --prefix=/usr --sbindir=%{_sbindir} \
--localstatedir=/var --sysconfdir=/etc \
%ifarch ppc ppc64 s390 s390x
--without-tcmalloc \
%endif
--with-system-leveldb --without-hadoop --with-radosgw --with-gtk2 \
CFLAGS="$RPM_OPT_FLAGS $EXTRA_CFLAGS" \
CXXFLAGS="$RPM_OPT_FLAGS $EXTRA_CFLAGS -fvisibility-inlines-hidden" \
LDFLAGS="$EXTRA_LDFLAGS"

make %{?_smp_mflags}

%install
make install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name "*.la" -exec rm -f {} ';'
find $RPM_BUILD_ROOT -type f -name "*.a" -exec rm -f {} ';'
install -D src/init-ceph $RPM_BUILD_ROOT%{_initrddir}/ceph
chmod 0644 $RPM_BUILD_ROOT%{_docdir}/ceph/sample.ceph.conf
install -m 0644 -D src/logrotate.conf $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/ceph
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/lib/ceph/tmp/
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/log/ceph/
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/log/ceph/stat
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/ceph
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/bash_completion.d

%post
/sbin/chkconfig --add ceph

%preun
if [ $1 = 0 ] ; then
    /sbin/service ceph stop >/dev/null 2>&1
    /sbin/chkconfig --del ceph
fi

%postun
if [ "$1" -ge "1" ] ; then
    /sbin/service ceph condrestart >/dev/null 2>&1 || :
fi

%post libs -p /sbin/ldconfig
%postun libs -p /sbin/ldconfig
%post libcephfs -p /sbin/ldconfig
%postun libcephfs -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc README COPYING
%dir %{_sysconfdir}/ceph
%{_bindir}/ceph
%{_bindir}/cephfs
%{_bindir}/ceph-conf
%{_bindir}/ceph-clsinfo
%{_bindir}/crushtool
%{_bindir}/monmaptool
%{_bindir}/osdmaptool
%{_bindir}/ceph-authtool
%{_bindir}/ceph-syn
%{_bindir}/ceph-run
%{_bindir}/ceph-mon
%{_bindir}/ceph-mds
%{_bindir}/ceph-osd
%{_bindir}/ceph-rbdnamer
%{_bindir}/librados-config
%{_bindir}/rados
%{_bindir}/rbd
%{_bindir}/ceph-debugpack
%{_bindir}/ceph-coverage
%{_bindir}/ceph-dencoder
%{_initrddir}/ceph
%{_sbindir}/mkcephfs
%{_sbindir}/mount.ceph
%{_sbindir}/ceph-disk-activate
%{_sbindir}/ceph-disk-prepare
%{_sbindir}/ceph-create-keys
%{_libdir}/ceph
%{_docdir}/ceph/sample.ceph.conf
%{_docdir}/ceph/sample.fetch_config
%config(noreplace) %{_sysconfdir}/logrotate.d/ceph
%config(noreplace) %{_sysconfdir}/bash_completion.d/rados
%config(noreplace) %{_sysconfdir}/bash_completion.d/ceph
%config(noreplace) %{_sysconfdir}/bash_completion.d/rbd
%{_mandir}/man8/ceph-mon.8*
%{_mandir}/man8/ceph-mds.8*
%{_mandir}/man8/ceph-osd.8*
%{_mandir}/man8/mkcephfs.8*
%{_mandir}/man8/ceph-run.8*
%{_mandir}/man8/ceph-syn.8*
%{_mandir}/man8/crushtool.8*
%{_mandir}/man8/osdmaptool.8*
%{_mandir}/man8/monmaptool.8*
%{_mandir}/man8/ceph-conf.8*
%{_mandir}/man8/ceph.8*
%{_mandir}/man8/cephfs.8*
%{_mandir}/man8/mount.ceph.8*
%{_mandir}/man8/radosgw.8*
%{_mandir}/man8/radosgw-admin.8*
%{_mandir}/man8/rados.8*
%{_mandir}/man8/rbd.8*
%{_mandir}/man8/ceph-authtool.8*
%{_mandir}/man8/ceph-debugpack.8*
%{_mandir}/man8/ceph-clsinfo.8*
%{_mandir}/man8/ceph-dencoder.8*
%{_mandir}/man8/ceph-rbdnamer.8*
%{python_sitelib}/rados.py*
%{python_sitelib}/rbd.py*
%dir %{_localstatedir}/lib/ceph/
%dir %{_localstatedir}/lib/ceph/tmp/
%dir %{_localstatedir}/log/ceph/

%files libs
%defattr(-,root,root,-)
%doc COPYING
%{_libdir}/librados.so.*
%{_libdir}/librbd.so.*
%{_libdir}/rados-classes/libcls_rbd.so.*
%{_libdir}/rados-classes/libcls_rgw.so*
%{_libdir}/rados-classes/libcls_lock*
%{_libdir}/rados-classes/libcls_kvs*
%{_libdir}/rados-classes/libcls_refcount*

%files libcephfs
%defattr(-,root,root,-)
%doc COPYING
%{_libdir}/libcephfs.so.*

%files fuse
%defattr(-,root,root,-)
%doc COPYING
%{_bindir}/ceph-fuse
%{_sbindir}/mount.fuse.ceph
%{_mandir}/man8/ceph-fuse.8*

%files devel
%defattr(-,root,root,-)
%doc COPYING
%{_includedir}/cephfs/libcephfs.h
#%{_includedir}/crush/crush.h
#%{_includedir}/crush/hash.h
#%{_includedir}/crush/mapper.h
#%{_includedir}/crush/types.h
%{_includedir}/rados/librados.h
%{_includedir}/rados/librados.hpp
%{_includedir}/rados/buffer.h
%{_includedir}/rados/page.h
%{_includedir}/rados/crc32c.h
#%{_includedir}/rados/librgw.h
%{_includedir}/rbd/librbd.h
%{_includedir}/rbd/librbd.hpp
%{_includedir}/rbd/features.h
%{_libdir}/libcephfs.so
%{_libdir}/librados.so
#%{_libdir}/librgw.so
%{_libdir}/librbd.so*
%{_libdir}/rados-classes/libcls_rbd.so
%{_mandir}/man8/librados-config.8*


%files radosgw
%defattr(-,root,root,-)
%{_bindir}/radosgw
%{_bindir}/radosgw-admin
%{_sysconfdir}/bash_completion.d/radosgw-admin

%changelog
* Fri Jul 12 2013 baseuser@ibm.com
- Base-8.x spec file
