Summary: XML libraries for python
Name: PyXML
Version: 0.8.4
%define base_release .2
Release: 29%{?dist}%{?base_release}
# MCP: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Source: http://prdownloads.sourceforge.net/pyxml/PyXML-%{version}.tar.gz
#Source999: fivextra.tar.bz2
Patch0: PyXML-0.7.1-intern.patch
Patch1: PyXML-0.8.4-cvs20041111-python2.4-backport.patch
Patch2: PyXML-memmove.patch
Patch3: PyXML-0.8.4-python2.6.patch

License: MIT and Python and ZPLv1.0 and BSD
Group: Development/Libraries
Requires: python
URL: http://pyxml.sourceforge.net/
BuildRequires: python python-devel expat-devel dos2unix
BuildRoot: %{_tmppath}/%{name}-%{version}-buildroot

# Must have setuptools to build the package
# The build portions moved to a subpackage in F-8
%if 0%{?fedora} >= 8
BuildRequires: python-setuptools-devel
%else
BuildRequires: python-setuptools
%endif

# Must have setuptools to build the package
# The build portions moved to a subpackage in F-8
%if 0%{?fedora} >= 8 || 0%{?base}
BuildRequires: python-setuptools-devel
%else
BuildRequires: python-setuptools
%endif

%description
An XML package for Python.  The distribution contains a
validating XML parser, an implementation of the SAX and DOM
programming interfaces and an interface to the Expat parser.

#%package fivextra
#Summary: FIV Tests for %{name}
#Group: fivextra
#Prefix: /opt/fiv/ltp
#
#%description fivextra
#This package contains the testcases built from the package for %{name}.

%prep
#%setup -n %{name}-%{version} -a 999
%setup -n %{name}-%{version}

%patch0 -p1 -b .intern
%patch1 -p1 -b .python2.4-backport
%patch2 -p1
%patch3 -p1


# iconv to use utf8
for file in CREDITS ANNOUNCE doc/xml-howto.txt doc/xml-ref.txt README; do
  iconv -f iso8859-1 -t utf-8 -o tmp $file
  mv tmp $file
done

# use Unix style EOL
dos2unix doc/xmlproc/standard.css

%build
# build PyXML with system expat
# Make sure we don't use local one
rm -rf extensions/expat
CFLAGS="$RPM_OPT_FLAGS -fno-strict-aliasing" %{__python} -c 'import setuptools; execfile("setup.py")' build  --with-xslt --with-libexpat=%{_usr}

#pushd fivextra
#make all
#popd

%install
rm -fr $RPM_BUILD_ROOT
python -c 'import setuptools; execfile("setup.py")' install --skip-build --root=$RPM_BUILD_ROOT --with-xslt

# set executable bits
for file in xslt/_4xslt.py dom/ext/c14n.py dom/html/GenerateHtml.py; do
  chmod +x $RPM_BUILD_ROOT/%{_libdir}/python?.?/site-packages/_xmlplus/$file
done

# move messages files
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/locale
for file in dom/de dom/en_US dom/fr; do
  mv $RPM_BUILD_ROOT/%{_libdir}/python?.?/site-packages/_xmlplus/$file \
    $RPM_BUILD_ROOT/%{_datadir}/locale
done

%find_lang 4Suite %{name}

# better to use symlink to python's pyexpat library
# Resolves 614911
pushd $RPM_BUILD_ROOT/%{python_sitearch}/_xmlplus/parsers
rm -rf pyexpat.so
ln -s %{_libdir}/python?.?/lib-dynload/pyexpat.so pyexpat.so
popd

# FIV Changes
#mkdir -p $RPM_BUILD_ROOT/%{fivdir}/%{name}
#cp -a test $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests
#chmod +x $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests/{regrtest.py,test_c14n.py}
#for dir in `cd fivextra; find . -type d -not -name CVS`
#do
#  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
#  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
#done 
#
#install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
#pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
#make install
#popd

%clean
rm -rf $RPM_BUILD_ROOT

%check
#cd test
# Need to remove unittest.py. Since python 2.7 there is need
# for SkipTest funcionality
#rm -rf unittest.py 
#PYTHONPATH=.. python regrtest.py -v

%files -f %{name}
%defattr(-,root,root,-)
%doc LICENCE ANNOUNCE CREDITS README README.dom README.pyexpat README.sgmlop TODO doc/*

%{_bindir}/xmlproc_parse
%{_bindir}/xmlproc_val
%{python_sitearch}/*egg-info
%{python_sitearch}/_xmlplus

#%files fivextra
#%{prefix}

%changelog
* Fri Jul 12 2013 baseuser@ibm.com
- Base-8.x spec file
