Name: grubby
Version: 8.26
%define base_release .2
Release: 2%{?dist}%{?base_release}
Summary: Command line tool for updating bootloader configs
Group: System Environment/Base
License: GPLv2+
URL: http://git.fedorahosted.org/git/grubby.git
# we only pull git snaps at the moment
# git clone git://git.fedorahosted.org/git/grubby.git
# git archive --format=tar --prefix=grubby-%{version}/ HEAD |bzip2 > grubby-%{version}.tar.bz2
Source0: %{name}-%{version}.tar.bz2
Source999: fivextra.tar.bz2
Patch0:  0001-update-extlinux.conf-on-arm-arches-if-it-exists.patch
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: pkgconfig glib2-devel popt-devel 
BuildRequires: libblkid-devel git
# for make test / getopt:
BuildRequires: util-linux-ng
%ifarch s390 s390x
Requires: s390utils-base
%endif
%ifarch %{arm}
Requires: uboot-tools
%endif

%description
grubby  is  a command line tool for updating and displaying information about 
the configuration files for the grub, lilo, elilo (ia64),  yaboot (powerpc)  
and zipl (s390) boot loaders. It is primarily designed to be used from scripts
which install new kernels and need to find information about the current boot 
environment.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -a 999

git init
git config user.email "noone@example.com"
git config user.name "no one"
git add .
git commit -a -q -m "%{version} baseline"
git am %{patches} </dev/null

# Base remove .git fool
rm -rf .git

%build
make CC=%{__cc} %{?_smp_mflags}

%check
make test

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT mandir=%{_mandir}
%ifarch %{arm}
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/
install -p uboot $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/uboot
mkdir -p $RPM_BUILD_ROOT/boot
echo " " >> $RPM_BUILD_ROOT/boot/boot.scr
%endif

for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install test.sh $RPM_BUILD_ROOT%{fivdir}/%{name}
for dir in $(find test -type d )
do
  install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/$dir
  install  $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT%{fivdir}/%{name}/$dir || true
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root,-)
%doc COPYING
/sbin/installkernel
/sbin/new-kernel-pkg
/sbin/grubby
%{_mandir}/man8/*.8*
%ifarch %{arm}
%config(noreplace) %{_sysconfdir}/sysconfig/uboot
%config(noreplace) /boot/boot.scr
%endif

%files fivextra
%{prefix}

%changelog
* Wed Jul 03 2013 baseuser@ibm.com
- Base-8.x spec file
