
## to bootstrap and avoid the circular dependency with ghostscript
## define this to be the ghostscript version
#define gs_bootstrap 9.06

Summary: Encoding files 
Name:    poppler-data
Version: 0.4.6
%define base_release .2
Release: 2%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
# The cMap data files installed by the poppler-data package are
# under the COPYING.adobe license
# cidToUnicode, nameToUnicode and unicodeMap data files
# are under the COPYING.gpl2 license
License: BSD and GPLv2
Group:   Development/Libraries
URL:     http://poppler.freedesktop.org/
Source0: http://poppler.freedesktop.org/poppler-data-%{version}.tar.gz
Source1: http://downloads.sourceforge.net/project/cmap.adobe/cmapresources_identity0.tar.z
# extracted from ghostscript-9.05 tarball
Source2: Identity-UTF16-H
BuildRoot: %(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)
BuildArch: noarch

%if ! 0%{?gs_bootstrap:1}
BuildRequires: ghostscript
%endif
%global gs_ver %(gs --version 2>/dev/null || echo %{gs_bootstrap})

%description
This package consists of encoding files for poppler.  When installed,
the encoding files enables poppler to correctly render CJK and Cyrillic 
properly.


%prep
%setup -q -a 1

%build
# intentionally left blank

%install
rm -rf $RPM_BUILD_ROOT
make install  DESTDIR=$RPM_BUILD_ROOT datadir=%{_datadir}

# manually install Identity-* files
# http://bugzilla.redhat.com/842351
install -m644 -p %{SOURCE2} ai0/CMap/Identity-* $RPM_BUILD_ROOT%{_datadir}/poppler/cMap/

# create cmap symlinks for ghostscript
mkdir -p %{buildroot}%{_datadir}/ghostscript/%{gs_ver}/Resource/CMap/
cmap_files=$(find %{buildroot}%{_datadir}/poppler/cMap/ -type f | sed -e "s|%{buildroot}%{_datadir}|../../../..|g")
pushd %{buildroot}%{_datadir}/ghostscript/%{gs_ver}/Resource/CMap/
for target in ${cmap_files} ; do
ln -s $target
test -f $(basename $target)
done
popd


%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root,-)
%doc COPYING COPYING.adobe COPYING.gpl2 README
%{_datadir}/poppler/
%dir %{_datadir}/ghostscript/%{gs_ver}
%dir %{_datadir}/ghostscript/%{gs_ver}/Resource
%{_datadir}/ghostscript/%{gs_ver}/Resource/CMap/


%changelog
* Wed Jun 05 2013 baseuser@ibm.com
- Base-8.x spec file
