%global fontname sil-mingzat
%global fontconf 65-%{fontname}.conf
%global archivename Mingzat

Name:    %{fontname}-fonts
Version: 0.020
%define base_release .1
Release: 2%{?dist}%{?base_release}
Summary: A font for Lepcha script
Group:   User Interface/X
License: OFL
URL:     http://scripts.sil.org/Mingzat
# The source link is a redirect and is not directly accessible
Source0: %{archivename}-%{version}.zip
Source1: %{name}-fontconfig.conf
BuildArch: noarch
BuildRequires: fontpackages-devel
Requires:      fontpackages-filesystem

%description
Mingzat is based on Jason Glavy's JG Lepcha font which was a custom-encoded
font. The goal for this product was to provide a single Unicode-based font
that would contain all Lepcha characters. In addition, there is provision for
other Latin characters and symbols. This font makes use of state-of-the-art
font technologies (Graphite and OpenType) to support the need for conjuncts
and to position arbitrary combinations of Lepcha glyphs and combining marks
optimally. 

%prep
%setup -q -n '%{archivename}'
for F in *.txt; do
   sed -i 's/\r//' "$F"
done

%build
# Nothing there

%install
install -m 0755 -d %{buildroot}%{_fontdir}
install -m 0644 -p *.ttf %{buildroot}%{_fontdir}

install -m 0755 -d %{buildroot}%{_fontconfig_templatedir} \
                   %{buildroot}%{_fontconfig_confdir}
install -m 0644 -p %{SOURCE1} \
        %{buildroot}%{_fontconfig_templatedir}/%{fontconf}
ln -s %{_fontconfig_templatedir}/%{fontconf} \
      %{buildroot}%{_fontconfig_confdir}/%{fontconf}

%_font_pkg -f %{fontconf} *.ttf
%doc *.txt

%changelog
* Thu May 29 2014 baseuser@ibm.com
- Base-f19.x spec file
