
# if 0%{?fedora} > 17
# global python3 1
# endif

Summary: D-Bus Python Bindings 
Name: dbus-python
Version: 1.1.1
%define base_release .4
Release: 5%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf

License: MIT
URL: http://www.freedesktop.org/software/dbus-python
Source0: http://dbus.freedesktop.org/releases/dbus-python/%{name}-%{version}.tar.gz
Source999: fivextra.tar.bz2
Patch0: dbus-python-aarch64.patch
# http://cgit.freedesktop.org/dbus/dbus-python/commit/?id=423ee853dfbb4ee9ed89a21e1cf2b6a928e2fc4d
Patch1: dbus-python-pygobject38.patch

#FIV Changes
Patch1001: bug66459-fiv-changes.diff
Patch104308: mcpbug-104308-test-standalone.diff

BuildRequires: dbus-devel
BuildRequires: dbus-glib-devel
BuildRequires: python-devel
BuildRequires: python-docutils
%if 0%{?python3}
BuildRequires: python3-devel
%endif
# for %%check
BuildRequires: dbus-x11 pygobject3

Provides: python-dbus = %{version}-%{release}
Provides: python-dbus%{?_isa} = %{version}-%{release}

%description
D-Bus python bindings for use with python programs.   

%package devel
Summary: Libraries and headers for dbus-python
Requires: %{name}%{?_isa} = %{version}-%{release}

%description devel
Headers and static libraries for hooking up custom mainloops to the dbus python
bindings.

%package -n python3-dbus
Summary: D-Bus bindings for python3
%description -n python3-dbus
%{summary}.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp
Requires: %{name} >= %{version}-%{release}
Requires: dbus-x11
# Do not automatically generate 'provides' since we do not want any
# functionality beyond the testcases provided by this package.
AutoProv: no

%description fivextra
This package contains the testcases built from the package for %{name}.

%prep
%setup -q -n %{name}-%{version} -a 999
%patch0 -p1
%patch1 -p1

%patch1001 -p1
%patch104308 -p1 

%build
%global _configure ../configure

mkdir python2-build; pushd python2-build
%configure PYTHON=%{__python}
make %{?_smp_mflags}
popd

%if 0%{?python3}
mkdir python3-build; pushd python3-build
%configure PYTHON=%{__python3}
make %{?_smp_mflags}
popd
%endif

pushd fivextra
make all
popd

%install
%if 0%{?python3}
make install DESTDIR=$RPM_BUILD_ROOT -C python3-build
%endif

make install DESTDIR=$RPM_BUILD_ROOT -C python2-build

# unpackaged files
rm -fv $RPM_BUILD_ROOT%{python_sitearch}/*.la
rm -fv $RPM_BUILD_ROOT%{python3_sitearch}/*.la
rm -rfv $RPM_BUILD_ROOT%{_datadir}/doc/dbus-python/

#FIV Steps
mkdir -p $RPM_BUILD_ROOT/%{fivdir}/%{name}/
# The libraries are in test/.libs/ . Move it to where it should be
# and delete the un-necessary hidden dir

%if 0%{?python3}
	pushd python3-build
%else 
	pushd python2-build
%endif
mv test/.libs/*.so ../test/
rm -rf test/.libs/ test/*.in test/*.la test/*.lo test/.deps test/*.pyc test/*.pyo test/*.am
popd
# Now copy the files over to BUILD_ROOT
cp -a test $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%check
# FIXME: seeing failures on f19+, http://bugzilla.redhat.com/913936
make check -k -C python2-build ||:
%if 0%{?python3}
make check -k -C python3-build ||:
%endif


%files
%doc COPYING ChangeLog README NEWS
%{python_sitearch}/*.so
%{python_sitelib}/dbus/

%files devel
%doc doc/API_CHANGES.txt doc/HACKING.txt doc/tutorial.txt
%{_includedir}/dbus-1.0/dbus/dbus-python.h
%{_libdir}/pkgconfig/dbus-python.pc

%if 0%{?python3}
%files -n python3-dbus
%{python3_sitearch}/*.so
%{python3_sitelib}/dbus/
%endif

%files fivextra
%{prefix}

%changelog
* Fri Jun 14 2013 baseuser@ibm.com
- Base-8.x spec file
