%global _hardened_build 1

%global systemctl_bin /usr/bin/systemctl
%global check_password_version 1.1

Name: openldap
Version: 2.4.39
%define base_release .1
Release: 2%{?dist}%{?base_release}
Summary: LDAP support libraries
Group: System Environment/Daemons
License: OpenLDAP
URL: http://www.openldap.org/
Source0: ftp://ftp.OpenLDAP.org/pub/OpenLDAP/openldap-release/openldap-%{version}.tgz
Source1: slapd.service
Source2: slapd.sysconfig
Source3: slapd.tmpfiles
Source4: slapd.ldif
Source5: ldap.conf
Source10: ltb-project-openldap-ppolicy-check-password-%{check_password_version}.tar.gz
Source50: libexec-functions
Source51: libexec-convert-config.sh
Source52: libexec-check-config.sh
Source53: libexec-upgrade-db.sh
Source54: libexec-create-certdb.sh
Source55: libexec-generate-server-cert.sh
Source998: slapd.d.tar.gz
Source999: fivextra.tar.bz2

# patches for 2.4
Patch0: openldap-manpages.patch
Patch2: openldap-sql-linking.patch
Patch3: openldap-reentrant-gethostby.patch
Patch4: openldap-smbk5pwd-overlay.patch
Patch5: openldap-ldaprc-currentdir.patch
Patch6: openldap-userconfig-setgid.patch
Patch7: openldap-dns-priority.patch
Patch8: openldap-syncrepl-unset-tls-options.patch
Patch9: openldap-man-sasl-nocanon.patch
Patch10: openldap-ai-addrconfig.patch
Patch11: openldap-nss-update-list-of-ciphers.patch
Patch12: openldap-tls-no-reuse-of-tls_session.patch
Patch13: openldap-nss-regex-search-hashed-cacert-dir.patch
Patch14: openldap-nss-ignore-certdb-type-prefix.patch
Patch15: openldap-nss-certs-from-certdb-fallback-pem.patch
Patch16: openldap-nss-pk11-freeslot.patch
# fix back_perl problems with lt_dlopen()
# might cause crashes because of symbol collisions
# the proper fix is to link all perl modules against libperl
# http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=327585
Patch19: openldap-switch-to-lt_dlopenadvise-to-get-RTLD_GLOBAL-set.patch
# ldapi sasl fix pending upstream inclusion
Patch20: openldap-ldapi-sasl.patch
# rwm reference counting fix, pending upstream inclusion
Patch21: openldap-rwm-reference-counting.patch

# Fedora specific patches
Patch100: openldap-autoconf-pkgconfig-nss.patch
Patch102: openldap-fedora-systemd.patch

BuildRequires: cyrus-sasl-devel, nss-devel, krb5-devel, tcp_wrappers-devel, unixODBC-devel
BuildRequires: glibc-devel, libtool, libtool-ltdl-devel, groff, perl
%{!?cross_build:BuildRequires: perl-devel, perl(ExtUtils::Embed)}
# smbk5pwd overlay:
BuildRequires: openssl-devel
Requires: nss-tools

%description
OpenLDAP is an open source suite of LDAP (Lightweight Directory Access
Protocol) applications and development tools. LDAP is a set of
protocols for accessing directory services (usually phone book style
information, but other information is possible) over the Internet,
similar to the way DNS (Domain Name System) information is propagated
over the Internet. The openldap package contains configuration files,
libraries, and documentation for OpenLDAP.

%package devel
Summary: LDAP development libraries and header files
Group: Development/Libraries
Requires: openldap%{?_isa} = %{version}-%{release}, cyrus-sasl-devel%{?_isa}

%description devel
The openldap-devel package includes the development libraries and
header files needed for compiling applications that use LDAP
(Lightweight Directory Access Protocol) internals. LDAP is a set of
protocols for enabling directory services over the Internet. Install
this package only if you plan to develop or will need to compile
customized LDAP clients.

%package servers
Summary: LDAP server
License: OpenLDAP
Requires: openldap%{?_isa} = %{version}-%{release}, libdb-utils
Requires(pre): shadow-utils
Requires(post): systemd, systemd-sysv, chkconfig
Requires(preun): systemd
Requires(postun): systemd
BuildRequires: libdb-devel
BuildRequires: systemd-units
BuildRequires: cracklib-devel
Group: System Environment/Daemons
# migrationtools (slapadd functionality):
Provides: ldif2ldbm

%description servers
OpenLDAP is an open-source suite of LDAP (Lightweight Directory Access
Protocol) applications and development tools. LDAP is a set of
protocols for accessing directory services (usually phone book style
information, but other information is possible) over the Internet,
similar to the way DNS (Domain Name System) information is propagated
over the Internet. This package contains the slapd server and related files.

%package servers-sql
Summary: SQL support module for OpenLDAP server
Requires: openldap-servers%{?_isa} = %{version}-%{release}
Group: System Environment/Daemons

%description servers-sql
OpenLDAP is an open-source suite of LDAP (Lightweight Directory Access
Protocol) applications and development tools. LDAP is a set of
protocols for accessing directory services (usually phone book style
information, but other information is possible) over the Internet,
similar to the way DNS (Domain Name System) information is propagated
over the Internet. This package contains a loadable module which the
slapd server can use to read data from an RDBMS.

%package clients
Summary: LDAP client utilities
Requires: openldap%{?_isa} = %{version}-%{release}
Group: Applications/Internet

%description clients
OpenLDAP is an open-source suite of LDAP (Lightweight Directory Access
Protocol) applications and development tools. LDAP is a set of
protocols for accessing directory services (usually phone book style
information, but other information is possible) over the Internet,
similar to the way DNS (Domain Name System) information is propagated
over the Internet. The openldap-clients package contains the client
programs needed for accessing and modifying OpenLDAP directories.

%package fivextra
Summary:    OpenLDAP Test Suite - tests and data
Group:      fivextra
Requires:   %{name}-servers %{name}-clients
Prefix:        /opt/fiv/ltp

%description fivextra
OpenLDAP comes with a test suite, which includes sample configurations
and data for a large number of usecases. These testcases are packaged as
a separate rpm to test under base.

%prep
%setup -q -c -a 0 -a 10 -a 999

pushd openldap-%{version}

# use pkg-config for Mozilla NSS library
%patch100 -p1

# alternative include paths for Mozilla NSS
ln -s %{_includedir}/nss3 include/nss
ln -s %{_includedir}/nspr4 include/nspr

AUTOMAKE=%{_bindir}/true autoreconf -fi

%patch0 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch19 -p1
%patch20 -p1
%patch21 -p1

%patch102 -p1

# build smbk5pwd with other overlays
ln -s ../../../contrib/slapd-modules/smbk5pwd/smbk5pwd.c servers/slapd/overlays
mv contrib/slapd-modules/smbk5pwd/README contrib/slapd-modules/smbk5pwd/README.smbk5pwd

mv servers/slapd/back-perl/README{,.back_perl}

# fix documentation encoding
for filename in doc/drafts/draft-ietf-ldapext-acl-model-xx.txt; do
	iconv -f iso-8859-1 -t utf-8 "$filename" > "$filename.utf8"
	mv "$filename.utf8" "$filename"
done

popd

%build
%ifarch s390 s390x
 export CFLAGS="-fPIE"
%else
 export CFLAGS="-fpie"
%endif
export LDFLAGS="-pie"
export CC=%{__cc}

%ifarch s390 s390x
  export CFLAGS="-fPIE"
%else
  export CFLAGS="-fpie"
%endif
export LDFLAGS="-pie"
# avoid stray dependencies (linker flag --as-needed)
# enable experimental support for LDAP over UDP (LDAP_CONNECTIONLESS)
export CFLAGS="${CFLAGS} %{optflags} -Wl,--as-needed -DLDAP_CONNECTIONLESS"

pushd openldap-%{version}
%configure \
	%{?cross_build:--with-yielding_select=no --disable-perl} \
	--enable-debug \
	--enable-dynamic \
	--enable-syslog \
	--enable-proctitle \
	--enable-ipv6 \
	--enable-local \
	\
	--enable-slapd \
	--enable-dynacl \
	--enable-aci \
	--enable-cleartext \
	--enable-crypt \
	--enable-lmpasswd \
	--enable-spasswd \
	--enable-modules \
	--enable-rewrite \
	--enable-rlookups \
	--enable-slapi \
	--disable-slp \
	--enable-wrappers \
	\
	--enable-backends=mod \
	--enable-bdb=yes \
	--enable-hdb=yes \
	--enable-mdb=yes \
	--enable-monitor=yes \
	--disable-ndb \
	\
	--enable-overlays=mod \
	\
	--disable-static \
	--enable-shared \
	\
	--with-cyrus-sasl \
	--without-fetch \
	--with-threads \
	--with-pic \
	--with-tls=moznss \
	--with-gnu-ld \
	\
	--libexecdir=%{_libdir}

make %{_smp_mflags}
popd

pushd ltb-project-openldap-ppolicy-check-password-%{check_password_version}
make LDAP_INC="-I../openldap-%{version}/include \
 -I../openldap-%{version}/servers/slapd \
 -I../openldap-%{version}/build-servers/include"
popd

pushd fivextra
make all
popd

%install

mkdir -p %{buildroot}%{_libdir}/

pushd openldap-%{version}
make install DESTDIR=%{buildroot} STRIP=""
popd

# install check_password module
pushd ltb-project-openldap-ppolicy-check-password-%{check_password_version}
install -m 755 check_password.so %{buildroot}%{_libdir}/openldap/
# install -m 644 README %{buildroot}%{_libdir}/openldap
install -d -m 755 %{buildroot}%{_sysconfdir}/openldap
cat > %{buildroot}%{_sysconfdir}/openldap/check_password.conf <<EOF
# OpenLDAP pwdChecker library configuration

#useCracklib 1
#minPoints 3
#minUpper 0
#minLower 0
#minDigit 0
#minPunct 0
EOF
sed -i -e 's/check_password\.so/check_password.so.%{check_password_version}/' README
mv README{,.check_pwd}
popd
# rename the library
mv %{buildroot}%{_libdir}/openldap/check_password.so{,.%{check_password_version}}

# setup directories for TLS certificates
mkdir -p %{buildroot}%{_sysconfdir}/openldap/certs

# setup data and runtime directories
mkdir -p %{buildroot}%{_sharedstatedir}
mkdir -p %{buildroot}%{_localstatedir}
install -m 0700 -d %{buildroot}%{_sharedstatedir}/ldap
install -m 0755 -d %{buildroot}%{_localstatedir}/run/openldap

# setup autocreation of runtime directories on tmpfs
mkdir -p %{buildroot}%{_tmpfilesdir}
install -m 0644 %SOURCE3 %{buildroot}%{_tmpfilesdir}/slapd.conf

# install default ldap.conf (customized)
rm -f %{buildroot}%{_sysconfdir}/openldap/ldap.conf
install -m 0644 %SOURCE5 %{buildroot}%{_sysconfdir}/openldap/ldap.conf

# setup maintainance scripts
mkdir -p %{buildroot}%{_libexecdir}
install -m 0755 -d %{buildroot}%{_libexecdir}/openldap
install -m 0644 %SOURCE50 %{buildroot}%{_libexecdir}/openldap/functions
install -m 0755 %SOURCE51 %{buildroot}%{_libexecdir}/openldap/convert-config.sh
install -m 0755 %SOURCE52 %{buildroot}%{_libexecdir}/openldap/check-config.sh
install -m 0755 %SOURCE53 %{buildroot}%{_libexecdir}/openldap/upgrade-db.sh
install -m 0755 %SOURCE54 %{buildroot}%{_libexecdir}/openldap/create-certdb.sh
install -m 0755 %SOURCE55 %{buildroot}%{_libexecdir}/openldap/generate-server-cert.sh

# remove build root from config files and manual pages
perl -pi -e "s|%{buildroot}||g" %{buildroot}%{_sysconfdir}/openldap/*.conf
perl -pi -e "s|%{buildroot}||g" %{buildroot}%{_mandir}/*/*.*

# we don't need the default files -- RPM handles changes
rm -f %{buildroot}%{_sysconfdir}/openldap/*.default
rm -f %{buildroot}%{_sysconfdir}/openldap/schema/*.default

# install an init script for the servers
mkdir -p %{buildroot}%{_unitdir}
install -m 0644 %SOURCE1 %{buildroot}%{_unitdir}/slapd.service

# install syconfig/ldap
mkdir -p %{buildroot}%{_sysconfdir}/sysconfig
install -m 644 %SOURCE2 %{buildroot}%{_sysconfdir}/sysconfig/slapd

# move slapd out of _libdir
mv %{buildroot}%{_libdir}/slapd %{buildroot}%{_sbindir}/

# setup tools as symlinks to slapd
rm -f %{buildroot}%{_sbindir}/slap{acl,add,auth,cat,dn,index,passwd,test,schema}
rm -f %{buildroot}%{_libdir}/slap{acl,add,auth,cat,dn,index,passwd,test,schema}
for X in acl add auth cat dn index passwd test schema; do ln -s slapd %{buildroot}%{_sbindir}/slap$X ; done

# tweak permissions on the libraries to make sure they're correct
chmod 0755 %{buildroot}%{_libdir}/lib*.so*
chmod 0644 %{buildroot}%{_libdir}/lib*.*a

# slapd.conf(5) is obsoleted since 2.3, see slapd-config(5)
# new configuration will be generated in %%post
mkdir -p %{buildroot}%{_datadir}
install -m 0755 -d %{buildroot}%{_datadir}/openldap-servers
install -m 0644 %SOURCE4 %{buildroot}%{_datadir}/openldap-servers/slapd.ldif
install -m 0700 -d %{buildroot}%{_sysconfdir}/openldap/slapd.d
rm -f %{buildroot}%{_sysconfdir}/openldap/slapd.conf
rm -f %{buildroot}%{_sysconfdir}/openldap/slapd.ldif

# move doc files out of _sysconfdir
mv %{buildroot}%{_sysconfdir}/openldap/schema/README README.schema
mv %{buildroot}%{_sysconfdir}/openldap/DB_CONFIG.example %{buildroot}%{_datadir}/openldap-servers/DB_CONFIG.example
chmod 0644 openldap-%{version}/servers/slapd/back-sql/rdbms_depend/timesten/*.sh
chmod 0644 %{buildroot}%{_datadir}/openldap-servers/DB_CONFIG.example

# Dump some default slapd.d files to the directory
pushd $RPM_BUILD_ROOT/%{_sysconfdir}/openldap/slapd.d
tar -xf %{SOURCE998}
popd

#Create FIV tests directory
install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests

#update the library path to the system library path
find $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests -type f -name '*.conf' -exec perl -pi -e 's,\.\.\/servers\/slapd\/back-.*,%{_libdir}/%{name},g;s,\.\.\/servers\/slapd\/overlays,%{_libdir}/%{name},g' {} \;

#Modify the testcases (Probably a bug)
perl -pi -e 's,memberofmod,memberofyes, if $. == 75' $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests/scripts/test057-memberof-refint
perl -pi -le 'print "#syncprovmod#moduleload syncprov.la" if $. == 29' $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests/data/slapd-ppolicy.conf
perl -pi -e 's,syncprovmod,syncprovyes,;s,^olcModulePath: .*,olcModulePath: %{_libdir}/%{name},g' $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests/scripts/test049-sync-config $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests/scripts/test057-memberof-refint

#Add the modifications in the conf.sh to process the modulepatha nd moduleload settings.
perl -pi -le 'print "\t\t-e \"s/^#mod#modulepath/modulepath/\"\t\t\\\n\t\t-e \"s/^#.*#moduleload/moduleload/\"\t\t\\" if $. == 39' $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests/scripts/conf.sh
#perl -pi -e 's/testrun/\$TESTDIR/g;s,^SHTOOL=.*,. scripts/defines.sh,g' $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests/scripts/all
perl -pi -e 's/^(Makefile|SUBDIRS)/#$1/g'  $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests/Makefile
#echo 'SHTOOL="./scripts/shtool"' >>  $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests/scripts/defines.sh

# Steps to package the openldap tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
       install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
       install -m 755 `find fivextra/$dir/* -type d -prune -o -print`  $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done 
find $RPM_BUILD_ROOT/%{fivdir}/%{name} -depth -name CVS -type d -exec rm -rf {} \;

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

# remove files which we don't want packaged
rm -f %{buildroot}%{_libdir}/*.la
rm -f %{buildroot}%{_libdir}/openldap/*.so

rm -f %{buildroot}%{_localstatedir}/openldap-data/DB_CONFIG.example
rmdir %{buildroot}%{_localstatedir}/openldap-data

%post

/sbin/ldconfig

# create certificate database
%{_libexecdir}/openldap/create-certdb.sh >&/dev/null || :

%postun -p /sbin/ldconfig

%pre servers

# create ldap user and group
getent group ldap &>/dev/null || groupadd -r -g 55 ldap
getent passwd ldap &>/dev/null || \
	useradd -r -g ldap -u 55 -d %{_sharedstatedir}/ldap -s /sbin/nologin -c "OpenLDAP server" ldap

if [ $1 -eq 2 ]; then
	# package upgrade

	old_version=$(rpm -q --qf=%%{version} openldap-servers)
	new_version=%{version}

	if [ "$old_version" != "$new_version" ]; then
		touch %{_sharedstatedir}/ldap/rpm_upgrade_openldap &>/dev/null
	fi
fi

exit 0


%post servers

/sbin/ldconfig
%systemd_post slapd.service

# generate sample TLS certificate for server (will not replace)
%{_libexecdir}/openldap/generate-server-cert.sh -o &>/dev/null || :

# generate/upgrade configuration
if [ ! -f %{_sysconfdir}/openldap/slapd.d/cn=config.ldif ]; then
	if [ -f %{_sysconfdir}/openldap/slapd.conf ]; then
		%{_libexecdir}/openldap/convert-config.sh &>/dev/null
		mv %{_sysconfdir}/openldap/slapd.conf %{_sysconfdir}/openldap/slapd.conf.bak
	else
		%{_libexecdir}/openldap/convert-config.sh -f %{_datadir}/openldap-servers/slapd.ldif &>/dev/null
	fi
fi

start_slapd=0

# upgrade the database
if [ -f %{_sharedstatedir}/ldap/rpm_upgrade_openldap ]; then
	if %{systemctl_bin} --quiet is-active slapd.service; then
		%{systemctl_bin} stop slapd.service
		start_slapd=1
	fi

	%{_libexecdir}/openldap/upgrade-db.sh &>/dev/null
	rm -f %{_sharedstatedir}/ldap/rpm_upgrade_openldap
fi

# conversion from /etc/sysconfig/ldap to /etc/sysconfig/slapd
if [ $1 -eq 2 ]; then
	# we expect that 'ldap' will be renamed to 'ldap.rpmsave' after removing the old package
	[ -r %{_sysconfdir}/sysconfig/ldap ] || exit 0
	source %{_sysconfdir}/sysconfig/ldap &>/dev/null

	new_urls=
	[ "$SLAPD_LDAP" != "no" ]   && new_urls="$new_urls ldap:///"
	[ "$SLAPD_LDAPI" != "no" ]  && new_urls="$new_urls ldapi:///"
	[ "$SLAPD_LDAPS" == "yes" ] && new_urls="$new_urls ldaps:///"
	[ -n "$SLAPD_URLS" ]        && new_urls="$new_urls $SLAPD_URLS"

	failure=0
	cp -f %{_sysconfdir}/sysconfig/slapd %{_sysconfdir}/sysconfig/slapd.rpmconvert
	sed -i '/^#\?SLAPD_URLS=/s@.*@SLAPD_URLS="'"$new_urls"'"@' %{_sysconfdir}/sysconfig/slapd.rpmconvert &>/dev/null || failure=1
	[ -n "$SLAPD_OPTIONS" ] && \
		sed -i '/^#\?SLAPD_OPTIONS=/s@.*$@SLAPD_OPTIONS="'"$SLAPD_OPTIONS"'"@' %{_sysconfdir}/sysconfig/slapd.rpmconvert &>/dev/null || failure=1

	if [ $failure -eq 0 ]; then
		mv -f %{_sysconfdir}/sysconfig/slapd.rpmconvert %{_sysconfdir}/sysconfig/slapd
	else
		rm -f %{_sysconfdir}/sysconfig/slapd.rpmconvert
	fi
fi

# restart after upgrade
if [ $1 -ge 1 ]; then
	if [ $start_slapd -eq 1 ]; then
		%{systemctl_bin} start slapd.service &>/dev/null || :
	else
		%{systemctl_bin} condrestart slapd.service &>/dev/null || :
	fi
fi

exit 0

%preun servers

%systemd_preun slapd.service


%postun servers

/sbin/ldconfig
%systemd_postun_with_restart slapd.service


%triggerun servers -- openldap-servers < 2.4.26-6

# migration from SysV to systemd
/usr/bin/systemd-sysv-convert --save slapd &>/dev/null || :
/usr/sbin/chkconfig --del slapd &>/dev/null || :
%{systemctl_bin} try-restart slapd.service &>/dev/null || :


%triggerin servers -- libdb

# libdb upgrade (setup for %%triggerun)
if [ $2 -eq 2 ]; then
	# we are interested in minor version changes (both versions of libdb are installed at this moment)
	if [ "$(rpm -q --qf="%%{version}\n" libdb | sed 's/\.[0-9]*$//' | sort -u | wc -l)" != "1" ]; then
		touch %{_sharedstatedir}/ldap/rpm_upgrade_libdb
	else
		rm -f %{_sharedstatedir}/ldap/rpm_upgrade_libdb
	fi
fi

exit 0


%triggerun servers -- libdb

# libdb upgrade (finish %%triggerin)
if [ -f %{_sharedstatedir}/ldap/rpm_upgrade_libdb ]; then
	if %{systemctl_bin} --quiet is-active slapd.service; then
		%{systemctl_bin} stop slapd.service
		start=1
	else
		start=0
	fi

	%{_libexecdir}/openldap/upgrade-db.sh &>/dev/null
	rm -f %{_sharedstatedir}/ldap/rpm_upgrade_libdb

	[ $start -eq 1 ] && %{systemctl_bin} start slapd.service &>/dev/null
fi

exit 0


%files
%doc openldap-%{version}/ANNOUNCEMENT
%doc openldap-%{version}/CHANGES
%doc openldap-%{version}/COPYRIGHT
%doc openldap-%{version}/LICENSE
%doc openldap-%{version}/README
%dir %{_sysconfdir}/openldap
%dir %{_sysconfdir}/openldap/certs
%config(noreplace) %{_sysconfdir}/openldap/ldap.conf
%dir %{_libexecdir}/openldap/
%{_libexecdir}/openldap/create-certdb.sh
%{_libdir}/liblber-2.4*.so.*
%{_libdir}/libldap-2.4*.so.*
%{_libdir}/libldap_r-2.4*.so.*
%{_libdir}/libslapi-2.4*.so.*
%{_mandir}/man5/ldif.5*
%{_mandir}/man5/ldap.conf.5*

%files servers
%doc openldap-%{version}/contrib/slapd-modules/smbk5pwd/README.smbk5pwd
%doc openldap-%{version}/doc/guide/admin/*.html
%doc openldap-%{version}/doc/guide/admin/*.png
%doc openldap-%{version}/servers/slapd/back-perl/SampleLDAP.pm
%doc openldap-%{version}/servers/slapd/back-perl/README.back_perl
%doc openldap-%{version}/servers/slapd/back-perl/README.back_perl
%doc ltb-project-openldap-ppolicy-check-password-%{check_password_version}/README.check_pwd
%doc README.schema
%config(noreplace) %dir %attr(0750,ldap,ldap) %{_sysconfdir}/openldap/slapd.d
%attr(-,ldap,ldap) %{_sysconfdir}/openldap/slapd.d/*
%config(noreplace) %{_sysconfdir}/openldap/schema
%config(noreplace) %{_sysconfdir}/sysconfig/slapd
%config(noreplace) %{_sysconfdir}/openldap/check_password.conf
%{_tmpfilesdir}/slapd.conf
%dir %attr(0700,ldap,ldap) %{_sharedstatedir}/ldap
%dir %attr(-,ldap,ldap) %{_localstatedir}/run/openldap
%{_unitdir}/slapd.service
%{_datadir}/openldap-servers/
%{_libdir}/openldap/accesslog*
%{_libdir}/openldap/auditlog*
%{_libdir}/openldap/back_dnssrv*
%{_libdir}/openldap/back_ldap*
%{_libdir}/openldap/back_meta*
%{_libdir}/openldap/back_null*
%{_libdir}/openldap/back_passwd*
%{_libdir}/openldap/back_relay*
%{_libdir}/openldap/back_shell*
%{_libdir}/openldap/back_sock*
%{!?cross_build:%{_libdir}/openldap/back_perl*}
%{_libdir}/openldap/collect*
%{_libdir}/openldap/constraint*
%{_libdir}/openldap/dds*
%{_libdir}/openldap/deref*
%{_libdir}/openldap/dyngroup*
%{_libdir}/openldap/dynlist*
%{_libdir}/openldap/memberof*
%{_libdir}/openldap/pcache*
%{_libdir}/openldap/ppolicy*
%{_libdir}/openldap/refint*
%{_libdir}/openldap/retcode*
%{_libdir}/openldap/rwm*
%{_libdir}/openldap/seqmod*
%{_libdir}/openldap/smbk5pwd*
%{_libdir}/openldap/sssvlv*
%{_libdir}/openldap/syncprov*
%{_libdir}/openldap/translucent*
%{_libdir}/openldap/unique*
%{_libdir}/openldap/valsort*
%{_libdir}/openldap/check_password*
%{_libexecdir}/openldap/functions
%{_libexecdir}/openldap/convert-config.sh
%{_libexecdir}/openldap/check-config.sh
%{_libexecdir}/openldap/upgrade-db.sh
%{_libexecdir}/openldap/generate-server-cert.sh
%{_sbindir}/sl*
%{_mandir}/man8/*
%{_mandir}/man5/slapd*.5*
%{_mandir}/man5/slapo-*.5*
# obsolete configuration
%ghost %config(noreplace,missingok) %attr(0640,ldap,ldap) %{_sysconfdir}/openldap/slapd.conf
%ghost %config(noreplace,missingok) %attr(0640,ldap,ldap) %{_sysconfdir}/openldap/slapd.conf.bak

%files servers-sql
%doc openldap-%{version}/servers/slapd/back-sql/docs/*
%doc openldap-%{version}/servers/slapd/back-sql/rdbms_depend
%{_libdir}/openldap/back_sql*

%files clients
%{_bindir}/*
%{_mandir}/man1/*

%files devel
%doc openldap-%{version}/doc/drafts openldap-%{version}/doc/rfc
%{_libdir}/lib*.so
%{_includedir}/*
%{_mandir}/man3/*

%files fivextra
%defattr(-,root,root)
%{prefix}

%changelog
* Fri Jan 24 2014 baseuser@ibm.com
- Base-f19.x spec file
