Summary: Command line tool for setting up authentication from network services
Name: authconfig
Version: 6.2.6
%define base_release .5
Release: 3%{?dist}.1%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
License: GPLv2+
ExclusiveOS: Linux
Group: System Environment/Base
URL: https://fedorahosted.org/authconfig
Source: https://fedorahosted.org/releases/a/u/%{name}/%{name}-%{version}.tar.bz2
Source999: fivextra.tar.bz2
Patch1: authconfig-6.2.6-use-first-pass-revert.patch
Patch2: authconfig-6.2.6-sssdservice.patch
Patch3: authconfig-6.2.6-gdm-nolastlog.patch
Patch104524: bug-104524-never-stop-rpcbind.patch

Requires: newt-python, pam >= 0.99.10.0, python, libpwquality > 0.9
Conflicts: pam_krb5 < 1.49, samba-common < 3.0, samba-client < 3.0
Conflicts: nss_ldap < 254, sssd < 0.99.1
Conflicts: freeipa-client < 2.2.0, ipa-client < 2.2.0
BuildRequires: glib2-devel, python >= 2.6, python-devel
BuildRequires: desktop-file-utils, intltool, gettext, perl-XML-Parser
Requires: /usr/bin/openssl

%description 
Authconfig is a command line utility which can configure a workstation
to use shadow (more secure) passwords.  Authconfig can also configure a
system to be a client for certain networked user information and
authentication schemes.

%package gtk
Summary: Graphical tool for setting up authentication from network services
Group: System Environment/Base
Requires: %{name} = %{version}-%{release}, pygtk2-libglade >= 2.14.0
Requires: usermode-gtk, hicolor-icon-theme

%description gtk
Authconfig-gtk is a GUI program which can configure a workstation
to use shadow (more secure) passwords.  Authconfig-gtk can also configure
a system to be a client for certain networked user information and
authentication schemes.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -n %{name}-%{version} -a 999
%patch1 -p1 -b .revert
%patch2 -p1 -b .sssdservice
%patch3 -p1 -b .nolastlog

%patch104524 -p1

%build
%configure
make

%install
make install DESTDIR=$RPM_BUILD_ROOT
rm $RPM_BUILD_ROOT/%{_libdir}/python*/site-packages/acutilmodule.a
rm $RPM_BUILD_ROOT/%{_libdir}/python*/site-packages/acutilmodule.la
rm $RPM_BUILD_ROOT/%{_datadir}/%{name}/authconfig-tui.py
ln -s authconfig.py $RPM_BUILD_ROOT/%{_datadir}/%{name}/authconfig-tui.py

%find_lang %{name}
find $RPM_BUILD_ROOT%{_datadir} -name "*.mo" | xargs ./utf8ify-mo

# Steps to package the authconfig tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%post gtk
touch --no-create %{_datadir}/icons/hicolor &>/dev/null || :

%postun gtk
if [ $1 -eq 0 ] ; then
    touch --no-create %{_datadir}/icons/hicolor &>/dev/null
    gtk-update-icon-cache %{_datadir}/icons/hicolor &>/dev/null || :
fi

%posttrans gtk
gtk-update-icon-cache %{_datadir}/icons/hicolor &>/dev/null || :

%files fivextra
%{prefix}

%files -f %{name}.lang
%defattr(-,root,root,-)
%doc COPYING NOTES TODO README.samba3
%ghost %config(noreplace) %{_sysconfdir}/sysconfig/authconfig
%ghost %config(noreplace) %{_sysconfdir}/pam.d/system-auth-ac
%ghost %config(noreplace) %{_sysconfdir}/pam.d/password-auth-ac
%ghost %config(noreplace) %{_sysconfdir}/pam.d/fingerprint-auth-ac
%ghost %config(noreplace) %{_sysconfdir}/pam.d/smartcard-auth-ac
%ghost %config(noreplace) %{_sysconfdir}/pam.d/postlogin-ac
%{_sbindir}/cacertdir_rehash
%{_sbindir}/authconfig
%{_sbindir}/authconfig-tui
%exclude %{_mandir}/man8/system-config-authentication.*
%exclude %{_mandir}/man8/authconfig-gtk.*
%{_mandir}/man8/*
%{_mandir}/man5/*
%{_libdir}/python*/site-packages/acutilmodule.so
%dir %{_datadir}/%{name}
%{_datadir}/%{name}/authconfig.py*
%{_datadir}/%{name}/authconfig-tui.py*
%{_datadir}/%{name}/authinfo.py*
%{_datadir}/%{name}/shvfile.py*
%{_datadir}/%{name}/dnsclient.py*
%{_datadir}/%{name}/msgarea.py*
%attr(700,root,root) %dir %{_localstatedir}/lib/%{name}

%files gtk
%defattr(-,root,root,-)
%{_bindir}/authconfig
%{_bindir}/authconfig-tui
%{_bindir}/authconfig-gtk
%{_bindir}/system-config-authentication
%{_sbindir}/authconfig-gtk
%{_sbindir}/system-config-authentication
%{_mandir}/man8/system-config-authentication.*
%{_mandir}/man8/authconfig-gtk.*
%{_datadir}/%{name}/authconfig.glade
%{_datadir}/%{name}/authconfig-gtk.py*
%config(noreplace) %{_sysconfdir}/pam.d/authconfig-gtk
%config(noreplace) %{_sysconfdir}/pam.d/system-config-authentication
%config(noreplace) %{_sysconfdir}/security/console.apps/authconfig-gtk
%config(noreplace) %{_sysconfdir}/security/console.apps/system-config-authentication
%config(noreplace) %{_sysconfdir}/pam.d/authconfig
%config(noreplace) %{_sysconfdir}/pam.d/authconfig-tui
%config(noreplace) %{_sysconfdir}/security/console.apps/authconfig
%config(noreplace) %{_sysconfdir}/security/console.apps/authconfig-tui
%{_datadir}/applications/*
%{_datadir}/icons/hicolor/16x16/apps/system-config-authentication.*
%{_datadir}/icons/hicolor/22x22/apps/system-config-authentication.*
%{_datadir}/icons/hicolor/24x24/apps/system-config-authentication.*
%{_datadir}/icons/hicolor/32x32/apps/system-config-authentication.*
%{_datadir}/icons/hicolor/48x48/apps/system-config-authentication.*
%{_datadir}/icons/hicolor/256x256/apps/system-config-authentication.*

%changelog
* Wed Jul 03 2013 baseuser@ibm.com
- Base-8.x spec file
