%define _hardened_build 1
Name:             zfs-fuse
Version:          0.7.0
%define base_release .3
Release:          11%{?dist}%{?base_release}
Summary:          ZFS ported to Linux FUSE
Group:            System Environment/Base
License:          CDDL
URL:              http://zfs-fuse.net/
Source00:         http://zfs-fuse.net/releases/0.7.0/%{name}-%{version}.tar.bz2
Source01:         zfs-fuse.service
Source02:         zfs-fuse.scrub
Source03:         zfs-fuse.sysconfig
Source04:         zfs-fuse-helper
Patch0:           zfs-fuse-0.7.0-umem.patch
Patch1:           zfs-fuse-0.7.0-stack.patch
BuildRequires:    fuse-devel libaio-devel scons zlib-devel openssl-devel libattr-devel prelink
BuildRequires:    systemd-units
Requires:         fuse >= 2.7.4-1
Requires(post): systemd-units
Requires(preun): systemd-units
Requires(postun): systemd-units
# (2010 karsten@redhat.com) zfs-fuse doesn't have s390(x) implementations for atomic instructions
ExcludeArch:      s390
ExcludeArch:      s390x
BuildRoot:        %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

%description
ZFS is an advanced modern general-purpose filesystem from Sun
Microsystems, originally designed for Solaris/OpenSolaris.

This project is a port of ZFS to the FUSE framework for the Linux
operating system.

%prep
%setup -q

%patch0 -p0
%patch1 -p1

f=LICENSE
%{__mv} $f $f.iso88591
iconv -o $f -f iso88591 -t utf8 $f.iso88591
%{__rm} -f $f.iso88591

chmod -x contrib/test-datasets
chmod -x contrib/find-binaries
chmod -x contrib/solaris/fixfiles.py
chmod -x contrib/zfsstress.py

%build
export CCFLAGS="%{optflags}"
pushd src

scons debug=1 optim='%{optflags}'

%install
%{__rm} -rf %{buildroot}
pushd src
scons debug=1 install install_dir=%{buildroot}%{_bindir} man_dir=%{buildroot}%{_mandir}/man8/ cfg_dir=%{buildroot}/%{_sysconfdir}/%{name}
%{__install} -Dp -m 0644 %{SOURCE1} %{buildroot}%{_unitdir}/%{name}.service
%{__install} -Dp -m 0755 %{SOURCE2} %{buildroot}%{_sysconfdir}/cron.weekly/98-%{name}-scrub
%{__install} -Dp -m 0644 %{SOURCE3} %{buildroot}%{_sysconfdir}/sysconfig/%{name}
%{__install} -Dp -m 0755 %{SOURCE4} %{buildroot}%{_bindir}/zfs-fuse-helper

#set stack not executable, BZ 911150
for i in zdb zfs zfs-fuse zpool ztest; do
       /usr/bin/execstack -c %{buildroot}%{_bindir}/$i
done

%clean
%{__rm} -rf %{buildroot}

%post
# Move cache if upgrading
oldcache=/etc/zfs/zpool.cache      # this changed per 0.6.9, only needed when upgrading from earlier versions
newcache=/var/lib/zfs/zpool.cache

if [[ -f $oldcache && ! -e $newcache ]]; then
  echo "Moving existing zpool.cache to new location"
  mkdir -p $(dirname $newcache)
  mv $oldcache $newcache
else
  if [ -e $oldcache ]; then
    echo "Note: old zpool.cache present but no longer used ($oldcache)"
  fi
fi

if [ $1 -eq 1 ] ; then 
    # Initial installation 
    /bin/systemctl daemon-reload >/dev/null 2>&1 || :
fi

%preun
if [ $1 -eq 0 ] ; then
    # Package removal, not upgrade
    /bin/systemctl --no-reload disable zfs-fuse.service > /dev/null 2>&1 || :
    /bin/systemctl stop zfs-fuse.service > /dev/null 2>&1 || :
fi

%postun
/bin/systemctl daemon-reload >/dev/null 2>&1 || :
if [ $1 -ge 1 ] ; then
    # Package upgrade, not uninstall
    /bin/systemctl try-restart zfs-fuse.service >/dev/null 2>&1 || :
    echo "Removing files since we removed the last package"
    rm -rf /var/run/zfs
    rm -rf /var/lock/zfs
fi

%triggerun -- zfs-fuse < 0.7.0-4
# Save the current service runlevel info
# User must manually run systemd-sysv-convert --apply zfs-fuse
# to migrate them to systemd targets
/usr/bin/systemd-sysv-convert --save zfs-fuse >/dev/null 2>&1 ||:

# Run these because the SysV package being removed won't do them
/sbin/chkconfig --del zfs-fuse >/dev/null 2>&1 || :
/bin/systemctl try-restart zfs-fuse.service >/dev/null 2>&1 || :

%files
%defattr(-, root, root, -)
%doc BUGS CHANGES contrib HACKING LICENSE README 
%doc README.NFS STATUS TESTING TODO
%{_bindir}/zdb
%{_bindir}/zfs
%{_bindir}/zfs-fuse
%{_bindir}/zfs-fuse-helper
%{_bindir}/zpool
%{_bindir}/zstreamdump
%{_bindir}/ztest
%{_unitdir}/%{name}.service
%{_sysconfdir}/cron.weekly/98-%{name}-scrub
%config(noreplace) %{_sysconfdir}/sysconfig/%{name}
%{_sysconfdir}/%{name}/
%{_mandir}/man8/zfs-fuse.8.gz
%{_mandir}/man8/zdb.8.gz
%{_mandir}/man8/zfs.8.gz
%{_mandir}/man8/zpool.8.gz
%{_mandir}/man8/zstreamdump.8.gz

%changelog
* Wed Jun 26 2013 baseuser@ibm.com
- Base-8.x spec file
