# if 0%{?fedora} > 12 || 0%{?rhel} > 6
# global with_python3 1
# endif

%global modname cmd2

Name:             python-cmd2
Version:          0.6.4
%define base_release .2
Release:          7%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Summary:          Extra features for standard library's cmd module

Group:            Development/Libraries
License:          MIT
URL:              http://pypi.python.org/pypi/cmd2
Source0:          http://pypi.python.org/packages/source/c/%{modname}/%{modname}-%{version}.tar.gz
Patch0:           silent-editor-check.patch

BuildArch:        noarch


BuildRequires:    python2-devel
BuildRequires:    dos2unix

%if 0%{?with_python3}
BuildRequires:    python3-devel
BuildRequires:    python-tools
BuildRequires:    dos2unix
%endif

Requires:         pyparsing

%description
Enhancements for standard library's cmd module.

Drop-in replacement adds several features for command-prompt tools:

 * Searchable command history (commands: "hi", "li", "run")
 * Load commands from file, save to file, edit commands in file
 * Multi-line commands
 * Case-insensitive commands
 * Special-character shortcut commands (beyond cmd's "@" and "!")
 * Settable environment parameters 
 * Parsing commands with flags
 * > (filename), >> (filename) redirect output to file
 * < (filename) gets input from file
 * bare >, >>, < redirect to/from paste buffer
 * accepts abbreviated commands when unambiguous
 * `py` enters interactive Python console
 * test apps against sample session transcript (see example/example.py)

Usable without modification anywhere cmd is used; simply import cmd2.Cmd
in place of cmd.Cmd.

See docs at http://packages.python.org/cmd2/

%if 0%{?with_python3}
%package -n python3-cmd2
Summary:        Extra features for standard library's cmd module
Group:          Development/Libraries

Requires:       python3-pyparsing

%description -n python3-cmd2
Enhancements for standard library's cmd module.

Drop-in replacement adds several features for command-prompt tools:

 * Searchable command history (commands: "hi", "li", "run")
 * Load commands from file, save to file, edit commands in file
 * Multi-line commands
 * Case-insensitive commands
 * Special-character shortcut commands (beyond cmd's "@" and "!")
 * Settable environment parameters 
 * Parsing commands with flags
 * > (filename), >> (filename) redirect output to file
 * < (filename) gets input from file
 * bare >, >>, < redirect to/from paste buffer
 * accepts abbreviated commands when unambiguous
 * `py` enters interactive Python console
 * test apps against sample session transcript (see example/example.py)

Usable without modification anywhere cmd is used; simply import cmd2.Cmd
in place of cmd.Cmd.

See docs at http://packages.python.org/cmd2/
%endif

%prep
%setup -q -n %{modname}-%{version}
%patch0 -p1

chmod -x README.txt
dos2unix README.txt

%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
%endif


%build
%{__python} setup.py build

%if 0%{?with_python3}
/usr/bin/2to3 -w -n %{py3dir}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif



%install
%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install -O1 --skip-build --root=%{buildroot}
popd
%endif

%{__python} setup.py install -O1 --skip-build --root=%{buildroot}


%files
%doc README.txt 
%{python_sitelib}/cmd2.py*
%{python_sitelib}/%{modname}-%{version}*

%if 0%{?with_python3}
%files -n python3-%{modname}
%doc README.txt
%{python3_sitelib}/cmd2.py*
%{python3_sitelib}/__pycache__/cmd2*
%{python3_sitelib}/%{modname}-%{version}*

%endif


%changelog
* Fri Dec 13 2013 baseuser@ibm.com
- Base-8.x spec file
