%if %{?WITH_SELINUX:0}%{!?WITH_SELINUX:1}
%define WITH_SELINUX 1
%endif
%if %{?WITH_AUDIT:0}%{!?WITH_AUDIT:1}
%define WITH_AUDIT 1
%endif
Summary: An utility for setting or changing passwords using PAM
Name: passwd
Version: 0.78.99
%define base_release .3
Release: 4%{?dist}%{?base_release}
License: BSD or GPL+
Group: System Environment/Base
URL: http://fedorahosted.org/passwd
Source: https://fedorahosted.org/releases/p/a/%{name}/%{name}-%{version}.tar.bz2
Source999: fivextra.tar.bz2
Buildroot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Requires: pam >= 1.0.90, /etc/pam.d/system-auth
%if %{WITH_SELINUX}
Requires: libselinux >= 2.1.6-3
BuildRequires: libselinux-devel >= 2.1.6-3
%endif
BuildRequires: glib2-devel, libuser-devel, pam-devel, libuser >= 0.53-1
BuildRequires: gettext, popt-devel
%if %{WITH_AUDIT}
BuildRequires: audit-libs-devel >= 1.0.14
Requires: audit-libs >= 1.0.14
%endif

%description
This package contains a system utility (passwd) which sets
or changes passwords, using PAM (Pluggable Authentication
Modules) library.

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}

%prep
%setup -q -n %{name}-%{version} -a 999

%build
%configure \
%if %{WITH_SELINUX}
        --with-selinux \
%else
        --without-selinux \
%endif
%if %{WITH_AUDIT}
        --with-audit
%else
        --without-audit
%endif
make DEBUG= RPM_OPT_FLAGS="$RPM_OPT_FLAGS"

%install
rm -rf $RPM_BUILD_ROOT

make install DESTDIR=$RPM_BUILD_ROOT
install -m 755 -d $RPM_BUILD_ROOT%{_sysconfdir}/pam.d/
install -m 644 passwd.pamd $RPM_BUILD_ROOT%{_sysconfdir}/pam.d/passwd
%find_lang %{name}
for dir in $(ls -1d $RPM_BUILD_ROOT%{_mandir}/{??,??_??}) ; do
    dir=$(echo $dir | sed -e "s|^$RPM_BUILD_ROOT||")
    lang=$(basename $dir)
    echo "%%lang($lang) $dir/man*/*" >> %{name}.lang
done

for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}.lang
%defattr(-,root,root,-)
%doc COPYING AUTHORS ChangeLog
%config(noreplace) %{_sysconfdir}/pam.d/passwd
%attr(4755,root,root) %{_bindir}/passwd
%{_mandir}/man1/passwd.1*

%files fivextra
%{prefix}

%changelog
* Fri Jun 21 2013 baseuser@ibm.com
- Base-8.x spec file
