%if ! 0%{?base}
%global with_python3 1
%endif

%global oname rtslib-fb

Name:           python-rtslib
License:        ASL 2.0
Group:          System Environment/Libraries
Summary:        API for Linux kernel LIO SCSI target
Version:        2.1.fb40
%define base_release .1
Release:        2%{?dist}%{?base_release}
URL:            https://fedorahosted.org/targetcli-fb/
Source:         https://fedorahosted.org/released/targetcli-fb/%{oname}-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Patch0:         python-rtslib-fix-fcoe.patch
BuildArch:      noarch
BuildRequires:  python-devel epydoc
Requires:       python-kmod

%if 0%{?with_python3}
BuildRequires:  python3-devel python-tools
%endif

%package doc
Summary:        Documentation for python-rtslib
Group:          Documentation
Requires:       %{name} = %{version}-%{release}


%description
API for generic Linux SCSI kernel target.

%description doc
API documentation for rtslib, to configure the generic Linux SCSI
multiprotocol kernel target.

%if 0%{?with_python3}
%package -n python3-rtslib
Summary:        API for Linux kernel LIO SCSI target
Group:          System Environment/Libraries

%description -n python3-rtslib
API for generic Linux SCSI kernel target.
%endif

%prep
%setup -q -n %{oname}-%{version}
%patch0 -p1

%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
%endif

%build
%{__python} setup.py build
mkdir -p doc/html
epydoc --no-sourcecode --html -n rtslib -o doc/html rtslib/*.py

%if 0%{?with_python3}
pushd %{py3dir}
2to3 --write --nobackups .
%{__python3} setup.py build
popd
%endif

%install
rm -rf %{buildroot}
%{__python} setup.py install --skip-build --root %{buildroot}

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install --skip-build --root %{buildroot}
popd
%endif

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root,-)
%{python_sitelib}/*
%doc COPYING README.md

%if 0%{?with_python3}
%files -n python3-rtslib
%{python3_sitelib}/*
%doc COPYING README.md
%endif

%files doc
%doc doc/html

%changelog
* Tue Feb 11 2014 baseuser@ibm.com
- Base-f19.x spec file
