%global snap_release 20121102git
Summary: Root crontab files used to schedule the execution of programs
Name: crontabs
Version: 1.11
%define base_release .2
Release: 5.%{snap_release}%{?dist}%{?base_release}
License: Public Domain and GPLv2
Group: System Environment/Base
URL: https://fedorahosted.org/crontabs 
#Source0: https://fedorahosted.org/releases/c/r/crontabs/%{name}-%{version}-1.%{snap_release}.tar.gz
Source0: crontab1
Source1: run-parts
Source2: crontabs.4
Source998: crontabs-webmin.wbm.gz
Patch83514: crontabs-webmin.patch
BuildArch: noarch
Requires: /etc/cron.d

%description
This package is used by Fedora mainly for executing files by cron.

The crontabs package contains root crontab files and directories.
You will need to install cron daemon to run the jobs from the crontabs.
The cron daemon such as cronie or fcron checks the crontab files to
see when particular commands are scheduled to be executed.  If commands
are scheduled, it executes them.

Crontabs handles a basic system function, so it should be installed on
your system.

%package webmin
# NOTE: proc-webmin not be listed as a dependency. We include it
# in /usr/libexec/webmin/proc, but hide it from the user. Also
# proc is part of webmin.
Requires: /bin/sh /usr/bin/perl webmin 
AutoReq: 0
Summary: Webmin for %{name} package
Group:  System/Tools
BuildArch: noarch

%description webmin
This package contains webmin plugin for %{name}.

%prep
%setup -q -T -c -a 998

# Webmin patch
%patch83514

%build
#empty

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/etc/cron.{hourly,daily,weekly,monthly}
mkdir -p $RPM_BUILD_ROOT/usr/bin
mkdir -p $RPM_BUILD_ROOT/%{_mandir}/man4/

install -m644 %SOURCE0 $RPM_BUILD_ROOT/etc/crontab
install -m755 %SOURCE1 $RPM_BUILD_ROOT/usr/bin/run-parts
install -m644 %SOURCE2 $RPM_BUILD_ROOT/%{_mandir}/man4/

mkdir -p $RPM_BUILD_ROOT/etc/sysconfig/
touch $RPM_BUILD_ROOT/etc/sysconfig/run-parts

# Populate files for webmin plugin package
pushd crontabs-webmin
# fix shell directives in perl files
(find ./ -name "*.cgi"; find ./ -name "*.pl") | xargs sed -i '0,\_^#!/usr/local/bin/perl_ s_^#!/usr/local/bin/perl_#!/usr/bin/perl_'
# add config-operating-system file
cp ./config-generic-linux ./config-operating-system
popd
mkdir -p -m755 $RPM_BUILD_ROOT/usr/libexec/webmin/cron
cp -rp crontabs-webmin/* $RPM_BUILD_ROOT/usr/libexec/webmin/cron/
echo rpm >$RPM_BUILD_ROOT/usr/libexec/webmin/cron/install-type


%clean
rm -rf $RPM_BUILD_ROOT

%post webmin
# copy config file to /etc/webmin or /etc/usermin
os_type=`grep "^os_type=" /etc/webmin/config | sed -e 's/os_type=//g'`
os_version=`grep "^os_version=" /etc/webmin/config | sed -e 's/os_version=//g'`
/usr/bin/perl /usr/libexec/webmin/copyconfig.pl $os_type $os_version /usr/libexec/webmin /etc/webmin cron

# update the acl for the root user, or the first user in the acl
grep "^root:" /etc/webmin/webmin.acl >/dev/null
if [ "$?" = "0" ]; then
    user=root
else
    user=`head -1 /etc/webmin/webmin.acl | cut -f 1 -d :`
    fi
mods=`grep $user: /etc/webmin/webmin.acl | cut -f 2 -d :`
echo $mods | grep " cron" >/dev/null
if [ "$?" != "0" ]; then
    grep -v ^$user: /etc/webmin/webmin.acl > /tmp/webmin.acl.tmp
    echo $user: $mods cron > /etc/webmin/webmin.acl
    cat /tmp/webmin.acl.tmp >> /etc/webmin/webmin.acl
    rm -f /tmp/webmin.acl.tmp
fi
rm -f /etc/webmin/module.infos.cache
cd /usr/libexec/webmin
WEBMIN_CONFIG=/etc/webmin WEBMIN_VAR=/var/webmin /usr/libexec/webmin/run-postinstalls.pl cron

%preun webmin
cd /usr/libexec/webmin
WEBMIN_CONFIG=/etc/webmin WEBMIN_VAR=/var/webmin /usr/libexec/webmin/run-uninstalls.pl cron
/bin/true

%postun webmin
sed -i 's/cron//g' /etc/webmin/webmin.acl
rm -f /etc/webmin/module.infos.cache
rm -rf /etc/webmin/cron

%files
%defattr(-,root,root,-)
%config(noreplace) /etc/crontab
%attr(0644,root,root) %config(noreplace) /etc/sysconfig/run-parts
%{_bindir}/run-parts
%dir /etc/cron.hourly
%dir /etc/cron.daily
%dir /etc/cron.weekly
%dir /etc/cron.monthly
%{_mandir}/man4/*

%files webmin
%defattr(-,root,root)
/usr/libexec/webmin/cron

%changelog
* Wed May 15 2013 baseuser@ibm.com
- Base-8.x spec file
