%global with_python3 0

%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(0)")}

%global oname  pyinotify

Summary:       Monitor filesystem events with Python under Linux
Name:          python-inotify
Version:       0.9.4
%define base_release .1
Release:       2%{?dist}%{?base_release}
License:       MIT
Group:         Development/Libraries
URL:           https://github.com/seb-m/pyinotify
Source0:       http://seb.dbzteam.org/pub/pyinotify/releases/pyinotify-%{version}.tar.gz
Source1:       %{oname}
BuildRequires: python-devel
%if 0%{?with_python3}
BuildRequires: python3-devel
%endif
BuildArch:     noarch
BuildRoot:     %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

%description
This is a Python module for watching filesystems changes. pyinotify
can be used for various kind of fs monitoring. pyinotify relies on a
recent Linux Kernel feature (merged in kernel 2.6.13) called
inotify. inotify is an event-driven notifier, its notifications are
exported from kernel space to user space.

%package       examples
Summary:       Examples for Python inotify module
Group:         Development/Libraries
Requires:      python-inotify = %{version}-%{release}

%description   examples
This package includes some examples usage of the Python inotify module.

%if 0%{?with_python3}
%package -n    python3-inotify
Summary:       Monitor filesystem events with Python under Linux
Group:         Development/Languages

%description -n python3-inotify
This is a Python 3 module for watching filesystems changes. pyinotify
can be used for various kind of fs monitoring. pyinotify relies on a
recent Linux Kernel feature (merged in kernel 2.6.13) called
inotify. inotify is an event-driven notifier, its notifications are
exported from kernel space to user space.

This is the Python 3 build of pyinotify
%endif # if with_python3

%prep
%setup -q -n %{oname}-%{version}

%if 0%{?with_python3}
%{__rm} -rf %{py3dir}
cp -a . %{py3dir}
%endif

%build
%{__python} setup.py build

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif

%install
%{__rm} -rf %{buildroot}

# Install python 3 first, so that python 2 gets precedence:
%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install -O1 --skip-build --root %{buildroot}
%{__install} -D -m 0755 -p %{SOURCE1} %{buildroot}%{_bindir}/python3-%{oname}
%{__sed} -i -e 's/^python /python3 /' %{buildroot}%{_bindir}/python3-%{oname}
%{__chmod} 0755 %{buildroot}%{python3_sitelib}/%{oname}.py
popd
%endif

%{__python} setup.py install -O1 --skip-build --root %{buildroot}
%{__install} -D -m 0755 -p %{SOURCE1} %{buildroot}%{_bindir}/%{oname}
%{__chmod} 0755 %{buildroot}%{python_sitelib}/%{oname}.py

# examples
%{__install} -d -m 0755 %{buildroot}%{_datadir}/%{oname}
%{__cp} -a python2/examples/* %{buildroot}%{_datadir}/%{oname}

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-, root, root, -)
%doc ACKS COPYING README.md
%{_bindir}/%{oname}
%{python_sitelib}/%{oname}*

%files examples
%defattr(-, root, root, -)
%{_datadir}/%{oname}

%if 0%{?with_python3}
%files -n python3-inotify
%defattr(-, root, root, -)
%doc ACKS COPYING README.md
%{_bindir}/python3-%{oname}
%{python3_sitelib}/%{oname}*
%if 0%{?fedora} > 14 || 0%{?base} > 14
%{python3_sitelib}/__pycache__/%{oname}*
%endif
%endif

%changelog
* Tue Jul 15 2014 baseuser@ibm.com
- Base-f19.x spec file
