Name: anyterm
Version: 1.1.29
%define base_release .2
Release: 18%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Summary: A web-based terminal emulator

Group: Applications/Internet
License: GPLv2+
URL: http://anyterm.org

Source0: http://anyterm.org/download/anyterm-1.1.29.tbz2
Source1: anyterm-cmd
Source4: anyterm.conf
Source5: anyterm.service

# http://anyterm.org/1.1/install.html#secid2252601
Patch0: anyterm-change-url-prefix.patch

# http://anyterm.org/forums/viewtopic.php?id=581
Patch1: anyterm-libpbe-fix.patch

# boost 1.53 compatibility
Patch2: anyterm-1.1.29-boostclassic.patch

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
BuildRequires: boost-devel  
BuildRequires: zlib-devel
BuildRequires: prelink
BuildRequires: systemd-units
Requires(pre): shadow-utils
Requires(post): systemd-units
Requires(preun): systemd-units
Requires(postun): systemd-units
Requires(post): systemd-sysv


%package httpd
Summary: Httpd proxy configuration for anyterm
Group: Applications/Internet
License: GPLv2+
Requires: %{name} = %{version}-%{release}
Requires: httpd


%description
The Anyterm web-based terminal emulator, permits terminal and/or arbitrary
command access via http. The anyterm daemon can be configured to run any
arbitrary command, redirecting all standard input / output / error to 
and from any javascript-enabled web browser in real time.

%description httpd
The httpd configuration necessary to proxy anyterm.

%prep
%setup -q
%patch0 -p0
cd libpbe/
%patch1 -p0
cd ..
%patch2 -p1

%build
export CFLAGS="$RPM_OPT_FLAGS"
export CXXFLAGS="$RPM_OPT_FLAGS"
%{__make} %{?_smp_mflags} CFLAGS="$CFLAGS" CXXFLAGS="$CXXFLAGS"
%{__gzip} anytermd.1
execstack -c anytermd

%install
%{__rm} -rf %{buildroot}

%{__install} -Dp -m0755 anytermd %{buildroot}%{_sbindir}/anytermd
%{__install} -Dp -m0644 anytermd.1.gz %{buildroot}%{_mandir}/man1/anytermd.1.gz
%{__install} -Dp -m0755 %{SOURCE1} %{buildroot}%{_libexecdir}/%{name}/anyterm-cmd
%{__install} -Dp -m0644 %{SOURCE4} %{buildroot}%{_sysconfdir}/httpd/conf.d/anyterm.conf
%{__install} -Dp -m0644 %{SOURCE5} %{buildroot}%{_unitdir}/anyterm.service

%{__mkdir} -p %{buildroot}%{_datadir}/anyterm/
for f in browser/*.{html,css,js,png,gif}; do
   %{__install} -m644 "$f" %{buildroot}%{_datadir}/anyterm/
done

# Create a home directory for the user.
%{__mkdir} -p -m755 %{buildroot}%{_localstatedir}/run/%{name}
mkdir -p %{buildroot}%{_sysconfdir}/tmpfiles.d
cat <<EOF > %{buildroot}%{_sysconfdir}/tmpfiles.d/%{name}.conf
d %{_localstatedir}/run/%{name} 0755 root %{name}
EOF


%clean
rm -rf %{buildroot}

%pre
# create anyterm group / user
getent group %{name} >/dev/null 2>&1 || \
   groupadd -r %{name}
getent passwd %{name} >/dev/null 2>&1 || \
  useradd -r -l -g %{name} -s /sbin/nologin \
  -d %{_localstatedir}/run/%{name} -c "Anyterm service" %{name}
if [[ ! -d %{_localstatedir}/run/%{name} ]]; then
  mkdir -m755 %{_localstatedir}/run/%{name}
  chown %{name}:%{name} %{_localstatedir}/run/%{name}
fi
if [[ $(getent passwd %{name} | cut -d: -f6) == /dev/null ]]; then
  usermod -d %{_localstatedir}/run/%{name} %{name}
fi
exit 0

%post
if [ $1 -eq 1 ] ; then 
    # Initial installation 
    /bin/systemctl daemon-reload >/dev/null 2>&1 || :
fi

%preun
if [ $1 -eq 0 ] ; then
    # Package removal, not upgrade
    /bin/systemctl --no-reload disable anyterm.service > /dev/null 2>&1 || :
    /bin/systemctl stop anyterm.service > /dev/null 2>&1 || :
fi

%postun
/bin/systemctl daemon-reload >/dev/null 2>&1 || :
if [ $1 -ge 1 ] ; then
    # Package upgrade, not uninstall
    /bin/systemctl try-restart anyterm.service >/dev/null 2>&1 || :
fi

%triggerun -- anyterm < 1.1.29-12
/usr/bin/systemd-sysv-convert --save anyterm >/dev/null 2>&1 ||:
/sbin/chkconfig --del anyterm >/dev/null 2>&1 || :
/bin/systemctl try-restart anyterm.service >/dev/null 2>&1 || :

%files
%defattr(-,root,root,-)
%{_sbindir}/anytermd
%{_libexecdir}/anyterm/
%{_mandir}/man1/anytermd.1.gz
%{_datadir}/anyterm/
%{_unitdir}/anyterm.service
%ghost %attr(0755,%{name},%{name}) %dir %{_localstatedir}/run/%{name}
%{_sysconfdir}/tmpfiles.d/%{name}.conf
%doc LICENSE

%files httpd
%defattr(-,root,root,-)
%config(noreplace) %{_sysconfdir}/httpd/conf.d/anyterm.conf

%changelog
* Wed Jun 05 2013 baseuser@ibm.com
- Base-8.x spec file
