Summary: Programs which control basic system processes
Name: sysvinit
Version: 2.88
%define base_release .4
Release: 14.dsf%{?dist}%{?base_release}
License: GPLv2+
Group: System Environment/Base
Source: http://download.savannah.gnu.org/releases/sysvinit/sysvinit-%{version}dsf.tar.bz2
URL: http://savannah.nongnu.org/projects/sysvinit/
Patch1: sysvinit-2.78-man.patch
Patch2: sysvinit-2.86-autofsck.patch
Patch3: sysvinit-2.86-loginshell.patch
Patch4: sysvinit-2.86-inittab.patch
Patch5: sysvinit-2.86-single.patch
Patch6: sysvinit-2.88-quiet.patch
Patch14: sysvinit-2.88-ipv6.patch
Patch15: sysvinit-2.88-omit.patch
Patch16: sysvinit-2.88-wall-maxlines.patch
Patch17: sysvinit-2.88-wall-broadcast-message.patch
Patch18: sysvinit-2.88-newline.patch
Patch19: sysvinit-2.88-usrmove.patch
Buildroot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Requires: pam >= 0.66-5
Requires: filesystem >= 2.2.4-1
Requires: libselinux >= 1.21.10-1 libsepol >= 1.3.5
Requires: sysvinit-tools = %{version}-%{release}
Obsoletes: SysVinit < 2.86-17
Provides: SysVinit = %{version}-%{release}
BuildRequires: libselinux-devel >= 1.21.10-1 libsepol-devel >= 1.3.5

%description
The sysvinit package contains a group of processes that control
the very basic functions of your system. sysvinit includes the init
program, the first program started by the Linux kernel when the
system boots. Init then controls the startup, running, and shutdown
of all other programs.

%package tools
Summary: Tools used for process and utmp management.
Group: System Environment/Base
Provides: /sbin/pidof

%description tools
The sysvinit-tools package contains various tools used for process
management.

%prep
%setup -q -n sysvinit-%{version}dsf
# We use a shell, not sulogin. Other random man fixes go here (such as #192804)
%patch1 -p1 -b .manpatch
# Unlink /.autofsck on shutdown -f
%patch2 -p1 -b .autofsck
# Invoke single-user shell as a login shell (#105653)
%patch3 -p1 -b .loginshell
# Adjust examples in inittab(5) to more accurately reflect RH/Fedora
# usage (#173572)
%patch4 -p1 -b .inittabdocs
# Fix single user mode (#176348)
%patch5 -p1 -b .single
# Be less verbose when booted with 'quiet'
%patch6 -p1 -b .quiet
# Change accepted ipv6 addresses (#573346)
%patch14 -p1 -b .ipv6
# Add option to pidof to exclude similar processes to omitted processes (#632321)
%patch15 -p1 -b .omit
# Fix counting MAXLINES in wall
%patch16 -p1 -b .maxlines
# Raise limit for broadcast message
%patch17 -p1 -b .broadcast
# Deal with disappearing files and binaries with a newline in their name (#853081)
%patch18 -p1 -b .newline
# Move pidof and killall5
%patch19 -p1 -b .usrmove

%build
%ifarch sparcv9 sparc64 s390 s390x
export CFLAGS="$RPM_OPT_FLAGS -D_GNU_SOURCE -fPIE"
%else
export CFLAGS="$RPM_OPT_FLAGS -D_GNU_SOURCE -fpie"
%endif
make %{?_smp_mflags} CC="%{__cc}" LDFLAGS="-pie -Wl,-z,relro -Wl,-z,now -lcrypt" -C src

%install
rm -rf $RPM_BUILD_ROOT
for I in bin usr/{bin,include,sbin} %{_mandir}/man{1,3,5,8} etc var/run dev; do
	mkdir -p $RPM_BUILD_ROOT/$I
done
make -C src ROOT=$RPM_BUILD_ROOT MANDIR=%{_mandir} STRIP=/bin/true \
	BIN_OWNER=`id -nu` BIN_GROUP=`id -ng` install

rm -f $RPM_BUILD_ROOT/usr/sbin/bootlogd
rm -f $RPM_BUILD_ROOT/%{_mandir}/man8/bootlogd*
chmod 755 $RPM_BUILD_ROOT/usr/bin/utmpdump

# Remove these files, as we use upstart as /sbin/init.
rm -f $RPM_BUILD_ROOT/usr/sbin/{halt,init,poweroff,reboot,runlevel,shutdown,telinit}
rm -f $RPM_BUILD_ROOT/%{_includedir}/initreq.h
rm -f $RPM_BUILD_ROOT/%{_mandir}/man5/*
rm -f $RPM_BUILD_ROOT/%{_mandir}/man8/{halt,init,poweroff,reboot,runlevel,shutdown,telinit}*

# /sbin/fstab-decode is part of initscripts
rm -f $RPM_BUILD_ROOT/usr/sbin/fstab-decode
rm -f $RPM_BUILD_ROOT/%{_mandir}/man8/fstab-decode.8

# /bin/mountpoint is part of util-linux >= 2.20
rm -f $RPM_BUILD_ROOT/bin/mountpoint
rm -f $RPM_BUILD_ROOT/%{_mandir}/man1/mountpoint.*

# sulogin and utmpdump are part of util-linux
rm -f $RPM_BUILD_ROOT/usr/sbin/sulogin
rm -f $RPM_BUILD_ROOT/%{_mandir}/man8/sulogin.*
rm -f $RPM_BUILD_ROOT/usr/bin/utmpdump
rm -f $RPM_BUILD_ROOT/%{_mandir}/man1/utmpdump.*

# last, lastb, mesg and wall are also part of util-linux
rm -f $RPM_BUILD_ROOT/usr/bin/last
rm -f $RPM_BUILD_ROOT/usr/bin/lastb
rm -f $RPM_BUILD_ROOT/usr/bin/mesg
rm -f $RPM_BUILD_ROOT/usr/bin/wall
rm -f $RPM_BUILD_ROOT/%{_mandir}/man1/last.*
rm -f $RPM_BUILD_ROOT/%{_mandir}/man1/lastb.*
rm -f $RPM_BUILD_ROOT/%{_mandir}/man1/mesg.*
rm -f $RPM_BUILD_ROOT/%{_mandir}/man1/wall.*

%clean
rm -rf $RPM_BUILD_ROOT

%files tools
%defattr(-,root,root)
%doc doc/Changelog COPYRIGHT
%{_sbindir}/pidof
%{_sbindir}/killall5
%{_mandir}/man8/killall5*
%{_mandir}/man8/pidof*

%changelog
