%global _root_libdir	/%{_lib}
%global _root_sbindir 	/sbin

Name:		nilfs-utils
Version:	2.1.4
%define base_release .2
Release:	3%{?dist}%{?base_release}
Summary:	Utilities for managing NILFS v2 filesystems

Group:		System Environment/Base
License:	GPLv2+
URL:		http://www.nilfs.org
Source0:	http://www.nilfs.org/download/%{name}-%{version}.tar.bz2
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires:	libuuid-devel, libmount-devel

%description
Userspace utilities for creating and mounting NILFS v2 filesystems.

%package devel
Summary:	NILFS2 filesystem-specific headers
Group:		Development/Libraries
Requires:	nilfs-utils = %{version}-%{release}

%description devel
nilfs-utils-devel contains the header files needed to develop NILFS
filesystem-specific programs.

You should install nilfs-utils-devel if you want to develop NILFS
filesystem-specific programs. If you install nilfs-utils-devel, you'll
also want to install nilfs-utils.

%prep
%setup -q

%build
# geez, make install is trying to run ldconfig on the system
%configure LDCONFIG=/bin/true --disable-static --libdir %{_root_libdir}
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT
rm -f $RPM_BUILD_ROOT/%{_root_libdir}/libnilfs*.la

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc COPYING ChangeLog
%config(noreplace) /etc/nilfs_cleanerd.conf
%{_root_sbindir}/mkfs.nilfs2
%{_root_sbindir}/mount.nilfs2
%{_root_sbindir}/nilfs_cleanerd
%{_root_sbindir}/umount.nilfs2
%{_root_sbindir}/nilfs-tune
%{_root_sbindir}/nilfs-clean
%{_root_sbindir}/nilfs-resize
%{_root_libdir}/libnilfscleaner.so.*
%{_root_libdir}/libnilfsgc.so.*
%{_bindir}/chcp
%{_bindir}/dumpseg
%{_bindir}/lscp
%{_bindir}/lssu
%{_bindir}/mkcp
%{_bindir}/rmcp
%{_mandir}/man1/lscp.1.gz
%{_mandir}/man1/lssu.1.gz
%{_mandir}/man5/nilfs_cleanerd.conf.5.gz
%{_mandir}/man8/chcp.8.gz
%{_mandir}/man8/dumpseg.8.gz
%{_mandir}/man8/mkcp.8.gz
%{_mandir}/man8/mkfs.nilfs2.8.gz
%{_mandir}/man8/mount.nilfs2.8.gz
%{_mandir}/man8/nilfs.8.gz
%{_mandir}/man8/nilfs_cleanerd.8.gz
%{_mandir}/man8/rmcp.8.gz
%{_mandir}/man8/umount.nilfs2.8.gz
%{_mandir}/man8/nilfs-tune.8.gz
%{_mandir}/man8/nilfs-clean.8.gz
%{_mandir}/man8/nilfs-resize.8.gz
%{_root_libdir}/libnilfs.so.*

%files devel
%defattr(-,root,root,-)
%{_root_libdir}/libnilfs.so
%{_root_libdir}/libnilfscleaner.so
%{_root_libdir}/libnilfsgc.so
%{_includedir}/nilfs.h
%{_includedir}/nilfs2_fs.h
%{_includedir}/nilfs_cleaner.h

%changelog
* Fri Jul 12 2013 baseuser@ibm.com
- Base-8.x spec file
