Summary: The GNU macro processor
Name: m4
Version: 1.4.16
%define base_release .2
Release: 7%{?dist}%{?base_release}
License: GPLv3+
Group: Applications/Text
Source0: http://ftp.gnu.org/gnu/m4/m4-%{version}.tar.xz
Source1: http://ftp.gnu.org/gnu/m4/m4-%{version}.tar.xz.sig
Source999: fivextra.tar.bz2
URL: http://www.gnu.org/software/m4/
# Patch0: Temporary fix to avoid fails, already fixed in gnulib, this patch
#         should be removed after updating m4 to newer gnulib
Patch0: m4-1.4.16-readlink-einval.patch
# Patch1: Temporary fix to avoid build fails, this patch
#         should be removed after updateing m4 to newer gnulib
Patch1: m4-1.4.16-gnulib-gets.patch
Requires(post): /sbin/install-info
Requires(preun): /sbin/install-info
# Gnulib bundled - the library has been granted an exception, see https://fedorahosted.org/fpc/ticket/174
# Gnulib is not versioned, see m4 ChangeLog for approximate date of Gnulib copy
Provides: bundled(gnulib)

%description
A GNU implementation of the traditional UNIX macro processor.  M4 is
useful for writing text files which can be logically parsed, and is used
by many programs as part of their build process.  M4 has built-in
functions for including files, running shell commands, doing arithmetic,
etc.  The autoconf program needs m4 for generating configure scripts, but
not for running configure scripts.

Install m4 if you need a macro processor.

%package fivextra
Summary: Test for %{name} package
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}

%prep
%setup -q -a 999
%patch0 -p1 -b .readlink-einval
%patch1 -p1 -b .gnulib-gets
chmod 644 COPYING

%build
%configure
make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
make install INSTALL="%{__install} -p" DESTDIR=$RPM_BUILD_ROOT
rm -f $RPM_BUILD_ROOT%{_infodir}/dir

# Steps to package the gettext tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%check
make %{?_smp_mflags} check

%files
%doc AUTHORS COPYING ChangeLog NEWS README THANKS TODO
%{_bindir}/m4
%{_infodir}/*
%{_mandir}/man1/m4.1*

%post
if [ -f %{_infodir}/m4.info ]; then # --excludedocs?
    /sbin/install-info %{_infodir}/m4.info %{_infodir}/dir || :
fi

%preun
if [ "$1" = 0 ]; then
    if [ -f %{_infodir}/m4.info ]; then # --excludedocs?
        /sbin/install-info --delete %{_infodir}/m4.info %{_infodir}/dir || :
    fi
fi

%files fivextra
%{prefix}

%changelog
* Sun May 05 2013 baseuser@ibm.com
- Base-8.x spec file
