%define pkg_version 4.5
%define api_version 0.6.0

%global with_python3 1

%if 0%{?rhel} || 0%{?base}
%global with_python3 0
%endif

%{!?tcl_version: %global tcl_version %(echo 'puts $tcl_version' | tclsh)}
%{!?tcl_sitearch: %global tcl_sitearch %{_prefix}/%{_lib}/tcl%{tcl_version}}

%if ! 0%{?base:1}
# with speech dispatcher iff on Fedora:
%define with_speech_dispatcher 0%{?fedora}
%else 
%define with_speech_dispatcher 0
%endif

%ifarch %{ocaml_arches}
%define with_ocaml 1
%endif

# LTC: disable because of build problems with ocaml; we don't need it for now:
#  Error: libbrlapi_stubs.a no such file
%if 0%{?base}
%define with_ocaml 0
%endif

Name: brltty
Version: %{pkg_version}
%define base_release .3
Release: 5%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: %{cross_arches}
License: GPLv2+
Group: System Environment/Daemons
URL: http://mielke.cc/brltty/
Source0: http://mielke.cc/brltty/releases/%{name}-%{version}.tar.gz
Source1: brltty.service
Patch4: brltty-loadLibrary.patch
Summary: Braille display driver for Linux/Unix
BuildRequires: byacc glibc-kernheaders bluez-libs-devel
BuildRequires: systemd
# work around a bug in the install process:
Requires(post): coreutils
Requires(post): systemd
Requires(preun): systemd
Requires(postun): systemd

%description
BRLTTY is a background process (daemon) which provides
access to the Linux/Unix console (when in text mode)
for a blind person using a refreshable braille display.
It drives the braille display and provides complete
screen review functionality.
%if %{with_speech_dispatcher}
BRLTTY can also work with speech synthesizers; if you want to use it with
Speech Dispatcher, please install also package %{name}-speech-dispatcher.

%package speech-dispatcher
Summary: Speech Dispatcher driver for BRLTTY
Group: System Environment/Daemons
License: GPLv2+
BuildRequires: speech-dispatcher-devel
Requires: %{name} = %{pkg_version}-%{release}
%description speech-dispatcher
This package provides the Speech Dispatcher driver for BRLTTY.
%endif

%package docs
Summary: Documentation for BRLTTY
Group: System Environment/Daemons
License: GPLv2+
Requires: %{name} = %{pkg_version}-%{release}
BuildArch: noarch
%description docs
This package provides the documentation for BRLTTY.

%package xw
Summary: XWindow driver for BRLTTY
Group: System Environment/Daemons
License: GPLv2+
BuildRequires: libSM-devel libICE-devel libX11-devel libXaw-devel libXext-devel libXt-devel libXtst-devel
Requires: %{name} = %{pkg_version}-%{release}
%description xw
This package provides the XWindow driver for BRLTTY.

%package at-spi
Summary: AtSpi driver for BRLTTY
Group: System Environment/Daemons
# The data files are licensed under LGPLv2+, see the README file.
License: GPLv2+ and LGPLv2+
BuildRequires: at-spi-devel
Requires: %{name} = %{pkg_version}-%{release}
%description at-spi
This package provides the AtSpi driver for BRLTTY.

%package -n brlapi
Version: %{api_version}
Group: Applications/System
License: LGPLv2+
Summary: Application Programming Interface for BRLTTY
Requires: %{name} = %{pkg_version}-%{release}
%description -n brlapi
This package provides the run-time support for the Application
Programming Interface to BRLTTY.

Install this package if you have an application which directly accesses
a refreshable braille display.

%package -n brlapi-devel
Version: %{api_version}
Group: Development/System
License: LGPLv2+
Requires: brlapi = %{api_version}-%{release}
Summary: Headers, static archive, and documentation for BrlAPI

%description -n brlapi-devel
This package provides the header files, static archive, shared object
linker reference, and reference documentation for BrlAPI (the
Application Programming Interface to BRLTTY).  It enables the
implementation of applications which take direct advantage of a
refreshable braille display in order to present information in ways
which are more appropriate for blind users and/or to provide user
interfaces which are more specifically attuned to their needs.

Install this package if you are developing or maintaining an application
which directly accesses a refreshable braille display.

%package -n tcl-brlapi
Version: %{api_version}
Group: Development/System
License: LGPLv2+
Requires: brlapi = %{api_version}-%{release}
BuildRequires: tcl-devel
Summary: Tcl binding for BrlAPI
%description -n tcl-brlapi
This package provides the Tcl binding for BrlAPI.

%package -n python-brlapi
Version: %{api_version}
Group: Development/System
License: LGPLv2+
Requires: brlapi = %{api_version}-%{release}
BuildRequires: Cython
BuildRequires: python2-devel
Summary: Python binding for BrlAPI
%description -n python-brlapi
This package provides the Python binding for BrlAPI.

%if 0%{?with_python3}
%package -n python3-brlapi
Version: %{api_version}
Group: Development/System
License: LGPLv2+
Requires: brlapi = %{api_version}-%{release}
BuildRequires: Cython
BuildRequires: python3-devel
Summary: Python 3 binding for BrlAPI
%description -n python3-brlapi
This package provides the Python 3 binding for BrlAPI.
%endif

%package -n brlapi-java
Version: %{api_version}
Group: Development/System
License: LGPLv2+
Requires: brlapi = %{api_version}-%{release}
BuildRequires: jpackage-utils
# LTC: use IBM java
%{?base:BuildRequires: ibm-java-%{_arch}-sdk}
%{!?base:BuildRequires: java-devel}
Summary: Java binding for BrlAPI
%description -n brlapi-java
This package provides the Java binding for BrlAPI.

%if 0%{?with_ocaml}
%package -n ocaml-brlapi
Version: %{api_version}
Group: Development/System
License: LGPLv2+
Requires: brlapi = %{api_version}-%{release}
BuildRequires: ocaml
Summary: OCaml binding for BrlAPI
%description -n ocaml-brlapi
This package provides the OCaml binding for BrlAPI.
%endif


%define version %{pkg_version}

%prep
%setup -q
%patch4 -p1 -b .loadLibrary

%if 0%{?with_python3}
# Make a copy of the source tree for building the Python 3 module
rm -rf %{py3dir}
cp -a . %{py3dir}
%endif

%build
# Add the openjdk include directories to CPPFLAGS
#for i in -I/usr/lib/jvm/java/include{,/linux}; do
# LTC: add ibm java include dirs
for i in -I/opt/ibm/java-x86_64-70/include{,/linux}; do
      java_inc="$java_inc $i"
done
export CPPFLAGS="$java_inc"

export CFLAGS="%{optflags} -fno-strict-aliasing"
export CXXFLAGS="%{optflags} -fno-strict-aliasing"

# there is no curses packages in BuildRequires, so the package builds
# without them in mock; let's express this decision explicitly
configure_opts=" \
  %{?base:--disable-ocaml-bindings} \
  --disable-stripping \
  --without-curses \
%if %{with_speech_dispatcher}
  --with-speechd=%{_prefix} \
%endif
  --with-install-root=$RPM_BUILD_ROOT
  JAVA_HOME=/opt/ibm/java-%{_arch}-70 \
  JAVA_JAR_DIR=%{_jnidir} \
  JAVA_JNI_DIR=%{_libdir}/brltty \
  JAVA_JNI=yes"

# First build everything with Python 2 support
%configure $configure_opts PYTHON=%{__python2}
make %{?_smp_mflags}

%if 0%{?with_python3}
# ... and then do it again for the Python 3 module
pushd %{py3dir}
%configure $configure_opts PYTHON=%{__python3}
make %{?_smp_mflags}
popd
%endif

find . \( -path ./doc -o -path ./Documents \) -prune -o \
  \( -name 'README*' -o -name '*.txt' -o -name '*.html' -o \
     -name '*.sgml' -o -name '*.patch' -o \
     \( -path './Bootdisks/*' -type f -perm +ugo=x \) \) -print |
while read file; do
   mkdir -p doc/${file%/*} && cp -rp $file doc/$file || exit 1
done

find . -name '*.sgml' |
while read file; do
   iconv -f iso8859-1 -t utf-8 $file > $file.conv && mv -f $file.conv $file
done
find . -name '*.txt' |
while read file; do
   iconv -f iso8859-1 -t utf-8 $file > $file.conv && mv -f $file.conv $file
done
find . -name 'README*' |
while read file; do
   iconv -f iso8859-1 -t utf-8 $file > $file.conv && mv -f $file.conv $file
done

%install
# Python 2
make install JAVA_JAR_DIR=%{_jnidir} \
             JAVA_JNI_DIR=%{_libdir}/brltty \
             JAVA_JNI=yes

%if 0%{?with_python3}
# Python 3
pushd %{py3dir}
make install JAVA_JAR_DIR=%{_jnidir} \
             JAVA_JNI_DIR=%{_libdir}/brltty \
             JAVA_JNI=yes
popd
%endif

install -d -m 755 "${RPM_BUILD_ROOT}%{_sysconfdir}" "$RPM_BUILD_ROOT%{_mandir}/man5"
install -m 644 Documents/brltty.conf "${RPM_BUILD_ROOT}%{_sysconfdir}"
echo ".so man1/brltty.1" > $RPM_BUILD_ROOT%{_mandir}/man5/brltty.conf.5

install -Dpm 644 %{SOURCE1} $RPM_BUILD_ROOT%{_unitdir}/brltty.service

# clean up the manuals:
rm Documents/Manual-*/*/{*.mk,*.made,Makefile*}
mv Documents/BrlAPIref/{html,BrlAPIref}

# Don't want static lib
rm -rf $RPM_BUILD_ROOT/%{_libdir}/libbrlapi.a

%post
%systemd_post brltty.service

%preun
%systemd_preun brltty.service

%postun
%systemd_postun_with_restart brltty.service

%post   -n brlapi -p /sbin/ldconfig
%postun -n brlapi -p /sbin/ldconfig

%files
%config(noreplace) %{_sysconfdir}/brltty.conf
%{_sysconfdir}/brltty/
%{_unitdir}/brltty.service
%{_bindir}/brltty
%{_bindir}/brltty-*
%{_libdir}/brltty/
%exclude %{_libdir}/brltty/libbrlttybba.so
%exclude %{_libdir}/brltty/libbrlttybxw.so
%exclude %{_libdir}/brltty/libbrlapi_java.so
%if %{with_speech_dispatcher}
%exclude %{_libdir}/brltty/libbrlttyssd.so
%endif
%exclude %{_libdir}/brltty/libbrlttyxas.so
%doc LICENSE-GPL LICENSE-LGPL
%doc %{_mandir}/man[15]/brltty.*

%if %{with_speech_dispatcher}
%files speech-dispatcher
%doc Drivers/Speech/SpeechDispatcher/README
%{_libdir}/brltty/libbrlttyssd.so
%endif

%files docs
%doc Documents/ChangeLog Documents/TODO
%doc Documents/Manual-BRLTTY/
%doc doc/*

%files xw
%doc Drivers/Braille/XWindow/README
%{_libdir}/brltty/libbrlttybxw.so

%files at-spi
%{_libdir}/brltty/libbrlttyxas.so

%files -n brlapi
%{_bindir}/vstp
%{_bindir}/xbrlapi
%{_libdir}/brltty/libbrlttybba.so
%{_libdir}/libbrlapi.so.*
%doc Drivers/Braille/XWindow/README
%doc Documents/Manual-BrlAPI/
%doc %{_mandir}/man1/xbrlapi.*
%doc %{_mandir}/man1/vstp.*

%files -n brlapi-devel
%{_libdir}/libbrlapi.so
%{_includedir}/brltty
%{_includedir}/brlapi*.h
%doc %{_mandir}/man3/brlapi_*.3*
%doc Documents/BrlAPIref/BrlAPIref/

%files -n tcl-brlapi
%{tcl_sitearch}/brlapi-%{api_version}

%files -n python-brlapi
%{python_sitearch}/brlapi.so
%{python_sitearch}/Brlapi-%{api_version}-*.egg-info

%if 0%{?with_python3}
%files -n python3-brlapi
%{python3_sitearch}/brlapi.cpython-*.so
%{python3_sitearch}/Brlapi-%{api_version}-*.egg-info
%endif

%files -n brlapi-java
%{_libdir}/brltty/libbrlapi_java.so
%{_jnidir}/brlapi.jar

%if 0%{?with_ocaml}
%files -n ocaml-brlapi
%{_libdir}/ocaml/brlapi/
%{_libdir}/ocaml/stublibs/
%endif

%changelog
* Fri Jul 12 2013 baseuser@ibm.com
- Base-8.x spec file
