Name: libiscsi
Summary: iSCSI client library
Version: 1.7.0
%define base_release .2
Release: 4%{?dist}%{?base_release}
License: LGPLv2+
Group: System Environment/Libraries
URL: https://github.com/sahlberg/%{name}

Source: https://github.com/downloads/sahlberg/%{name}/%{name}-%{version}.tar.gz
Patch1: 0001-distribute-pkgconfig-file.patch
Patch2: 0002-use-libgcrypt-for-MD5.patch
Patch3: 0003-fix-crash-in-iscsi-tools.patch

BuildRequires: autoconf
BuildRequires: automake
BuildRequires: libtool
BuildRequires: popt-devel
BuildRequires: libgcrypt-devel

%description
libiscsi is a library for attaching to iSCSI resources across
a network.


#######################################################################

# Conflict with iscsi-initiator-utils.

%global libiscsi_includedir %{_includedir}/iscsi
%global libiscsi_libdir %{_libdir}/iscsi

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1

%build
## always run autogen.sh
./autogen.sh
%configure --libdir=%{libiscsi_libdir}
make %{?_smp_mflags}

%install
make DESTDIR=$RPM_BUILD_ROOT install pkgconfigdir=%{_libdir}/pkgconfig %{?_smp_mflags}
mkdir -p $RPM_BUILD_ROOT/etc/ld.so.conf.d
echo %{libiscsi_libdir} > $RPM_BUILD_ROOT/etc/ld.so.conf.d/%{name}-%{_arch}.conf
rm $RPM_BUILD_ROOT/%{libiscsi_libdir}/libiscsi.a
rm $RPM_BUILD_ROOT/%{libiscsi_libdir}/libiscsi.la
rm $RPM_BUILD_ROOT/%{_bindir}/ld_iscsi.so

# Remove "*.old" files
find $RPM_BUILD_ROOT -name "*.old" -exec rm -f {} \;

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
%doc COPYING LICENCE-LGPL-2.1.txt README TODO
%{libiscsi_libdir}/libiscsi.so.*
%config /etc/ld.so.conf.d/*

%package utils
Summary: iSCSI Client Utilities
Group: Applications/System
License: GPLv2+
Requires: %{name}%{?_isa} = %{version}-%{release}

%description utils
The libiscsi-utils package provides a set of assorted utilities to connect
to iSCSI servers without having to set up the Linux iSCSI initiator.

%files utils
%doc COPYING LICENCE-GPL-2.txt LICENCE-LGPL-2.1.txt README TODO
%{_bindir}/iscsi-ls
%{_bindir}/iscsi-inq
%{_bindir}/iscsi-readcapacity16

%package devel
Summary: iSCSI client development libraries
Group: Development/Libraries
Requires: %{name}%{?_isa} = %{version}-%{release}

%description devel
The libiscsi-devel package includes the header files for libiscsi.

%files devel
%defattr(-,root,root)
%doc COPYING LICENCE-LGPL-2.1.txt README TODO
%{libiscsi_includedir}/iscsi.h
%{libiscsi_includedir}/scsi-lowlevel.h
%{libiscsi_libdir}/libiscsi.so
%{_libdir}/pkgconfig/libiscsi.pc

%changelog
* Thu Jul 11 2013 baseuser@ibm.com
- Base-8.x spec file
