%if 0%{?base} > 19
%global with_python3 1
%else
%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print (get_python_lib(1))")}
%endif

%define libsepolver 2.1.9-1
%define libselinuxver 2.1.13-1

Summary: SELinux binary policy manipulation library 
Name: libsemanage
Version: 2.1.10
%define base_release .4
Release: 4%{?dist}%{?base_release}
# Base: exclude cross arches for this package
License: LGPLv2+
Group: System Environment/Libraries
Source: libsemanage-%{version}.tgz
Patch: libsemanage-rhat.patch
URL: http://oss.tresys.com/git/selinux.git
Source1: semanage.conf

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: libselinux-devel >= %{libselinuxver} swig ustr-devel
BuildRequires: libsepol-devel >= %{libsepolver} 
%if ! 0%{?cross_build}
BuildRequires: python-devel
%endif
BuildRequires: bison flex bzip2-devel
Requires: selinux-policy

%if 0%{?with_python3}
BuildRequires: python3-devel
%endif # if with_python3

Requires: bzip2-libs

%description
Security-enhanced Linux is a feature of the Linux® kernel and a number
of utilities with enhanced security functionality designed to add
mandatory access controls to Linux.  The Security-enhanced Linux
kernel contains new architectural components originally developed to
improve the security of the Flask operating system. These
architectural components provide general support for the enforcement
of many kinds of mandatory access control policies, including those
based on the concepts of Type Enforcement®, Role-based Access
Control, and Multi-level Security.

libsemanage provides an API for the manipulation of SELinux binary policies.
It is used by checkpolicy (the policy compiler) and similar tools, as well
as by programs like load_policy that need to perform specific transformations
on binary policies such as customizing policy boolean settings.

%package static
Summary: Static library used to build policy manipulation tools
Group: Development/Libraries
Requires: libsemanage-devel = %{version}-%{release}

%description static
The semanage-static package contains the static libraries 
needed for developing applications that manipulate binary policies. 

%package devel
Summary: Header files and libraries used to build policy manipulation tools
Group: Development/Libraries
Requires: libsemanage = %{version}-%{release} ustr

%description devel
The semanage-devel package contains the libraries and header files
needed for developing applications that manipulate binary policies. 

%if ! 0%{?cross_build}
%package python
Summary: semanage python bindings for libsemanage
Group: Development/Libraries
Requires: libsemanage = %{version}-%{release} 

%description python
The libsemanage-python package contains the python bindings for developing 
SELinux management applications. 

%if 0%{?with_python3}
%package python3
Summary: semanage python 3 bindings for libsemanage
Group: Development/Libraries
Requires: libsemanage = %{version}-%{release} 

%description python3
The libsemanage-python3 package contains the python 3 bindings for developing
SELinux management applications.
%endif # if with_python3
%endif # if ! cross_build

%prep
%setup -q
%patch -p2 -b .rhat

%build
# To support building the Python wrapper against multiple Python runtimes
# Define a function, for how to perform a "build" of the python wrapper against
# a specific runtime:
BuildPythonWrapper() {
  BinaryName=$1

  # Perform the build from the upstream Makefile:
  make \
    PYTHON=$BinaryName \
    CFLAGS="%{optflags} %{?base:-I/usr/include/python2.7}" LIBDIR="%{_libdir}" SHLIBDIR="%{_lib}" \
    pywrap
}

make clean
make CFLAGS="%{optflags}" swigify
make CFLAGS="%{optflags}" LIBDIR="%{_libdir}" SHLIBDIR="%{_lib}" all

%if ! 0%{?cross_build}
BuildPythonWrapper \
  %{__python}
  
%if 0%{?with_python3}
BuildPythonWrapper \
  %{__python3}
%endif # with_python3
%endif # ! cross_build

%install
InstallPythonWrapper() {
  BinaryName=$1

  make \
    PYTHON=$BinaryName \
    DESTDIR="${RPM_BUILD_ROOT}" LIBDIR="${RPM_BUILD_ROOT}%{_libdir}" SHLIBDIR="${RPM_BUILD_ROOT}/%{_libdir}" \
    install-pywrap
}

rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}/%{_libdir} 
mkdir -p ${RPM_BUILD_ROOT}%{_includedir} 
make DESTDIR="${RPM_BUILD_ROOT}" LIBDIR="${RPM_BUILD_ROOT}%{_libdir}" SHLIBDIR="${RPM_BUILD_ROOT}/%{_libdir}" install

%if ! 0%{?cross_build}
InstallPythonWrapper \
  %{__python} \
  .so

%if 0%{?with_python3}
InstallPythonWrapper \
  %{__python3} \
  $(python3-config --extension-suffix)
%endif # with_python3
%endif # ! cross_build
  
cp %{SOURCE1} ${RPM_BUILD_ROOT}/etc/selinux/semanage.conf
ln -sf  %{_libdir}/libsemanage.so.1 ${RPM_BUILD_ROOT}/%{_libdir}/libsemanage.so

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%config(noreplace) %{_sysconfdir}/selinux/semanage.conf
/%{_libdir}/libsemanage.so.1

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files static
%defattr(-,root,root)
%{_libdir}/libsemanage.a

%files devel
%defattr(-,root,root)
%{_libdir}/libsemanage.so
%{_libdir}/pkgconfig/libsemanage.pc
%dir %{_includedir}/semanage
%{_includedir}/semanage/*.h
%{_mandir}/man3/*
%{_mandir}/man5/*

%if ! 0%{?cross_build}
%files python
%defattr(-,root,root)
%{python_sitearch}/_semanage.so
%{python_sitearch}/semanage.py*

%if 0%{?with_python3}
%files python3
%defattr(-,root,root)
%{python3_sitearch}/*.so
%{python3_sitearch}/semanage.py*
%{python3_sitearch}/__pycache__/semanage*
%endif # if with_python3
%endif # if ! cross_build

%changelog
* Mon Jun 03 2013 baseuser@ibm.com
- Base-8.x spec file
